package com.liveperson.monitoring.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

/**
 * Created by ofira on 16/11/2015.
 */
public class LocalBroadcast {

    /**
     * Utils method to send local broadcast
     *
     * @param action - The broadcast action
     */
    public static void sendBroadcast(Context context, String action) {
        Intent sendIntent = new Intent(action);
        LocalBroadcastManager.getInstance(context).sendBroadcast(sendIntent);
    }

    /**
     * Utils method to send local broadcast with bundle
     *
     * @param action - The broadcast action
     * @param bundle - The Bundle of extras to add to this broadcast.
     */
    public static void sendBroadcast(Context context, String action, Bundle bundle) {
        Intent sendIntent = new Intent(action);
        sendIntent.putExtras(bundle);
        LocalBroadcastManager.getInstance(context).sendBroadcast(sendIntent);
    }

}
