package com.liveperson.monitoring.model

import org.json.JSONObject

/**
 * Created by nirni on 12/5/17.
 */
class EngagementWithSession(val sessionId : String, val visitorId : String, val pageId : String, var engagementDetailsList: List<EngagementDetails>?) {

    companion object {

        // Create EngagementWithSession from json
        operator fun invoke(engagementJson: String) : EngagementWithSession{
            var engagementDetailsList : MutableList<EngagementDetails>? = null
            val jsonObject = JSONObject(engagementJson)

            val sId = jsonObject.getString(ModelKeyNames.SESSION_ID)
            val vId = jsonObject.getString(ModelKeyNames.VISITOR_ID)
            val pId = jsonObject.getString(ModelKeyNames.PAGE_ID)

            // Construct array from the jsonArray
            val engagementDetailsJsonArray = jsonObject.optJSONArray(ModelKeyNames.ENGAGEMENT_DETAILS)
            if(engagementDetailsJsonArray != null) {
                engagementDetailsList = ArrayList(engagementDetailsJsonArray.length())

                for (i in 0 until engagementDetailsJsonArray.length()) {
                    val engagementDetailsJson = engagementDetailsJsonArray.getJSONObject(i)
                    val engagementDetails = EngagementDetails(engagementDetailsJson)
                    engagementDetailsList.add(engagementDetails)
                }
            }

            return EngagementWithSession(sId, vId, pId, engagementDetailsList)
        }
    }

}