/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.lp_monitoring_sdk.R;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.EngagementDetails;
import com.liveperson.monitoring.model.EngagementWithSession;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.model.ModelKeyNames;
import com.liveperson.monitoring.requests.AcCdnRequest;
import com.liveperson.monitoring.requests.BaseMonitoringRequest;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPEngagementResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u000f2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017H\u0014J\u0012\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001aH\u0014J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001aH\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/liveperson/monitoring/requests/GetEngagementRequest;", "Lcom/liveperson/monitoring/requests/BaseMonitoringRequest;", "context", "Landroid/content/Context;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/monitoring/sdk/MonitoringParams;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/EngagementCallback;", "(Landroid/content/Context;Ljava/util/List;Lcom/liveperson/monitoring/sdk/MonitoringParams;Lcom/liveperson/monitoring/sdk/callbacks/EngagementCallback;)V", "getCallback", "()Lcom/liveperson/monitoring/sdk/callbacks/EngagementCallback;", "buildClientProperties", "Lorg/json/JSONObject;", "buildRequestBody", "callErrorCallback", "", "monitoringErrorType", "Lcom/liveperson/monitoring/sdk/callbacks/MonitoringErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getEngagementLanguage", "engagementResponse", "", "getRequest", "Lcom/liveperson/infra/network/http/request/HttpRequest;", "getRequestUrl", "handleResponse", "response", "Companion", "monitoring_release"})
public final class GetEngagementRequest
extends BaseMonitoringRequest {
    @NotNull
    private final EngagementCallback callback;
    private static final String TAG = "GetEngagementRequest";
    private static final String OS_ANDROID = "ANDROID";
    private static final String DEVICE_FAMILY_MOBILE = "MOBILE";
    private static final String KEY_OS = "os";
    private static final String KEY_OS_VERSION = "osVersion";
    private static final String KEY_APP_VERSION = "appVersion";
    private static final String KEY_DEVICE_FAMILY = "deviceFamily";
    private static final String KEY_CLIENT_PROPERTIES = "clientProperties";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected HttpRequest getRequest() {
        return (HttpRequest)new HttpPostRequest(this.buildRequestUrl());
    }

    @Override
    @NotNull
    protected String getRequestUrl() {
        String string2 = this.getContext().getResources().getString(R.string.get_engagement_url);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026tring.get_engagement_url)");
        return string2;
    }

    @Override
    protected void handleResponse(@NotNull String response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        EngagementWithSession engagementWithSession = EngagementWithSession.Companion.invoke(response);
        Object object = engagementWithSession;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        MonitoringParamsCache monitoringParamsCache = this.getParamsCache();
        if (monitoringParamsCache != null) {
            monitoringParamsCache.setSessionId(((EngagementWithSession)it).getSessionId());
        }
        object = engagementWithSession;
        bl = false;
        bl2 = false;
        it = object;
        boolean bl4 = false;
        MonitoringParamsCache monitoringParamsCache2 = this.getParamsCache();
        if (monitoringParamsCache2 != null) {
            monitoringParamsCache2.setVisitorId(((EngagementWithSession)it).getVisitorId());
        }
        try {
            List<EngagementDetails> list = engagementWithSession.getEngagementDetailsList();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            object = list.get(0);
            bl = false;
            bl2 = false;
            it = (EngagementDetails)object;
            boolean bl5 = false;
            MonitoringParamsCache monitoringParamsCache3 = this.getParamsCache();
            if (monitoringParamsCache3 != null) {
                monitoringParamsCache3.setConnectorId(((EngagementDetails)it).getConnectorId());
            }
        }
        catch (NullPointerException e) {
            this.callErrorCallback(MonitoringErrorType.PARAMETER_MISSING, new IllegalArgumentException("No connectorId because EngagementDetails is null"));
            return;
        }
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this, engagementWithSession){
            final /* synthetic */ GetEngagementRequest this$0;
            final /* synthetic */ EngagementWithSession $engagementWithSession;

            public final void run() {
                this.this$0.getCallback().onSuccess(new LPEngagementResponse(this.$engagementWithSession));
            }
            {
                this.this$0 = getEngagementRequest;
                this.$engagementWithSession = engagementWithSession;
            }
        });
        this.getEngagementLanguage(response);
    }

    @Override
    protected void callErrorCallback(@NotNull MonitoringErrorType monitoringErrorType, @Nullable Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)monitoringErrorType), (String)"monitoringErrorType");
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this, monitoringErrorType, exception){
            final /* synthetic */ GetEngagementRequest this$0;
            final /* synthetic */ MonitoringErrorType $monitoringErrorType;
            final /* synthetic */ Exception $exception;

            public final void run() {
                this.this$0.getCallback().onError(this.$monitoringErrorType, this.$exception);
            }
            {
                this.this$0 = getEngagementRequest;
                this.$monitoringErrorType = monitoringErrorType;
                this.$exception = exception;
            }
        });
    }

    @Override
    @NotNull
    protected JSONObject buildRequestBody(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        JSONObject getEngagementBody = super.buildRequestBody(identities, monitoringParams);
        getEngagementBody.put(KEY_CLIENT_PROPERTIES, (Object)this.buildClientProperties());
        return getEngagementBody;
    }

    private final JSONObject buildClientProperties() {
        String string2;
        JSONObject clientProperties = new JSONObject();
        clientProperties.put(KEY_OS, (Object)OS_ANDROID);
        clientProperties.put(KEY_OS_VERSION, (Object)Build.VERSION.RELEASE);
        try {
            PackageInfo pInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 0);
            string2 = pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            string2 = "Unavailable";
        }
        String version = string2;
        clientProperties.put(KEY_APP_VERSION, (Object)version);
        clientProperties.put(KEY_DEVICE_FAMILY, (Object)DEVICE_FAMILY_MOBILE);
        return clientProperties;
    }

    private final void getEngagementLanguage(String engagementResponse) {
        String campaignId = null;
        String engagementId = null;
        String engagementRevision = null;
        try {
            JSONArray responseArray = new JSONObject(engagementResponse).getJSONArray(ModelKeyNames.ENGAGEMENT_DETAILS);
            JSONObject engagementDetails = new JSONObject(responseArray.get(0).toString());
            campaignId = engagementDetails.getString(ModelKeyNames.CAMPAIGN_ID);
            engagementId = engagementDetails.getString(ModelKeyNames.ENGAGEMENT_ID);
            engagementRevision = engagementDetails.getString(ModelKeyNames.ENGAGEMENT_REVISION);
        }
        catch (Exception exception) {
            LPMobileLog.e((String)TAG, (String)"Failed to parse engagement details.", (Throwable)exception);
            return;
        }
        new AcCdnRequest(campaignId, engagementId, engagementRevision).execute();
    }

    @NotNull
    public final EngagementCallback getCallback() {
        return this.callback;
    }

    public GetEngagementRequest(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull EngagementCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        super(context, identities, monitoringParams);
        this.callback = callback;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/liveperson/monitoring/requests/GetEngagementRequest$Companion;", "", "()V", "DEVICE_FAMILY_MOBILE", "", "KEY_APP_VERSION", "KEY_CLIENT_PROPERTIES", "KEY_DEVICE_FAMILY", "KEY_OS", "KEY_OS_VERSION", "OS_ANDROID", "TAG", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

