package com.liveperson.monitoring.requests

import android.content.Context
import android.text.TextUtils
import com.liveperson.infra.network.http.request.HttpPutRequest
import com.liveperson.infra.network.http.request.HttpRequest
import com.liveperson.lp_monitoring_sdk.R
import com.liveperson.monitoring.MonitoringFactory
import com.liveperson.monitoring.model.EngagementWithSession
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType
import com.liveperson.monitoring.sdk.callbacks.SdeCallback
import com.liveperson.monitoring.sdk.responses.LPSdeResponse
import org.json.JSONObject

/**
 * Created by nirni on 12/6/17.
 */
class SendSdeRequest(context: Context, identities: List<LPMonitoringIdentity>?, monitoringParams: MonitoringParams?, val callback: SdeCallback) :
        BaseMonitoringRequest(context, identities, monitoringParams, null) {

    companion object {
        // SendSdeRequest body params
        private const val KEY_PAGE_ID = "pageId"
    }

    override fun getRequest(): HttpRequest = HttpPutRequest(buildRequestUrl())

    override fun getRequestUrl(): String = context.resources.getString(R.string.send_sde_url)

    override fun handleResponse(response: String) {

        // Build the engagement from the request
        val engagement = EngagementWithSession(response)

        // Save the sessionId and/or visitorId if returned in the engagement
        engagement.sessionId.let { paramsCache?.sessionId = engagement.sessionId }
        engagement.visitorId.let { paramsCache?.visitorId = engagement.visitorId }

        MonitoringFactory.monitoring.postOnMainThread(Runnable {

            callback.onSuccess(LPSdeResponse(engagement))
        })
    }

    override fun buildRequestBody(identities: List<LPMonitoringIdentity>?, monitoringParams: MonitoringParams?): JSONObject {
        val engagementBody = super.buildRequestBody(identities, monitoringParams)

        if (!TextUtils.isEmpty(monitoringParams?.pageId)) {
            monitoringParams?.pageId?.let{ engagementBody.put(KEY_PAGE_ID, monitoringParams.pageId) }
        }

        return engagementBody
    }

    override fun callErrorCallback(monitoringErrorType: MonitoringErrorType,exception : Exception?) {

        MonitoringFactory.monitoring.postOnMainThread(Runnable {
            callback.onError(monitoringErrorType, exception)
        })

    }


}
