package com.liveperson.monitoring.connection

import android.content.Context
import com.liveperson.infra.auth.LPAuthenticationParams
import com.liveperson.monitoring.cache.MonitoringParamsCache
import com.liveperson.monitoring.connection.tasks.*
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback
import com.liveperson.monitoring.sdk.callbacks.SdeCallback
import com.liveperson.monitoring.utils.DomainBuilder

class MonitoringTaskHolder(val brandId: String,
                           val context: Context,
                           val paramsCache : MonitoringParamsCache) {

    fun constructUnAuthEngagementTasks(
        identities: List<LPMonitoringIdentity>?,
        monitoringParams: MonitoringParams?,
        callback: EngagementCallback
    ): MonitoringTaskHandler {
        val engagementTask = GetEngagementTask(context, identities, monitoringParams, callback)
        val csdsTask = CSDSTask(
            brandId,
            DomainBuilder.getCsdsDomain(context, brandId),
            paramsCache,
            null,
            callback,
            engagementTask
        )

        return csdsTask
    }

    fun constructAuthEngagementTasks(
        lpAuthenticationParams: LPAuthenticationParams,
        identities: List<LPMonitoringIdentity>?,
        monitoringParams: MonitoringParams?,
        callback: EngagementCallback
    ): MonitoringTaskHandler {
        val engagementTask = GetEngagementTask(context, identities, monitoringParams, callback)
        val idpTask = IdpTask(brandId, context, lpAuthenticationParams, paramsCache, callback, engagementTask!!)
        val accdnConnectorsTask = ACCDNConnectorsTask(brandId, lpAuthenticationParams, paramsCache, callback, idpTask!!)
        val csdsTask = CSDSTask(
            brandId,
            DomainBuilder.getCsdsDomain(context, brandId),
            paramsCache,
            null,
            callback,
            accdnConnectorsTask
        )
        return csdsTask
    }

    fun constructSendSDETasks(
        monitoringParams: MonitoringParams?,
        identities: List<LPMonitoringIdentity>?,
        callback: SdeCallback
    ): MonitoringTaskHandler {
        val sendSDETask = SendSDETask(context, identities, monitoringParams, callback)

        val csdsTask = CSDSTask(
            brandId,
            DomainBuilder.getCsdsDomain(context, brandId),
            paramsCache,
            null,
            callback,
            sendSDETask
        )
        return csdsTask
    }
}