/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.cache;

import android.content.Context;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.lp_monitoring_sdk.R;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.ParamsCache;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.utils.Clearable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020;H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020\u0004H\u0016J\b\u0010?\u001a\u00020+H\u0016J\u001c\u0010@\u001a\u00020+2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040BH\u0016J.\u0010C\u001a\u00020+2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040B2\u0006\u0010D\u001a\u00020\u00042\b\u0010E\u001a\u0004\u0018\u00010\u0004H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R(\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR(\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\u0005R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\u0005R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\u0005R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\b\"\u0004\b\"\u0010\u0005RD\u0010&\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010,\u001a\u00020+2\u0006\u0010\n\u001a\u00020+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00101\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\b\"\u0004\b3\u0010\u0005R\u001c\u00104\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\b\"\u0004\b6\u0010\u0005R(\u00107\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\b\"\u0004\b9\u0010\u0005\u00a8\u0006G"}, d2={"Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "Lcom/liveperson/monitoring/cache/ParamsCache;", "Lcom/liveperson/monitoring/utils/Clearable;", "brandId", "", "(Ljava/lang/String;)V", "acCdnDomain", "getAcCdnDomain", "()Ljava/lang/String;", "setAcCdnDomain", "value", "appInstallId", "getAppInstallId", "setAppInstallId", "getBrandId", "connectorId", "getConnectorId", "setConnectorId", "csdsMainDomain", "getCsdsMainDomain", "setCsdsMainDomain", "hostVersion", "getHostVersion", "idpDomain", "getIdpDomain", "setIdpDomain", "", "lastCsdsUpdateTimestamp", "getLastCsdsUpdateTimestamp", "()J", "setLastCsdsUpdateTimestamp", "(J)V", "loggosDomain", "getLoggosDomain", "setLoggosDomain", "Ljava/util/ArrayList;", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "Lkotlin/collections/ArrayList;", "monitoringIdentities", "getMonitoringIdentities", "()Ljava/util/ArrayList;", "setMonitoringIdentities", "(Ljava/util/ArrayList;)V", "", "sdkInfoSent", "getSdkInfoSent", "()Z", "setSdkInfoSent", "(Z)V", "sessionId", "getSessionId", "setSessionId", "sharkDomain", "getSharkDomain", "setSharkDomain", "visitorId", "getVisitorId", "setVisitorId", "clear", "", "clearAllDomains", "getServiceDomain", "serviceName", "isCsdsFilled", "updateCsdsDomains", "csdsDomains", "Ljava/util/HashMap;", "updateDomain", "csdsDomainKey", "oldDomainValue", "Companion", "monitoring_release"})
public class MonitoringParamsCache
implements ParamsCache,
Clearable {
    @Nullable
    private String csdsMainDomain;
    @Nullable
    private String sharkDomain;
    @Nullable
    private String loggosDomain;
    @Nullable
    private String idpDomain;
    @Nullable
    private String acCdnDomain;
    private long lastCsdsUpdateTimestamp;
    @Nullable
    private String sessionId;
    @Nullable
    private String visitorId;
    @Nullable
    private String connectorId;
    @Nullable
    private String appInstallId;
    private boolean sdkInfoSent;
    @NotNull
    private ArrayList<LPMonitoringIdentity> monitoringIdentities;
    @NotNull
    private final String brandId;
    private static final String TAG = "MonitoringParamsCache";
    @NotNull
    public static final String CSDS_SHARK_DOMAIN_KEY = "smt";
    @NotNull
    public static final String CSDS_LOGGOS_DOMAIN_KEY = "loggos";
    @NotNull
    public static final String CSDS_IDP_DOMAIN_KEY = "idp";
    @NotNull
    public static final String CSDS_ACCDN_DOMAIN_KEY = "acCdnDomain";
    @NotNull
    public static final String LAST_CSDS_UPDATE_TIMESTAMP_KEY = "lastCsdsUpdateTimestampKey";
    @NotNull
    public static final String SESSION_ID_KEY = "sessionIdKey";
    @NotNull
    public static final String VISITOR_ID_KEY = "visitorIdKey";
    @NotNull
    public static final String CONNECTOR_ID_KEY = "connectorIdKey";
    @NotNull
    public static final String APP_INSTALL_ID_KEY = "appInstallIdKey";
    @NotNull
    public static final String SDK_INFO_SEND_KEY = "sdkInfoSendKey";
    @NotNull
    public static final String MONITORING_IDENTITIES_KEY = "monitoringIdentitiesKey";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getCsdsMainDomain() {
        return this.csdsMainDomain;
    }

    public final void setCsdsMainDomain(@Nullable String string2) {
        this.csdsMainDomain = string2;
    }

    @Nullable
    public final String getSharkDomain() {
        return this.sharkDomain;
    }

    public final void setSharkDomain(@Nullable String string2) {
        this.sharkDomain = string2;
    }

    @Nullable
    public final String getLoggosDomain() {
        return this.loggosDomain;
    }

    public final void setLoggosDomain(@Nullable String string2) {
        this.loggosDomain = string2;
    }

    @Nullable
    public final String getIdpDomain() {
        return this.idpDomain;
    }

    public final void setIdpDomain(@Nullable String string2) {
        this.idpDomain = string2;
    }

    @Nullable
    public final String getAcCdnDomain() {
        return this.acCdnDomain;
    }

    public final void setAcCdnDomain(@Nullable String string2) {
        this.acCdnDomain = string2;
    }

    @NotNull
    public final String getHostVersion() {
        String string2 = PreferenceManager.getInstance().getStringValue("SDK_VERSION", "", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PreferenceManager.getIns\u2026alue(SDK_VERSION, \"\", \"\")");
        return string2;
    }

    public final long getLastCsdsUpdateTimestamp() {
        return this.lastCsdsUpdateTimestamp;
    }

    public final void setLastCsdsUpdateTimestamp(long value) {
        this.lastCsdsUpdateTimestamp = value;
        PreferenceManager.getInstance().setLongValue(LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId, value);
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(@Nullable String value) {
        this.sessionId = value;
        PreferenceManager.getInstance().setStringValue(SESSION_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getVisitorId() {
        return this.visitorId;
    }

    public final void setVisitorId(@Nullable String value) {
        this.visitorId = value;
        PreferenceManager.getInstance().setStringValue(VISITOR_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getConnectorId() {
        return this.connectorId;
    }

    public final void setConnectorId(@Nullable String value) {
        this.connectorId = value;
        PreferenceManager.getInstance().setStringValue(CONNECTOR_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getAppInstallId() {
        return this.appInstallId;
    }

    public final void setAppInstallId(@Nullable String value) {
        this.appInstallId = value;
        PreferenceManager.getInstance().setStringValue(APP_INSTALL_ID_KEY, this.brandId, value);
    }

    public final boolean getSdkInfoSent() {
        return this.sdkInfoSent;
    }

    public final void setSdkInfoSent(boolean value) {
        this.sdkInfoSent = value;
        PreferenceManager.getInstance().setBooleanValue(SDK_INFO_SEND_KEY, this.brandId, value);
    }

    @NotNull
    public final ArrayList<LPMonitoringIdentity> getMonitoringIdentities() {
        return this.monitoringIdentities;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMonitoringIdentities(@NotNull ArrayList<LPMonitoringIdentity> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.monitoringIdentities = value;
        Iterable iterable = value;
        boolean bl = false;
        if (!iterable.isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = value;
            String string2 = this.brandId;
            String string3 = MONITORING_IDENTITIES_KEY;
            PreferenceManager preferenceManager = PreferenceManager.getInstance();
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void identity;
                LPMonitoringIdentity lPMonitoringIdentity = (LPMonitoringIdentity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string4 = identity.getConsumerId() + " : " + identity.getIssuer();
                collection.add(string4);
            }
            collection = (List)destination$iv$iv;
            preferenceManager.setStringsSet(string3, string2, CollectionsKt.toMutableSet((Iterable)collection));
        }
    }

    @Override
    public boolean updateCsdsDomains(@NotNull HashMap<String, String> csdsDomains) {
        Intrinsics.checkParameterIsNotNull(csdsDomains, (String)"csdsDomains");
        boolean updated = false;
        if (csdsDomains.isEmpty()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000001, "updateCsdsDomains: no domains received");
            return false;
        }
        if (this.updateDomain(csdsDomains, CSDS_SHARK_DOMAIN_KEY, this.sharkDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_LOGGOS_DOMAIN_KEY, this.loggosDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_IDP_DOMAIN_KEY, this.idpDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_ACCDN_DOMAIN_KEY, this.acCdnDomain)) {
            updated = true;
        }
        this.setLastCsdsUpdateTimestamp(System.currentTimeMillis());
        return updated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String getServiceDomain(@NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        String domainToReturn = null;
        String string2 = serviceName;
        switch (string2.hashCode()) {
            case -1097337145: {
                if (!string2.equals(CSDS_LOGGOS_DOMAIN_KEY)) return domainToReturn;
                return this.loggosDomain;
            }
            case 104117: {
                if (!string2.equals(CSDS_IDP_DOMAIN_KEY)) return domainToReturn;
                return this.idpDomain;
            }
            case 114010: {
                if (!string2.equals(CSDS_SHARK_DOMAIN_KEY)) return domainToReturn;
                return this.sharkDomain;
            }
        }
        return domainToReturn;
    }

    @Override
    public boolean isCsdsFilled() {
        return this.sharkDomain != null;
    }

    @Override
    public void clear() {
        PreferenceManager.getInstance().remove(CSDS_SHARK_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(CSDS_LOGGOS_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(CSDS_IDP_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(CSDS_ACCDN_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId);
        PreferenceManager.getInstance().remove(SESSION_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(VISITOR_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(APP_INSTALL_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(SDK_INFO_SEND_KEY, this.brandId);
        PreferenceManager.getInstance().remove(MONITORING_IDENTITIES_KEY, this.brandId);
        this.csdsMainDomain = null;
        this.clearAllDomains();
        this.setLastCsdsUpdateTimestamp(0L);
        this.setSessionId(null);
        this.setVisitorId(null);
        this.setConnectorId(null);
        this.setAppInstallId(null);
        this.setSdkInfoSent(false);
        this.monitoringIdentities.clear();
    }

    private final void clearAllDomains() {
        this.sharkDomain = null;
        this.loggosDomain = null;
        this.acCdnDomain = null;
    }

    private final boolean updateDomain(HashMap<String, String> csdsDomains, String csdsDomainKey, String oldDomainValue) {
        boolean updated = false;
        String domain = csdsDomains.get(csdsDomainKey);
        if (domain != null) {
            PreferenceManager.getInstance().setStringValue(csdsDomainKey, this.brandId, domain);
            if (oldDomainValue != null && Intrinsics.areEqual((Object)domain, (Object)oldDomainValue) ^ true) {
                updated = true;
            }
            switch (csdsDomainKey) {
                case "smt": {
                    this.sharkDomain = domain;
                    break;
                }
                case "loggos": {
                    this.loggosDomain = domain;
                    break;
                }
                case "idp": {
                    this.idpDomain = domain;
                    break;
                }
                case "acCdnDomain": {
                    this.acCdnDomain = domain;
                    break;
                }
            }
        }
        return updated;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    /*
     * WARNING - void declaration
     */
    public MonitoringParamsCache(@NotNull String brandId) {
        Context context;
        Context context2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        this.brandId = brandId;
        this.monitoringIdentities = new ArrayList();
        this.sharkDomain = PreferenceManager.getInstance().getStringValue(CSDS_SHARK_DOMAIN_KEY, this.brandId, null);
        this.loggosDomain = PreferenceManager.getInstance().getStringValue(CSDS_LOGGOS_DOMAIN_KEY, this.brandId, null);
        this.idpDomain = PreferenceManager.getInstance().getStringValue(CSDS_IDP_DOMAIN_KEY, this.brandId, null);
        this.acCdnDomain = PreferenceManager.getInstance().getStringValue(CSDS_ACCDN_DOMAIN_KEY, this.brandId, null);
        this.setLastCsdsUpdateTimestamp(PreferenceManager.getInstance().getLongValue(LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId, 0L));
        this.setSessionId(PreferenceManager.getInstance().getStringValue(SESSION_ID_KEY, this.brandId, null));
        this.setVisitorId(PreferenceManager.getInstance().getStringValue(VISITOR_ID_KEY, this.brandId, null));
        this.setConnectorId(PreferenceManager.getInstance().getStringValue(CONNECTOR_ID_KEY, this.brandId, null));
        this.setAppInstallId(PreferenceManager.getInstance().getStringValue(APP_INSTALL_ID_KEY, this.brandId, null));
        this.setSdkInfoSent(PreferenceManager.getInstance().getBooleanValue(SDK_INFO_SEND_KEY, this.brandId, false));
        String string2 = this.brandId;
        Object object = MONITORING_IDENTITIES_KEY;
        Object object2 = PreferenceManager.getInstance();
        MonitoringParamsCache monitoringParamsCache = this;
        boolean bl = false;
        Set set = new LinkedHashSet();
        Set set2 = object2.getStringSet((String)object, string2, set);
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"PreferenceManager.getIns\u2026 mutableSetOf()\n        )");
        Iterable iterable = set2;
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void identity;
            String string3 = (String)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            void v1 = identity;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"identity");
            object = new LPMonitoringIdentity(StringsKt.substringBefore$default((String)v1, (String)":", null, (int)2, null), StringsKt.substringAfter$default((String)identity, (String)":", null, (int)2, null));
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        Collection collection = (Collection)object2;
        monitoringParamsCache.setMonitoringIdentities(new ArrayList<LPMonitoringIdentity>(collection));
        this.csdsMainDomain = StringsKt.startsWith$default((String)this.brandId, (String)"qa", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.brandId, (String)"le", (boolean)false, (int)2, null) ? ((context2 = MonitoringFactory.INSTANCE.getMonitoring().getApplicationContext()) != null && (context2 = context2.getResources()) != null ? context2.getString(R.string.csds_qa_url) : null) : ((context = MonitoringFactory.INSTANCE.getMonitoring().getApplicationContext()) != null && (context = context.getResources()) != null ? context.getString(R.string.csds_url) : null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/monitoring/cache/MonitoringParamsCache$Companion;", "", "()V", "APP_INSTALL_ID_KEY", "", "CONNECTOR_ID_KEY", "CSDS_ACCDN_DOMAIN_KEY", "CSDS_IDP_DOMAIN_KEY", "CSDS_LOGGOS_DOMAIN_KEY", "CSDS_SHARK_DOMAIN_KEY", "LAST_CSDS_UPDATE_TIMESTAMP_KEY", "MONITORING_IDENTITIES_KEY", "SDK_INFO_SEND_KEY", "SESSION_ID_KEY", "TAG", "VISITOR_ID_KEY", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

