package com.liveperson.monitoring

import android.content.Context
import com.liveperson.infra.auth.LPAuthenticationParams
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.sdk.MonitoringInternalInitParams
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback
import com.liveperson.monitoring.sdk.callbacks.SdeCallback

/**
 * Created by nirni on 11/21/17.
 */
object MonitoringFactory : IMonitoring{

    val monitoring = Monitoring()

    fun initMonitoring(monitoringInternalInitParams: MonitoringInternalInitParams) : Boolean {

        return monitoring.init(monitoringInternalInitParams)
    }

    override fun logout(): Boolean {

        return monitoring.logout()
    }

    override fun getEngagement(
        context: Context,
        identities: List<LPMonitoringIdentity>?,
        monitoringParams: MonitoringParams?,
        lpAuthenticationParams: LPAuthenticationParams?,
        callback: EngagementCallback
    ) {

        monitoring.getEngagement(context, identities, monitoringParams, lpAuthenticationParams, callback)

    }

    override fun sendSde(context: Context,identities: List<LPMonitoringIdentity>?, monitoringParams: MonitoringParams?, callback: SdeCallback) {

        monitoring.sendSde(context, identities, monitoringParams, callback)
    }

    override fun isInitialized() : Boolean = monitoring.isInitialized()
}
