package com.liveperson.monitoring.connection.tasks

import android.content.Context
import com.liveperson.infra.log.LPLog
import com.liveperson.monitoring.connection.MonitoringTaskHandler
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.requests.GetEngagementRequest
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback

class GetEngagementTask(val context: Context,
                        val identities: List<LPMonitoringIdentity>?,
                        val monitoringParams: MonitoringParams?,
                        val callback: EngagementCallback) : MonitoringTaskHandler {
    companion object {
        private const val TAG = "GetEngagementTask"
    }

    override fun execute(args: Map<String, Any?>) {
        LPLog.i(TAG, "executeNextTask: Starting $TAG")
        val token = args["token"].takeIf {
            it is String && it.isNotEmpty()
        }

        GetEngagementRequest(context, identities, monitoringParams, token as String?, callback).execute()
    }
}