package com.liveperson.monitoring.connection.tasks

import android.content.Context
import com.liveperson.infra.log.LPLog
import com.liveperson.monitoring.connection.MonitoringTaskHandler
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.requests.SendSdeRequest
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.SdeCallback

class SendSDETask(val context: Context,
                  val identities: List<LPMonitoringIdentity>?,
                  val monitoringParams: MonitoringParams?,
                  val callback: SdeCallback
) : MonitoringTaskHandler {
    companion object {
        private const val TAG = "SendSDETask"
    }

    override fun execute(args: Map<String, Any?>) {
        LPLog.i(TAG, "executeNextTask: Starting $TAG")
        SendSdeRequest(context, identities, monitoringParams, callback).execute()
    }
}