/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.connection;

import android.content.Context;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.connection.MonitoringTaskHandler;
import com.liveperson.monitoring.connection.tasks.ACCDNConnectorsTask;
import com.liveperson.monitoring.connection.tasks.CSDSTask;
import com.liveperson.monitoring.connection.tasks.GetEngagementTask;
import com.liveperson.monitoring.connection.tasks.IdpTask;
import com.liveperson.monitoring.connection.tasks.SendSDETask;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback;
import com.liveperson.monitoring.sdk.callbacks.SdeCallback;
import com.liveperson.monitoring.utils.DomainBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ(\u0010\u001c\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u001dJ0\u0010\u001e\u001a\u00020\u00102\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/liveperson/monitoring/connection/MonitoringTaskHolder;", "", "brandId", "", "context", "Landroid/content/Context;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "(Ljava/lang/String;Landroid/content/Context;Lcom/liveperson/monitoring/cache/MonitoringParamsCache;)V", "getBrandId", "()Ljava/lang/String;", "getContext", "()Landroid/content/Context;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "constructAuthEngagementTasks", "Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/monitoring/sdk/MonitoringParams;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/EngagementCallback;", "isRefreshEngagement", "", "constructSendSDETasks", "Lcom/liveperson/monitoring/sdk/callbacks/SdeCallback;", "constructUnAuthEngagementTasks", "monitoring_release"})
public final class MonitoringTaskHolder {
    @NotNull
    private final String brandId;
    @NotNull
    private final Context context;
    @NotNull
    private final MonitoringParamsCache paramsCache;

    public MonitoringTaskHolder(@NotNull String brandId, @NotNull Context context, @NotNull MonitoringParamsCache paramsCache) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)paramsCache, (String)"paramsCache");
        this.brandId = brandId;
        this.context = context;
        this.paramsCache = paramsCache;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @NotNull
    public final MonitoringTaskHandler constructUnAuthEngagementTasks(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull EngagementCallback callback2, boolean isRefreshEngagement) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        GetEngagementTask engagementTask = new GetEngagementTask(this.context, identities, monitoringParams, callback2, isRefreshEngagement);
        String string2 = DomainBuilder.getCsdsDomain(this.context, this.brandId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCsdsDomain(context, brandId)");
        CSDSTask csdsTask = new CSDSTask(this.brandId, string2, this.paramsCache, null, callback2, engagementTask);
        return csdsTask;
    }

    @NotNull
    public final MonitoringTaskHandler constructAuthEngagementTasks(@NotNull LPAuthenticationParams lpAuthenticationParams, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull EngagementCallback callback2, boolean isRefreshEngagement) {
        Intrinsics.checkNotNullParameter((Object)lpAuthenticationParams, (String)"lpAuthenticationParams");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        GetEngagementTask engagementTask = new GetEngagementTask(this.context, identities, monitoringParams, callback2, isRefreshEngagement);
        IdpTask idpTask = new IdpTask(this.brandId, this.context, lpAuthenticationParams, this.paramsCache, callback2, engagementTask);
        ACCDNConnectorsTask accdnConnectorsTask = new ACCDNConnectorsTask(this.brandId, lpAuthenticationParams, this.paramsCache, callback2, idpTask);
        String string2 = DomainBuilder.getCsdsDomain(this.context, this.brandId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCsdsDomain(context, brandId)");
        CSDSTask csdsTask = new CSDSTask(this.brandId, string2, this.paramsCache, null, callback2, accdnConnectorsTask);
        return csdsTask;
    }

    @NotNull
    public final MonitoringTaskHandler constructSendSDETasks(@Nullable MonitoringParams monitoringParams, @Nullable List<LPMonitoringIdentity> identities, @NotNull SdeCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        SendSDETask sendSDETask = new SendSDETask(this.context, identities, monitoringParams, callback2);
        String string2 = DomainBuilder.getCsdsDomain(this.context, this.brandId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCsdsDomain(context, brandId)");
        CSDSTask csdsTask = new CSDSTask(this.brandId, string2, this.paramsCache, null, callback2, sendSDETask);
        return csdsTask;
    }
}

