/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.connection.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.requests.ACCDNConnectorsRequest;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.connection.MonitoringTaskHandler;
import com.liveperson.monitoring.sdk.callbacks.IMonitoringCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPSdeResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\t\u0012\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u000e\u0010#\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\b\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/liveperson/monitoring/connection/tasks/ACCDNConnectorsTask;", "Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "brandId", "", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "Lcom/liveperson/monitoring/sdk/responses/LPSdeResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "nextTask", "(Ljava/lang/String;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/monitoring/cache/MonitoringParamsCache;Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;)V", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "getLpAuthenticationParams", "()Lcom/liveperson/infra/auth/LPAuthenticationParams;", "getNextTask", "()Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "execute", "", "args", "", "", "extractConnectorId", "data", "Lorg/json/JSONArray;", "getIssuerName", "onTaskError", "exception", "Companion", "monitoring_release"})
public final class ACCDNConnectorsTask
implements MonitoringTaskHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String brandId;
    @NotNull
    private final LPAuthenticationParams lpAuthenticationParams;
    @NotNull
    private final MonitoringParamsCache paramsCache;
    @NotNull
    private final IMonitoringCallback<? extends LPSdeResponse, Exception> callback;
    @NotNull
    private final MonitoringTaskHandler nextTask;
    @NotNull
    private static final String TAG = "ACCDNConnectorsTask";
    @NotNull
    private static final String CONFIGURATION_KEY = "configuration";
    @NotNull
    private static final String ISSUER_DISPLAY_NAME_KEY = "issuerDisplayName";
    @NotNull
    private static final String ID_KEY = "id";

    public ACCDNConnectorsTask(@NotNull String brandId, @NotNull LPAuthenticationParams lpAuthenticationParams, @NotNull MonitoringParamsCache paramsCache, @NotNull IMonitoringCallback<? extends LPSdeResponse, Exception> callback2, @NotNull MonitoringTaskHandler nextTask) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)lpAuthenticationParams, (String)"lpAuthenticationParams");
        Intrinsics.checkNotNullParameter((Object)paramsCache, (String)"paramsCache");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)nextTask, (String)"nextTask");
        this.brandId = brandId;
        this.lpAuthenticationParams = lpAuthenticationParams;
        this.paramsCache = paramsCache;
        this.callback = callback2;
        this.nextTask = nextTask;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final LPAuthenticationParams getLpAuthenticationParams() {
        return this.lpAuthenticationParams;
    }

    @NotNull
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @NotNull
    public final IMonitoringCallback<? extends LPSdeResponse, Exception> getCallback() {
        return this.callback;
    }

    @NotNull
    public final MonitoringTaskHandler getNextTask() {
        return this.nextTask;
    }

    @Override
    public void execute(@NotNull Map<String, ? extends Object> args) {
        String string2;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (this.getIssuerName() == null) {
            MonitoringTaskHandler.DefaultImpls.execute$default(this.nextTask, null, 1, null);
            return;
        }
        LPLog.INSTANCE.i(TAG, "executeNextTask: Starting ACCDNConnectorsTask");
        List certificates = this.lpAuthenticationParams.getCertificatePinningKeys();
        String it = string2 = this.paramsCache.getAcCdnDomain();
        boolean bl = false;
        CharSequence charSequence = it;
        String string3 = !(charSequence == null || charSequence.length() == 0) ? string2 : null;
        if (string3 == null) {
            ACCDNConnectorsTask $this$execute_u24lambda_u2d1 = this;
            boolean bl2 = false;
            $this$execute_u24lambda_u2d1.onTaskError(new Exception("Domain not found"));
            return;
        }
        String acCdnDomain = string3;
        new ACCDNConnectorsRequest(acCdnDomain, this.brandId, certificates, (ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ ACCDNConnectorsTask this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String value) {
                LPLog.INSTANCE.i("ACCDNConnectorsTask", "Successfully got connector information: " + value);
                CharSequence charSequence = value;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    try {
                        String connectorId = ACCDNConnectorsTask.access$extractConnectorId(this.this$0, new JSONArray(value));
                        this.this$0.getNextTask().execute(MapsKt.mapOf((Pair)TuplesKt.to((Object)"connectorId", (Object)connectorId)));
                    }
                    catch (Exception exception) {
                        ACCDNConnectorsTask.access$onTaskError(this.this$0, exception);
                    }
                } else {
                    MonitoringTaskHandler.DefaultImpls.execute$default(this.this$0.getNextTask(), null, 1, null);
                }
            }

            public void onError(@Nullable Exception exception) {
                ACCDNConnectorsTask.access$onTaskError(this.this$0, exception);
            }
        }).execute();
    }

    private final void onTaskError(Exception exception) {
        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000163, "Failed to get connector information: " + exception);
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(() -> ACCDNConnectorsTask.onTaskError$lambda-2(this, exception));
    }

    private final String extractConnectorId(JSONArray data) {
        String issuerDisplayName = this.getIssuerName();
        int n = data.length();
        for (int i = 0; i < n; ++i) {
            JSONObject connector = data.getJSONObject(i);
            if (!connector.has(ID_KEY) || !connector.has(CONFIGURATION_KEY)) continue;
            JSONObject configuration = connector.getJSONObject(CONFIGURATION_KEY);
            if (issuerDisplayName == null || !configuration.has(ISSUER_DISPLAY_NAME_KEY) || !StringsKt.equals((String)issuerDisplayName, (String)configuration.getString(ISSUER_DISPLAY_NAME_KEY), (boolean)true)) continue;
            String connectorId = connector.get(ID_KEY).toString();
            LPLog.INSTANCE.i(TAG, "Found valid connector id of " + issuerDisplayName + ": " + connectorId);
            return connectorId;
        }
        return null;
    }

    private final String getIssuerName() {
        String string2;
        String string3 = this.lpAuthenticationParams.getIssuerDisplayName();
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final void onTaskError$lambda-2(ACCDNConnectorsTask this$0, Exception $exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.callback.onError(MonitoringErrorType.ACCDN_ERROR, (Exception)((Throwable)$exception));
    }

    public static final /* synthetic */ String access$extractConnectorId(ACCDNConnectorsTask $this, JSONArray data) {
        return $this.extractConnectorId(data);
    }

    public static final /* synthetic */ void access$onTaskError(ACCDNConnectorsTask $this, Exception exception) {
        $this.onTaskError(exception);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/liveperson/monitoring/connection/tasks/ACCDNConnectorsTask$Companion;", "", "()V", "CONFIGURATION_KEY", "", "ID_KEY", "ISSUER_DISPLAY_NAME_KEY", "TAG", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

