/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.cache;

import android.content.Context;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.monitoring.R;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.ParamsCache;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.utils.Clearable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0001NB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020AH\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u0010D\u001a\u00020\u0004H\u0016J\b\u0010E\u001a\u000201H\u0016J6\u0010F\u001a\u0002012\"\u0010G\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040Hj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`I2\b\u0010J\u001a\u0004\u0018\u00010\u0004H\u0002J,\u0010K\u001a\u0002012\"\u0010G\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040Hj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`IH\u0016J>\u0010L\u001a\u0002012\"\u0010G\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040Hj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`I2\u0006\u0010M\u001a\u00020\u00042\b\u0010J\u001a\u0004\u0018\u00010\u0004H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R(\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR(\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\u0005R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\u0005R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\u0005R$\u0010!\u001a\u00020 2\u0006\u0010\n\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\b\"\u0004\b(\u0010\u0005RD\u0010,\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00102\u001a\u0002012\u0006\u0010\n\u001a\u000201@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R(\u00107\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\b\"\u0004\b9\u0010\u0005R\u001c\u0010:\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\b\"\u0004\b<\u0010\u0005R(\u0010=\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\b\"\u0004\b?\u0010\u0005\u00a8\u0006O"}, d2={"Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "Lcom/liveperson/monitoring/cache/ParamsCache;", "Lcom/liveperson/monitoring/utils/Clearable;", "brandId", "", "(Ljava/lang/String;)V", "acCdnDomain", "getAcCdnDomain", "()Ljava/lang/String;", "setAcCdnDomain", "value", "appInstallId", "getAppInstallId", "setAppInstallId", "getBrandId", "connectorId", "getConnectorId", "setConnectorId", "csdsMainDomain", "getCsdsMainDomain", "setCsdsMainDomain", "Lorg/json/JSONArray;", "entryPoints", "getEntryPoints", "()Lorg/json/JSONArray;", "setEntryPoints", "(Lorg/json/JSONArray;)V", "hostVersion", "getHostVersion", "idpDomain", "getIdpDomain", "setIdpDomain", "", "lastCsdsUpdateTimestamp", "getLastCsdsUpdateTimestamp", "()J", "setLastCsdsUpdateTimestamp", "(J)V", "loggosDomain", "getLoggosDomain", "setLoggosDomain", "Ljava/util/ArrayList;", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "Lkotlin/collections/ArrayList;", "monitoringIdentities", "getMonitoringIdentities", "()Ljava/util/ArrayList;", "setMonitoringIdentities", "(Ljava/util/ArrayList;)V", "", "sdkInfoSent", "getSdkInfoSent", "()Z", "setSdkInfoSent", "(Z)V", "sessionId", "getSessionId", "setSessionId", "sharkDomain", "getSharkDomain", "setSharkDomain", "visitorId", "getVisitorId", "setVisitorId", "clear", "", "clearAllDomains", "getServiceDomain", "serviceName", "isCsdsFilled", "updateAcCdnDomain", "csdsDomains", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "oldDomainValue", "updateCsdsDomains", "updateDomain", "csdsDomainKey", "Companion", "monitoring_release"})
public class MonitoringParamsCache
implements ParamsCache,
Clearable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String brandId;
    @Nullable
    private String csdsMainDomain;
    @Nullable
    private String sharkDomain;
    @Nullable
    private String loggosDomain;
    @Nullable
    private String idpDomain;
    @Nullable
    private String acCdnDomain;
    private long lastCsdsUpdateTimestamp;
    @Nullable
    private String sessionId;
    @Nullable
    private String visitorId;
    @Nullable
    private String connectorId;
    @Nullable
    private String appInstallId;
    private boolean sdkInfoSent;
    @NotNull
    private ArrayList<LPMonitoringIdentity> monitoringIdentities;
    @Nullable
    private JSONArray entryPoints;
    @NotNull
    private static final String TAG = "MonitoringParamsCache";
    @NotNull
    public static final String CSDS_SHARK_DOMAIN_KEY = "smt";
    @NotNull
    public static final String CSDS_LOGGOS_DOMAIN_KEY = "loggos";
    @NotNull
    public static final String CSDS_IDP_DOMAIN_KEY = "idp";
    @NotNull
    public static final String CSDS_ACCDN_DOMAIN_KEY = "acCdnDomain";
    @NotNull
    public static final String CSDS_ACCDN_DOMAIN_CONSUMER_SDK_KEY = "acCdnDomainConsumerSdk";
    @NotNull
    public static final String LAST_CSDS_UPDATE_TIMESTAMP_KEY = "lastCsdsUpdateTimestampKey";
    @NotNull
    public static final String SESSION_ID_KEY = "sessionIdKey";
    @NotNull
    public static final String VISITOR_ID_KEY = "visitorIdKey";
    @NotNull
    public static final String CONNECTOR_ID_KEY = "connectorIdKey";
    @NotNull
    public static final String APP_INSTALL_ID_KEY = "appInstallIdKey";
    @NotNull
    public static final String SDK_INFO_SEND_KEY = "sdkInfoSendKey";
    @NotNull
    public static final String MONITORING_IDENTITIES_KEY = "monitoringIdentitiesKey";
    @NotNull
    public static final String MONITORING_ENTRY_POINTS = "MONITORING_ENTRY_POINTS";

    /*
     * WARNING - void declaration
     */
    public MonitoringParamsCache(@NotNull String brandId) {
        Context context;
        Context context2;
        JSONArray jSONArray;
        MonitoringParamsCache monitoringParamsCache;
        String $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        this.brandId = brandId;
        this.monitoringIdentities = new ArrayList();
        this.entryPoints = new JSONArray();
        this.sharkDomain = PreferenceManager.getInstance().getStringValue(CSDS_SHARK_DOMAIN_KEY, this.brandId, null);
        this.loggosDomain = PreferenceManager.getInstance().getStringValue(CSDS_LOGGOS_DOMAIN_KEY, this.brandId, null);
        this.idpDomain = PreferenceManager.getInstance().getStringValue(CSDS_IDP_DOMAIN_KEY, this.brandId, null);
        this.acCdnDomain = PreferenceManager.getInstance().getStringValue(CSDS_ACCDN_DOMAIN_KEY, this.brandId, null);
        this.setLastCsdsUpdateTimestamp(PreferenceManager.getInstance().getLongValue(LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId, 0L));
        this.setSessionId(PreferenceManager.getInstance().getStringValue(SESSION_ID_KEY, this.brandId, null));
        this.setVisitorId(PreferenceManager.getInstance().getStringValue(VISITOR_ID_KEY, this.brandId, null));
        this.setConnectorId(PreferenceManager.getInstance().getStringValue(CONNECTOR_ID_KEY, this.brandId, null));
        this.setAppInstallId(PreferenceManager.getInstance().getStringValue(APP_INSTALL_ID_KEY, this.brandId, null));
        this.setSdkInfoSent(PreferenceManager.getInstance().getBooleanValue(SDK_INFO_SEND_KEY, this.brandId, false));
        Set set = PreferenceManager.getInstance().getStringSet(MONITORING_IDENTITIES_KEY, this.brandId, (Set)new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getInstance().getStringS\u2026 mutableSetOf()\n        )");
        Iterable iterable = set;
        MonitoringParamsCache monitoringParamsCache2 = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void identity;
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)identity, (String)"identity");
            collection.add(new LPMonitoringIdentity(StringsKt.substringBefore$default((String)identity, (String)":", null, (int)2, null), StringsKt.substringAfter$default((String)identity, (String)":", null, (int)2, null)));
        }
        Collection collection = (List)destination$iv$iv;
        monitoringParamsCache2.setMonitoringIdentities(new ArrayList<LPMonitoringIdentity>(collection));
        String entryPointsString = PreferenceManager.getInstance().getStringValue(MONITORING_ENTRY_POINTS, this.brandId, null);
        monitoringParamsCache2 = this;
        try {
            JSONArray jSONArray2;
            monitoringParamsCache = monitoringParamsCache2;
            String string3 = entryPointsString;
            if (string3 != null) {
                void it;
                $this$mapTo$iv$iv = string3;
                MonitoringParamsCache monitoringParamsCache3 = monitoringParamsCache;
                boolean bl = false;
                jSONArray2 = new JSONArray((String)it);
                monitoringParamsCache = monitoringParamsCache3;
            } else {
                jSONArray2 = null;
            }
            jSONArray = jSONArray2;
        }
        catch (JSONException it) {
            monitoringParamsCache = monitoringParamsCache2;
            LPLog.INSTANCE.w(TAG, "Failed to parse JSON array of entry points");
            jSONArray = null;
        }
        monitoringParamsCache.setEntryPoints(jSONArray);
        this.csdsMainDomain = StringsKt.startsWith$default((String)this.brandId, (String)"qa", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.brandId, (String)"le", (boolean)false, (int)2, null) ? ((context2 = MonitoringFactory.INSTANCE.getMonitoring().getApplicationContext()) != null && (context2 = context2.getResources()) != null ? context2.getString(R.string.csds_qa_url) : null) : ((context = MonitoringFactory.INSTANCE.getMonitoring().getApplicationContext()) != null && (context = context.getResources()) != null ? context.getString(R.string.csds_url) : null);
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @Nullable
    public final String getCsdsMainDomain() {
        return this.csdsMainDomain;
    }

    public final void setCsdsMainDomain(@Nullable String string2) {
        this.csdsMainDomain = string2;
    }

    @Nullable
    public final String getSharkDomain() {
        return this.sharkDomain;
    }

    public final void setSharkDomain(@Nullable String string2) {
        this.sharkDomain = string2;
    }

    @Nullable
    public final String getLoggosDomain() {
        return this.loggosDomain;
    }

    public final void setLoggosDomain(@Nullable String string2) {
        this.loggosDomain = string2;
    }

    @Nullable
    public final String getIdpDomain() {
        return this.idpDomain;
    }

    public final void setIdpDomain(@Nullable String string2) {
        this.idpDomain = string2;
    }

    @Nullable
    public final String getAcCdnDomain() {
        return this.acCdnDomain;
    }

    public final void setAcCdnDomain(@Nullable String string2) {
        this.acCdnDomain = string2;
    }

    @NotNull
    public final String getHostVersion() {
        String string2 = PreferenceManager.getInstance().getStringValue("SDK_VERSION", "", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInstance().getStringValue(SDK_VERSION, \"\", \"\")");
        return string2;
    }

    public final long getLastCsdsUpdateTimestamp() {
        return this.lastCsdsUpdateTimestamp;
    }

    public final void setLastCsdsUpdateTimestamp(long value) {
        this.lastCsdsUpdateTimestamp = value;
        PreferenceManager.getInstance().setLongValue(LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId, value);
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(@Nullable String value) {
        this.sessionId = value;
        PreferenceManager.getInstance().setStringValue(SESSION_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getVisitorId() {
        return this.visitorId;
    }

    public final void setVisitorId(@Nullable String value) {
        this.visitorId = value;
        PreferenceManager.getInstance().setStringValue(VISITOR_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getConnectorId() {
        return this.connectorId;
    }

    public final void setConnectorId(@Nullable String value) {
        this.connectorId = value;
        PreferenceManager.getInstance().setStringValue(CONNECTOR_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getAppInstallId() {
        return this.appInstallId;
    }

    public final void setAppInstallId(@Nullable String value) {
        this.appInstallId = value;
        PreferenceManager.getInstance().setStringValue(APP_INSTALL_ID_KEY, this.brandId, value);
    }

    public final boolean getSdkInfoSent() {
        return this.sdkInfoSent;
    }

    public final void setSdkInfoSent(boolean value) {
        this.sdkInfoSent = value;
        PreferenceManager.getInstance().setBooleanValue(SDK_INFO_SEND_KEY, this.brandId, value);
    }

    @NotNull
    public final ArrayList<LPMonitoringIdentity> getMonitoringIdentities() {
        return this.monitoringIdentities;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMonitoringIdentities(@NotNull ArrayList<LPMonitoringIdentity> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.monitoringIdentities = value;
        if (!((Collection)value).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = value;
            String string2 = this.brandId;
            String string3 = MONITORING_IDENTITIES_KEY;
            PreferenceManager preferenceManager = PreferenceManager.getInstance();
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void identity;
                LPMonitoringIdentity lPMonitoringIdentity = (LPMonitoringIdentity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(identity.getConsumerId() + " : " + identity.getIssuer());
            }
            collection = (List)destination$iv$iv;
            preferenceManager.setStringsSet(string3, string2, CollectionsKt.toMutableSet((Iterable)collection));
        }
    }

    @Nullable
    public final JSONArray getEntryPoints() {
        return this.entryPoints;
    }

    public final void setEntryPoints(@Nullable JSONArray value) {
        this.entryPoints = value;
        if (value != null) {
            PreferenceManager.getInstance().setStringValue(MONITORING_ENTRY_POINTS, this.brandId, value.toString());
        }
    }

    @Override
    public boolean updateCsdsDomains(@NotNull HashMap<String, String> csdsDomains) {
        Intrinsics.checkNotNullParameter(csdsDomains, (String)"csdsDomains");
        boolean updated = false;
        if (csdsDomains.isEmpty()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000001, "updateCsdsDomains: no domains received");
            return false;
        }
        if (this.updateDomain(csdsDomains, CSDS_SHARK_DOMAIN_KEY, this.sharkDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_LOGGOS_DOMAIN_KEY, this.loggosDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, CSDS_IDP_DOMAIN_KEY, this.idpDomain)) {
            updated = true;
        }
        if (this.updateAcCdnDomain(csdsDomains, this.acCdnDomain)) {
            updated = true;
        }
        this.setLastCsdsUpdateTimestamp(System.currentTimeMillis());
        return updated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String getServiceDomain(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        String domainToReturn = null;
        String string2 = serviceName;
        switch (string2.hashCode()) {
            case -1097337145: {
                if (string2.equals(CSDS_LOGGOS_DOMAIN_KEY)) return this.loggosDomain;
                return domainToReturn;
            }
            case 104117: {
                if (string2.equals(CSDS_IDP_DOMAIN_KEY)) return this.idpDomain;
                return domainToReturn;
            }
            case 114010: {
                if (!string2.equals(CSDS_SHARK_DOMAIN_KEY)) return domainToReturn;
                return this.sharkDomain;
            }
        }
        return domainToReturn;
    }

    @Override
    public boolean isCsdsFilled() {
        return this.sharkDomain != null;
    }

    @Override
    public void clear() {
        PreferenceManager.getInstance().remove(CSDS_SHARK_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(CSDS_LOGGOS_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(CSDS_IDP_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(CSDS_ACCDN_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId);
        PreferenceManager.getInstance().remove(SESSION_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(VISITOR_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(APP_INSTALL_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(SDK_INFO_SEND_KEY, this.brandId);
        PreferenceManager.getInstance().remove(MONITORING_IDENTITIES_KEY, this.brandId);
        PreferenceManager.getInstance().remove(MONITORING_ENTRY_POINTS, this.brandId);
        this.csdsMainDomain = null;
        this.clearAllDomains();
        this.setLastCsdsUpdateTimestamp(0L);
        this.setSessionId(null);
        this.setVisitorId(null);
        this.setConnectorId(null);
        this.setAppInstallId(null);
        this.setSdkInfoSent(false);
        this.monitoringIdentities.clear();
        this.setEntryPoints(null);
    }

    private final void clearAllDomains() {
        this.sharkDomain = null;
        this.loggosDomain = null;
        this.acCdnDomain = null;
    }

    private final boolean updateDomain(HashMap<String, String> csdsDomains, String csdsDomainKey, String oldDomainValue) {
        boolean updated;
        block17: {
            updated = false;
            String domain = csdsDomains.get(csdsDomainKey);
            if (domain == null) break block17;
            PreferenceManager.getInstance().setStringValue(csdsDomainKey, this.brandId, domain);
            if (oldDomainValue != null && !Intrinsics.areEqual((Object)domain, (Object)oldDomainValue)) {
                updated = true;
            }
            switch (csdsDomainKey) {
                case "smt": {
                    this.sharkDomain = domain;
                    break;
                }
                case "loggos": {
                    this.loggosDomain = domain;
                    break;
                }
                case "idp": {
                    this.idpDomain = domain;
                    break;
                }
                case "acCdnDomain": {
                    this.acCdnDomain = domain;
                }
            }
        }
        return updated;
    }

    private final boolean updateAcCdnDomain(HashMap<String, String> csdsDomains, String oldDomainValue) {
        String domain;
        boolean updated = false;
        if (((Map)csdsDomains).containsKey(CSDS_ACCDN_DOMAIN_CONSUMER_SDK_KEY) && (domain = csdsDomains.get(CSDS_ACCDN_DOMAIN_CONSUMER_SDK_KEY)) != null) {
            PreferenceManager.getInstance().setStringValue(CSDS_ACCDN_DOMAIN_KEY, this.brandId, domain);
            if (oldDomainValue != null && !Intrinsics.areEqual((Object)domain, (Object)oldDomainValue)) {
                updated = true;
            }
            this.acCdnDomain = domain;
            return updated;
        }
        updated = this.updateDomain(csdsDomains, CSDS_ACCDN_DOMAIN_KEY, oldDomainValue);
        return updated;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/monitoring/cache/MonitoringParamsCache$Companion;", "", "()V", "APP_INSTALL_ID_KEY", "", "CONNECTOR_ID_KEY", "CSDS_ACCDN_DOMAIN_CONSUMER_SDK_KEY", "CSDS_ACCDN_DOMAIN_KEY", "CSDS_IDP_DOMAIN_KEY", "CSDS_LOGGOS_DOMAIN_KEY", "CSDS_SHARK_DOMAIN_KEY", "LAST_CSDS_UPDATE_TIMESTAMP_KEY", "MONITORING_ENTRY_POINTS", "MONITORING_IDENTITIES_KEY", "SDK_INFO_SEND_KEY", "SESSION_ID_KEY", "TAG", "VISITOR_ID_KEY", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

