/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.content.Context;
import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 .2\u00020\u0001:\u0001.B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\u0019\u001a\u00020\nH\u0014J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` H$J\b\u0010!\u001a\u00020\u001bH\u0016J\u0012\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0004J\b\u0010$\u001a\u00020\nH\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\n2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010'\u001a\u00020(H$J\b\u0010)\u001a\u00020\nH$J \u0010*\u001a\u00020\u001b2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` 2\u0006\u0010+\u001a\u00020(H\u0014J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\nH$R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/liveperson/monitoring/requests/BaseMonitoringRequest;", "Lcom/liveperson/monitoring/Command;", "context", "Landroid/content/Context;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/monitoring/sdk/MonitoringParams;", "authToken", "", "(Landroid/content/Context;Ljava/util/List;Lcom/liveperson/monitoring/sdk/MonitoringParams;Ljava/lang/String;)V", "getAuthToken", "()Ljava/lang/String;", "baseSessionVisitorString", "getContext", "()Landroid/content/Context;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "retryCounter", "", "buildRequestBody", "Lorg/json/JSONObject;", "buildRequestUrl", "callErrorCallback", "", "monitoringErrorType", "Lcom/liveperson/monitoring/sdk/callbacks/MonitoringErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "execute", "extractAndSetVid", "message", "getIDPAnonymousUrl", "getOriginalConsumerId", "brandId", "getRequest", "Lcom/liveperson/infra/network/http/request/HttpRequest;", "getRequestUrl", "handleError", "httpRequest", "handleResponse", "response", "Companion", "monitoring_release"})
public abstract class BaseMonitoringRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final List<LPMonitoringIdentity> identities;
    @Nullable
    private final MonitoringParams monitoringParams;
    @Nullable
    private final String authToken;
    @NotNull
    private final String baseSessionVisitorString;
    @Nullable
    private final MonitoringParamsCache paramsCache;
    private int retryCounter;
    @NotNull
    private static final String TAG = "BaseMonitoringRequest";
    protected static final int NUM_OF_RETRIES = 4;
    @NotNull
    public static final String DEFAULT_AUTH_ACR = "loa1";
    @NotNull
    public static final String DEFAULT_UNAUTH_ACR = "0";
    @NotNull
    public static final String ISSUER = "iss";
    @NotNull
    public static final String ACR = "acr";
    @NotNull
    public static final String SUB = "sub";
    @NotNull
    public static final String TKN = "tkn";
    @NotNull
    private static final String KEY_CONSUMER_ID = "consumerId";
    @NotNull
    private static final String KEY_ENTRY_POINTS = "entryPoints";
    @NotNull
    private static final String KEY_ENGAGEMENT_ATTRIBUTES = "engagementAttributes";
    @NotNull
    private static final String KEY_IDENTITIES = "identities";

    public BaseMonitoringRequest(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @Nullable String authToken) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.identities = identities;
        this.monitoringParams = monitoringParams;
        this.authToken = authToken;
        this.baseSessionVisitorString = "&vid=%s&sid=%s";
        this.paramsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
        this.retryCounter = 1;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final String getAuthToken() {
        return this.authToken;
    }

    @Nullable
    protected final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @NotNull
    protected abstract HttpRequest getRequest();

    protected abstract void handleResponse(@NotNull String var1);

    protected abstract void callErrorCallback(@NotNull MonitoringErrorType var1, @Nullable Exception var2);

    @NotNull
    protected abstract String getRequestUrl();

    @Override
    public void execute() {
        HttpRequest httpRequest = this.getRequest();
        JSONObject body = this.buildRequestBody(this.identities, this.monitoringParams);
        LPJSONObjectBody httpPostBody = new LPJSONObjectBody(body);
        httpRequest.setBody((HttpRequestBody)httpPostBody);
        LPLog.INSTANCE.d(TAG, "Sending body: " + LPLog.INSTANCE.mask((Object)body.toString(4)));
        httpRequest.setCallback((ICallback)new ICallback<String, Exception>(this, httpRequest){
            final /* synthetic */ BaseMonitoringRequest this$0;
            final /* synthetic */ HttpRequest $httpRequest;
            {
                this.this$0 = $receiver;
                this.$httpRequest = $httpRequest;
            }

            public void onSuccess(@Nullable String value) {
                if (value != null) {
                    try {
                        JSONObject messageObject = new JSONObject(value);
                        LPLog.INSTANCE.d("BaseMonitoringRequest", "Response: " + LPLog.INSTANCE.mask((Object)messageObject.toString(4)));
                    }
                    catch (JSONException e) {
                        LPLog.INSTANCE.w("BaseMonitoringRequest", "Error parsing response: " + LPLog.INSTANCE.mask((Object)value), (Throwable)e);
                    }
                    this.this$0.handleResponse(value);
                } else {
                    LPLog.INSTANCE.w("BaseMonitoringRequest", "Error parsing response: value is null.");
                }
            }

            public void onError(@Nullable Exception exception) {
                String message;
                Exception exception2 = exception;
                String string2 = message = exception2 != null ? exception2.getMessage() : null;
                if (message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"internalCode\":20", (boolean)false, (int)2, null)) {
                    this.this$0.extractAndSetVid(message);
                    this.$httpRequest.setUrl(this.this$0.buildRequestUrl());
                    LPLog.INSTANCE.d("BaseMonitoringRequest", "Account is not loaded yet. Retry...");
                } else if (exception != null) {
                    LPLog.INSTANCE.w("BaseMonitoringRequest", "Request error.", (Throwable)exception);
                }
                this.this$0.handleError(exception, this.$httpRequest);
            }
        });
        HttpHandler.execute((HttpRequest)httpRequest);
    }

    protected final void extractAndSetVid(@Nullable String message) {
        if (message != null) {
            String temp = StringsKt.substringAfter$default((String)message, (String)"body:", null, (int)2, null);
            JSONObject jsonObject = new JSONObject(temp);
            String mess = jsonObject.getString("message");
            Intrinsics.checkNotNullExpressionValue((Object)mess, (String)"mess");
            String vid = StringsKt.substringAfter$default((String)mess, (String)"vid: ", null, (int)2, null);
            MonitoringParamsCache monitoringParamsCache = this.paramsCache;
            if (monitoringParamsCache != null) {
                monitoringParamsCache.setVisitorId(vid);
            }
        }
    }

    protected void handleError(@Nullable Exception exception, @NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        if (this.retryCounter > 4) {
            LPLog.INSTANCE.d(TAG, "Done with retries (retry number " + this.retryCounter + ").");
            if (exception != null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000052, "Error: ", (Throwable)exception);
            }
            this.callErrorCallback(MonitoringErrorType.REQUEST_ERROR, exception);
            return;
        }
        int n = this.retryCounter;
        this.retryCounter = n + 1;
        LPLog.INSTANCE.d(TAG, "Retry No. " + n);
        HttpHandler.executeDelayed((HttpRequest)httpRequest, (long)(this.retryCounter * 1000));
    }

    @NotNull
    protected String buildRequestUrl() {
        String requestUrlString;
        block3: {
            Object[] objectArray;
            String string2;
            block2: {
                string2 = this.getRequestUrl();
                objectArray = new Object[3];
                MonitoringParamsCache monitoringParamsCache = this.paramsCache;
                objectArray[0] = monitoringParamsCache != null ? monitoringParamsCache.getSharkDomain() : null;
                MonitoringParamsCache monitoringParamsCache2 = this.paramsCache;
                objectArray[1] = monitoringParamsCache2 != null ? monitoringParamsCache2.getBrandId() : null;
                MonitoringParamsCache monitoringParamsCache3 = this.paramsCache;
                objectArray[2] = monitoringParamsCache3 != null ? monitoringParamsCache3.getAppInstallId() : null;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                requestUrlString = string3;
                MonitoringParamsCache monitoringParamsCache4 = this.paramsCache;
                if ((monitoringParamsCache4 != null ? monitoringParamsCache4.getSessionId() : null) != null) break block2;
                MonitoringParamsCache monitoringParamsCache5 = this.paramsCache;
                if ((monitoringParamsCache5 != null ? monitoringParamsCache5.getVisitorId() : null) == null) break block3;
            }
            LPLog.INSTANCE.d(TAG, "SessionId and VisitorId exist. Add them as request params (SessionId=" + this.paramsCache.getSessionId() + ", VisitorId=" + this.paramsCache.getVisitorId() + ')');
            StringBuilder stringBuilder = new StringBuilder().append(requestUrlString);
            string2 = this.baseSessionVisitorString;
            objectArray = new Object[]{this.paramsCache.getVisitorId(), this.paramsCache.getSessionId()};
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            requestUrlString = stringBuilder.append(string4).toString();
        }
        return requestUrlString;
    }

    @NotNull
    protected JSONObject buildRequestBody(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        JSONObject getEngagementBody;
        block9: {
            MonitoringParams monitoringParams2;
            MonitoringParams it;
            getEngagementBody = new JSONObject();
            JSONArray identitiesBody = new JSONArray();
            List<LPMonitoringIdentity> list = identities;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LPMonitoringIdentity it2 = (LPMonitoringIdentity)element$iv;
                    boolean bl = false;
                    JSONObject identity = new JSONObject();
                    if (!TextUtils.isEmpty((CharSequence)it2.getConsumerId()) || !TextUtils.isEmpty((CharSequence)this.authToken)) {
                        if (!TextUtils.isEmpty((CharSequence)it2.getIssuer())) {
                            identity.put(ISSUER, (Object)it2.getIssuer());
                        }
                        identity.put(ACR, (Object)DEFAULT_AUTH_ACR);
                        if (it2.getConsumerId() != null) {
                            String id;
                            boolean bl2 = false;
                            identity.put(SUB, (Object)id);
                        }
                        if (this.authToken != null) {
                            String tkn;
                            boolean bl3 = false;
                            identity.put(TKN, (Object)tkn);
                        }
                    } else {
                        identity.put(ACR, (Object)DEFAULT_UNAUTH_ACR);
                        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
                        String brandId = monitoringParamsCache != null ? monitoringParamsCache.getBrandId() : null;
                        identity.put(ISSUER, (Object)this.getIDPAnonymousUrl());
                        String originalConsumerId = this.getOriginalConsumerId(brandId);
                        CharSequence charSequence = originalConsumerId;
                        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                            identity.put(SUB, (Object)originalConsumerId);
                        }
                    }
                    identitiesBody.put((Object)identity);
                }
            }
            getEngagementBody.put(KEY_IDENTITIES, (Object)identitiesBody);
            MonitoringParams monitoringParams3 = monitoringParams;
            if (monitoringParams3 != null && (monitoringParams3 = monitoringParams3.getEntryPoints()) != null) {
                it = monitoringParams3;
                boolean bl = false;
                getEngagementBody.put(KEY_ENTRY_POINTS, (Object)it);
            }
            if ((monitoringParams2 = monitoringParams) == null || (monitoringParams2 = monitoringParams2.getEngagementAttributes()) == null) break block9;
            it = monitoringParams2;
            boolean bl = false;
            getEngagementBody.put(KEY_ENGAGEMENT_ATTRIBUTES, (Object)it);
        }
        return getEngagementBody;
    }

    private final String getOriginalConsumerId(String brandId) {
        String originalConsumerId = null;
        if (Infra.instance.getConsumerManager().hasActiveConsumer()) {
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            originalConsumerId = consumer != null ? consumer.getOriginalConsumerId() : null;
        }
        return originalConsumerId;
    }

    private final String getIDPAnonymousUrl() {
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        String idpDomain = monitoringParamsCache != null ? monitoringParamsCache.getIdpDomain() : null;
        return "https://" + idpDomain;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/monitoring/requests/BaseMonitoringRequest$Companion;", "", "()V", "ACR", "", "DEFAULT_AUTH_ACR", "DEFAULT_UNAUTH_ACR", "ISSUER", "KEY_CONSUMER_ID", "KEY_ENGAGEMENT_ATTRIBUTES", "KEY_ENTRY_POINTS", "KEY_IDENTITIES", "NUM_OF_RETRIES", "", "SUB", "TAG", "TKN", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

