/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.ccuiConfig.CcuiWelcomeMessageStoreUtilsKt;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/monitoring/requests/GetWelcomeMessageRequest;", "Lcom/liveperson/monitoring/Command;", "windowId", "", "(Ljava/lang/String;)V", "mParamsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "execute", "", "getRequestUrl", "parseWelcomeMessageFromJson", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "wmJson", "Lorg/json/JSONObject;", "parseWindowConfigResponse", "windowConfigResponse", "Companion", "monitoring_release"})
public final class GetWelcomeMessageRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String windowId;
    @Nullable
    private MonitoringParamsCache mParamsCache;
    @NotNull
    private static final String TAG = "GetWelcomeMessageRequest";
    @NotNull
    private static final String WINDOW_CONFIG_URL = "https://%1$s/api/account/%2$s/configuration/engagement-window/window-confs/%3$s?v=1.0";
    @NotNull
    private static final String IS_ENABLE_KEY = "isEnabled";
    @NotNull
    private static final String WHEN_TO_PRESENT_KEY = "whenToPresent";
    @NotNull
    private static final String FREQUENCY_EVERY_TIME_VALUE = "EVERY_TIME";
    @NotNull
    private static final String TEXT_KEY = "text";
    @NotNull
    private static final String QUICK_REPLIES_KEY = "quickReplies";
    @NotNull
    private static final String JSON_KEY = "json";
    @NotNull
    private static final String WELCOME_MESSAGE_KEY = "welcomeMessage";

    public GetWelcomeMessageRequest(@NotNull String windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        this.windowId = windowId;
        this.mParamsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
    }

    @Override
    public void execute() {
        String windowConfUrl = this.getRequestUrl();
        LPLog.INSTANCE.d(TAG, "windowConfig request url: " + windowConfUrl);
        HttpGetRequest httpGetRequest = new HttpGetRequest(windowConfUrl, LPTraceType.ACCDN_WINDOW_CONFIG_REQ);
        httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ GetWelcomeMessageRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@NotNull String response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                LPLog.INSTANCE.d("GetWelcomeMessageRequest", "windowConfUrl response: " + response);
                GetWelcomeMessageRequest.access$parseWindowConfigResponse(this.this$0, response);
            }

            public void onError(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LPLog.INSTANCE.e("GetWelcomeMessageRequest", ErrorCode.ERR_0000016E, "Failed to get windowConf welcome message.", (Throwable)exception);
            }
        });
        HttpHandler.execute((HttpRequest)((HttpRequest)httpGetRequest));
    }

    private final void parseWindowConfigResponse(String windowConfigResponse) {
        try {
            LPWelcomeMessage welcomeMessage = null;
            JSONObject windowConfigJson = new JSONObject(windowConfigResponse);
            JSONObject jSONObject = windowConfigJson.optJSONObject(JSON_KEY);
            JSONObject welcomeMsgJson = jSONObject != null ? jSONObject.optJSONObject(WELCOME_MESSAGE_KEY) : null;
            JSONObject jSONObject2 = welcomeMsgJson;
            LPLog.INSTANCE.d(TAG, "welcomeMessage: " + (jSONObject2 != null ? jSONObject2.toString() : null));
            if (welcomeMsgJson != null) {
                welcomeMessage = this.parseWelcomeMessageFromJson(welcomeMsgJson);
            }
            MonitoringParamsCache monitoringParamsCache = this.mParamsCache;
            if ((monitoringParamsCache != null ? monitoringParamsCache.getBrandId() : null) != null) {
                Map<String, LPWelcomeMessage> map = MonitoringFactory.INSTANCE.getMonitoring().getWelcomeMessageMap();
                MonitoringParamsCache monitoringParamsCache2 = this.mParamsCache;
                String string2 = monitoringParamsCache2 != null ? monitoringParamsCache2.getBrandId() : null;
                Intrinsics.checkNotNull((Object)string2);
                map.put(string2, welcomeMessage);
                LPLog.INSTANCE.d(TAG, "Stored welcome message (" + welcomeMessage + ") from ccui");
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016F, "Failed to parse configured welcome message.", (Throwable)exception);
        }
    }

    private final LPWelcomeMessage parseWelcomeMessageFromJson(JSONObject wmJson) {
        Object object;
        LPWelcomeMessage $this$parseWelcomeMessageFromJson_u24lambda_u2d1_u24lambda_u2d0;
        LPWelcomeMessage lPWelcomeMessage;
        block5: {
            block4: {
                JSONObject $this$parseWelcomeMessageFromJson_u24lambda_u2d1 = wmJson;
                boolean bl = false;
                if (!wmJson.optBoolean(IS_ENABLE_KEY)) {
                    return null;
                }
                $this$parseWelcomeMessageFromJson_u24lambda_u2d1_u24lambda_u2d0 = lPWelcomeMessage = new LPWelcomeMessage($this$parseWelcomeMessageFromJson_u24lambda_u2d1.optString(TEXT_KEY));
                boolean bl2 = false;
                $this$parseWelcomeMessageFromJson_u24lambda_u2d1_u24lambda_u2d0.setMessageFrequency(Intrinsics.areEqual((Object)FREQUENCY_EVERY_TIME_VALUE, (Object)$this$parseWelcomeMessageFromJson_u24lambda_u2d1.optString(WHEN_TO_PRESENT_KEY, "")) ? LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION : LPWelcomeMessage.MessageFrequency.FIRST_TIME_CONVERSATION);
                JSONArray jSONArray = $this$parseWelcomeMessageFromJson_u24lambda_u2d1.optJSONArray(QUICK_REPLIES_KEY);
                object = jSONArray;
                if (object == null) break block4;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"optJSONArray(QUICK_REPLIES_KEY)");
                object = CcuiWelcomeMessageStoreUtilsKt.toMessageOptions(jSONArray);
                if (object != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        $this$parseWelcomeMessageFromJson_u24lambda_u2d1_u24lambda_u2d0.setMessageOptions((List)object);
        LPWelcomeMessage welcomeMessage = lPWelcomeMessage;
        return welcomeMessage;
    }

    private final String getRequestUrl() {
        String string2 = WINDOW_CONFIG_URL;
        Object[] objectArray = new Object[3];
        MonitoringParamsCache monitoringParamsCache = this.mParamsCache;
        objectArray[0] = monitoringParamsCache != null ? monitoringParamsCache.getAcCdnDomain() : null;
        MonitoringParamsCache monitoringParamsCache2 = this.mParamsCache;
        objectArray[1] = monitoringParamsCache2 != null ? monitoringParamsCache2.getBrandId() : null;
        objectArray[2] = this.windowId;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    public static final /* synthetic */ void access$parseWindowConfigResponse(GetWelcomeMessageRequest $this, String windowConfigResponse) {
        $this.parseWindowConfigResponse(windowConfigResponse);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/liveperson/monitoring/requests/GetWelcomeMessageRequest$Companion;", "", "()V", "FREQUENCY_EVERY_TIME_VALUE", "", "IS_ENABLE_KEY", "JSON_KEY", "QUICK_REPLIES_KEY", "TAG", "TEXT_KEY", "WELCOME_MESSAGE_KEY", "WHEN_TO_PRESENT_KEY", "WINDOW_CONFIG_URL", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

