package com.liveperson.monitoring

import android.content.Context
import com.liveperson.infra.auth.LPAuthenticationParams
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback
import com.liveperson.monitoring.sdk.callbacks.SdeCallback

/**
 * Created by nirni on 12/6/17.
 */
interface IMonitoring {

    /**
     * Get and engagement from the server and return it using the provided EngagementCallback
     */
    fun getEngagement(
        context: Context,
        identities: List<LPMonitoringIdentity>?,
        monitoringParams: MonitoringParams?,
        lpAuthenticationParams: LPAuthenticationParams?,
        callback: EngagementCallback,
        isRefreshEngagement: Boolean
    )

    /**
     * Send an SDE to the monitoring server
     */
    fun  sendSde(context: Context, identities: List<LPMonitoringIdentity>?, monitoringParams: MonitoringParams?, callback: SdeCallback)

    /**
     * Logout Monitoring SDK
     */
    fun logout(): Boolean

    /**
     * Indicates whether the Monitoring SDK is initialized
     */
    fun isInitialized() : Boolean

}
