/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.connection.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.requests.CSDSRequest;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.connection.MonitoringTaskHandler;
import com.liveperson.monitoring.connection.tasks.CSDSTask;
import com.liveperson.monitoring.sdk.callbacks.IMonitoringCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPSdeResponse;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\t\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/liveperson/monitoring/connection/tasks/CSDSTask;", "Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "brandId", "", "domain", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "Lcom/liveperson/monitoring/sdk/responses/LPSdeResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "nextTask", "(Ljava/lang/String;Ljava/lang/String;Lcom/liveperson/monitoring/cache/MonitoringParamsCache;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;)V", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "getDomain", "getLpAuthenticationParams", "()Lcom/liveperson/infra/auth/LPAuthenticationParams;", "getNextTask", "()Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "execute", "", "args", "", "", "Companion", "monitoring_release"})
public final class CSDSTask
implements MonitoringTaskHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String brandId;
    @NotNull
    private final String domain;
    @NotNull
    private final MonitoringParamsCache paramsCache;
    @Nullable
    private final LPAuthenticationParams lpAuthenticationParams;
    @NotNull
    private final IMonitoringCallback<? extends LPSdeResponse, Exception> callback;
    @NotNull
    private final MonitoringTaskHandler nextTask;
    @NotNull
    private static final String TAG = "CSDSTask";

    public CSDSTask(@NotNull String brandId, @NotNull String domain, @NotNull MonitoringParamsCache paramsCache, @Nullable LPAuthenticationParams lpAuthenticationParams, @NotNull IMonitoringCallback<? extends LPSdeResponse, Exception> callback2, @NotNull MonitoringTaskHandler nextTask) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)paramsCache, (String)"paramsCache");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)nextTask, (String)"nextTask");
        this.brandId = brandId;
        this.domain = domain;
        this.paramsCache = paramsCache;
        this.lpAuthenticationParams = lpAuthenticationParams;
        this.callback = callback2;
        this.nextTask = nextTask;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @Nullable
    public final LPAuthenticationParams getLpAuthenticationParams() {
        return this.lpAuthenticationParams;
    }

    @NotNull
    public final IMonitoringCallback<? extends LPSdeResponse, Exception> getCallback() {
        return this.callback;
    }

    @NotNull
    public final MonitoringTaskHandler getNextTask() {
        return this.nextTask;
    }

    @Override
    public void execute(@NotNull Map<String, ? extends Object> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        LPLog.INSTANCE.i(TAG, "executeNextTask: Starting CSDSTask");
        LPAuthenticationParams lPAuthenticationParams = this.lpAuthenticationParams;
        new CSDSRequest(this.domain, this.brandId, lPAuthenticationParams != null ? lPAuthenticationParams.getCertificatePinningKeys() : null, (ICallback)new ICallback<HashMap<String, String>, Exception>(this){
            final /* synthetic */ CSDSTask this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable HashMap<String, String> csdsUrls) {
                if (csdsUrls != null && !((Map)csdsUrls).isEmpty()) {
                    String string2 = csdsUrls.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"csdsUrls.toString()");
                    LPLog.INSTANCE.i("CSDSTask", string2);
                    this.this$0.getParamsCache().updateCsdsDomains(csdsUrls);
                    LPLog.INSTANCE.d("CSDSTask", "Calling the next request...");
                    MonitoringTaskHandler.DefaultImpls.execute$default(this.this$0.getNextTask(), null, 1, null);
                } else {
                    LPLog.INSTANCE.e("CSDSTask", ErrorCode.ERR_0000000D, "execute: Received empty CSDS domain map");
                    MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(() -> execute.1.onSuccess$lambda-0(this.this$0));
                }
            }

            public void onError(@Nullable Exception exception) {
                Exception it = exception;
                boolean bl = false;
                LPLog.INSTANCE.e("CSDSTask", ErrorCode.ERR_0000000E, "onError: ", (Throwable)it);
                MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(() -> execute.1.onError$lambda-2(this.this$0, exception));
            }

            private static final void onSuccess$lambda-0(CSDSTask this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.getCallback().onError(MonitoringErrorType.CSDS_ERROR, null);
            }

            private static final void onError$lambda-2(CSDSTask this$0, Exception $exception) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.getCallback().onError(MonitoringErrorType.CSDS_ERROR, (Exception)((Throwable)$exception));
            }
        }).execute();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/monitoring/connection/tasks/CSDSTask$Companion;", "", "()V", "TAG", "", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

