package com.liveperson.monitoring.ccuiConfig

import com.liveperson.infra.model.MessageOption
import com.liveperson.infra.model.deserializeStyleFromJson
import org.json.JSONArray
import org.json.JSONObject

private const val KEY_DISPLAY_TEXT = "text"
private const val KEY_VALUE = "action.value"
private const val KEY_METADATA = "action.metadata"

/**
 * Extension function over JSONObject class used
 * to deserialize json object content to message option.
 *
 * @see toMessageOptions to understand how this method is used.
 */
private fun JSONObject.optionFromJson(): MessageOption {
    return MessageOption(
        optString(KEY_DISPLAY_TEXT),
        optString(KEY_VALUE),
        optJSONArray(KEY_METADATA) ?: JSONArray(),
        deserializeStyleFromJson()
    )

}

/**
 * Extension function over json array used to deserialize it
 * to list of message options.
 */
internal fun JSONArray.toMessageOptions(): List<MessageOption> {
    return (0 until length()).asSequence()
        .map { getJSONObject(it) }
        .map { it.optionFromJson() }
        .toList()
}