package com.liveperson.monitoring.connection

import android.content.Context
import com.liveperson.infra.auth.LPAuthenticationParams
import com.liveperson.monitoring.cache.MonitoringParamsCache
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.sdk.MonitoringParams
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback
import com.liveperson.monitoring.sdk.callbacks.SdeCallback

class MonitoringTasksExecutor(val brandId: String, val context: Context, val paramsCache : MonitoringParamsCache) {
    private var monitoringTaskHolder = MonitoringTaskHolder(brandId, context, paramsCache)

    fun runEngagementTask(
        lpAuthenticationParams: LPAuthenticationParams?,
        identities: List<LPMonitoringIdentity>?,
        monitoringParams: MonitoringParams?,
        callback: EngagementCallback,
        isRefreshEngagement: Boolean
    ) {
        val monitoringTask = if (lpAuthenticationParams != null) {
            monitoringTaskHolder.constructAuthEngagementTasks(
                lpAuthenticationParams,
                identities,
                monitoringParams,
                callback,
                isRefreshEngagement
            )
        } else {
            monitoringTaskHolder.constructUnAuthEngagementTasks(
                identities,
                monitoringParams,
                callback,
                isRefreshEngagement
            )
        }

        monitoringTask.execute()
    }

    fun runSendSdeTask(
        identities: List<LPMonitoringIdentity>?,
        monitoringParams: MonitoringParams?,
        callback: SdeCallback
    ) {
        monitoringTaskHolder.constructSendSDETasks(monitoringParams, identities, callback).execute()
    }
}