/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.monitoring.IMonitoring;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.connection.MonitoringTasksExecutor;
import com.liveperson.monitoring.managers.MonitoringRequestManager;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.MonitoringInternalInitParams;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.callbacks.SdeCallback;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00062\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0012H\u0016J\u000e\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u000207J\b\u00108\u001a\u00020\u0012H\u0016J\b\u00109\u001a\u00020\u0012H\u0016J\u000e\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<J2\u0010=\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00062\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00102\u001a\u00020>H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010#0\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006@"}, d2={"Lcom/liveperson/monitoring/Monitoring;", "Lcom/liveperson/monitoring/IMonitoring;", "()V", "appHandler", "Landroid/os/Handler;", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "setApplicationContext", "(Landroid/content/Context;)V", "brandId", "", "getBrandId", "()Ljava/lang/String;", "setBrandId", "(Ljava/lang/String;)V", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "monitoringTasksExecutor", "Lcom/liveperson/monitoring/connection/MonitoringTasksExecutor;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "setParamsCache", "(Lcom/liveperson/monitoring/cache/MonitoringParamsCache;)V", "requestManager", "Lcom/liveperson/monitoring/managers/MonitoringRequestManager;", "welcomeMessageMap", "", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "getWelcomeMessageMap", "()Ljava/util/Map;", "setWelcomeMessageMap", "(Ljava/util/Map;)V", "getEngagement", "", "context", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/monitoring/sdk/MonitoringParams;", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/EngagementCallback;", "isRefreshEngagement", "init", "monitoringInternalInitParams", "Lcom/liveperson/monitoring/sdk/MonitoringInternalInitParams;", "isInitialized", "logout", "postOnMainThread", "runnable", "Ljava/lang/Runnable;", "sendSde", "Lcom/liveperson/monitoring/sdk/callbacks/SdeCallback;", "Companion", "monitoring_release"})
@SourceDebugExtension(value={"SMAP\nMonitoring.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Monitoring.kt\ncom/liveperson/monitoring/Monitoring\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public class Monitoring
implements IMonitoring {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Handler appHandler;
    @Nullable
    private MonitoringRequestManager requestManager;
    private boolean initialized;
    @Nullable
    private MonitoringParamsCache paramsCache;
    @Nullable
    private String brandId;
    @Nullable
    private Context applicationContext;
    @Nullable
    private MonitoringTasksExecutor monitoringTasksExecutor;
    public Map<String, LPWelcomeMessage> welcomeMessageMap;
    @NotNull
    private static final String TAG = "Monitoring";

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    @Nullable
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    public final void setParamsCache(@Nullable MonitoringParamsCache monitoringParamsCache) {
        this.paramsCache = monitoringParamsCache;
    }

    @Nullable
    public final String getBrandId() {
        return this.brandId;
    }

    public final void setBrandId(@Nullable String string) {
        this.brandId = string;
    }

    @Nullable
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(@Nullable Context context) {
        this.applicationContext = context;
    }

    @NotNull
    public final Map<String, LPWelcomeMessage> getWelcomeMessageMap() {
        Map<String, LPWelcomeMessage> map = this.welcomeMessageMap;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"welcomeMessageMap");
        return null;
    }

    public final void setWelcomeMessageMap(@NotNull Map<String, LPWelcomeMessage> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.welcomeMessageMap = map;
    }

    public final boolean init(@NotNull MonitoringInternalInitParams monitoringInternalInitParams) {
        String lBrandId;
        Intrinsics.checkNotNullParameter((Object)monitoringInternalInitParams, (String)"monitoringInternalInitParams");
        LPLog.INSTANCE.d(TAG, "init: Monitoring module version = 5.24.1");
        LPLog.INSTANCE.d(TAG, "Initializing Monitoring SDK. MonitoringInternalInitParams: " + monitoringInternalInitParams);
        this.appHandler = new Handler(Looper.getMainLooper());
        this.applicationContext = monitoringInternalInitParams.getApplicationContext();
        this.brandId = monitoringInternalInitParams.getAccountId();
        if (TextUtils.isEmpty((CharSequence)this.brandId)) {
            LPLog.INSTANCE.w(TAG, "BrandId is empty. Aborting");
            return false;
        }
        String string2 = lBrandId = this.brandId;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.paramsCache = new MonitoringParamsCache(lBrandId);
        }
        this.setWelcomeMessageMap(new LinkedHashMap());
        if (this.paramsCache == null) {
            return false;
        }
        MonitoringParamsCache lParamsCache = this.paramsCache;
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        if (monitoringParamsCache != null) {
            monitoringParamsCache.setAppInstallId(monitoringInternalInitParams.getAppInstallId());
        }
        MonitoringParamsCache monitoringParamsCache2 = lParamsCache;
        if (monitoringParamsCache2 != null) {
            MonitoringParamsCache it = monitoringParamsCache2;
            boolean bl = false;
            this.requestManager = new MonitoringRequestManager(this.brandId, lParamsCache);
        }
        String string3 = this.brandId;
        Intrinsics.checkNotNull((Object)string3);
        Context context = this.applicationContext;
        Intrinsics.checkNotNull((Object)context);
        MonitoringParamsCache monitoringParamsCache3 = this.paramsCache;
        Intrinsics.checkNotNull((Object)monitoringParamsCache3);
        this.monitoringTasksExecutor = new MonitoringTasksExecutor(string3, context, monitoringParamsCache3);
        this.initialized = true;
        return true;
    }

    @Override
    public boolean logout() {
        LPLog.INSTANCE.d(TAG, "Logging out...");
        if (!this.initialized) {
            LPLog.INSTANCE.w(TAG, "Not initialized");
            return true;
        }
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        if (monitoringParamsCache != null) {
            monitoringParamsCache.clear();
        }
        this.paramsCache = null;
        this.brandId = null;
        this.applicationContext = null;
        this.initialized = false;
        return true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getEngagement(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @Nullable LPAuthenticationParams lpAuthenticationParams, @NotNull EngagementCallback callback, boolean isRefreshEngagement) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            v0 = LPLog.INSTANCE;
            v1 = "Monitoring";
            v2 = LPLog.INSTANCE;
            v3 = identities;
            if (v3 == null) ** GOTO lbl-1000
            var8_8 = var7_7 = v3;
            var12_9 = v2;
            var11_10 = v1;
            var10_11 = v0;
            $i$a$-takeIf-Monitoring$getEngagement$1 = false;
            var13_13 = !((Collection)it).isEmpty();
            v0 = var10_11;
            v1 = var11_10;
            v2 = var12_9;
            v3 = var13_13 != false ? var7_7 : null;
            if (v3 != null) {
                v4 = v3.get(0);
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v0.d(v1, "GetEngagement. LPMonitoringIdentity: " + v2.mask(v4) + ", SDE: " + LPLog.INSTANCE.mask((Object)monitoringParams));
            if (!this.initialized) {
                LPLog.INSTANCE.w("Monitoring", "Not initialized");
                callback.onError(MonitoringErrorType.NOT_INITIALIZED, null);
                return;
            }
            if (!InternetConnectionService.isNetworkAvailable()) {
                LPLog.INSTANCE.d("Monitoring", "No network. calling callback.onError");
                callback.onError(MonitoringErrorType.NO_NETWORK, null);
                return;
            }
            v5 = this.monitoringTasksExecutor;
            if (v5 == null) break block4;
            v5.runEngagementTask(lpAuthenticationParams, identities, monitoringParams, callback, isRefreshEngagement);
        }
    }

    @Override
    public void sendSde(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull SdeCallback callback2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            LPLog.INSTANCE.d(TAG, "sendSde. ConsumerId: " + LPLog.INSTANCE.mask(identities) + ", SDE: " + LPLog.INSTANCE.mask((Object)monitoringParams));
            if (!this.initialized) {
                LPLog.INSTANCE.w(TAG, "Not initialized");
                callback2.onError(MonitoringErrorType.NOT_INITIALIZED, null);
                return;
            }
            if (identities == null || identities.isEmpty()) {
                callback2.onError(MonitoringErrorType.PARAMETER_MISSING, new Exception("ConsumerId is mandatory"));
                return;
            }
            if (!InternetConnectionService.isNetworkAvailable()) {
                LPLog.INSTANCE.d(TAG, "No network. calling callback.onError");
                callback2.onError(MonitoringErrorType.NO_NETWORK, null);
                return;
            }
            MonitoringTasksExecutor monitoringTasksExecutor = this.monitoringTasksExecutor;
            if (monitoringTasksExecutor == null) break block3;
            monitoringTasksExecutor.runSendSdeTask(identities, monitoringParams, callback2);
        }
    }

    public final void postOnMainThread(@NotNull Runnable runnable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Handler handler = this.appHandler;
            if (handler == null) break block0;
            handler.post(runnable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/monitoring/Monitoring$Companion;", "", "()V", "TAG", "", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

