/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.content.Context;
import android.text.TextUtils;
import com.liveperson.infra.monitoring.R;
import com.liveperson.infra.network.http.request.HttpPutRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.EngagementWithSession;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.requests.BaseMonitoringRequest;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.callbacks.SdeCallback;
import com.liveperson.monitoring.sdk.responses.LPSdeResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001aH\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/liveperson/monitoring/requests/SendSdeRequest;", "Lcom/liveperson/monitoring/requests/BaseMonitoringRequest;", "context", "Landroid/content/Context;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/monitoring/sdk/MonitoringParams;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/SdeCallback;", "(Landroid/content/Context;Ljava/util/List;Lcom/liveperson/monitoring/sdk/MonitoringParams;Lcom/liveperson/monitoring/sdk/callbacks/SdeCallback;)V", "getCallback", "()Lcom/liveperson/monitoring/sdk/callbacks/SdeCallback;", "buildRequestBody", "Lorg/json/JSONObject;", "callErrorCallback", "", "monitoringErrorType", "Lcom/liveperson/monitoring/sdk/callbacks/MonitoringErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getRequest", "Lcom/liveperson/infra/network/http/request/HttpRequest;", "getRequestUrl", "", "handleResponse", "response", "Companion", "monitoring_release"})
@SourceDebugExtension(value={"SMAP\nSendSdeRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendSdeRequest.kt\ncom/liveperson/monitoring/requests/SendSdeRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class SendSdeRequest
extends BaseMonitoringRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdeCallback callback;
    @NotNull
    private static final String KEY_PAGE_ID = "pageId";

    public SendSdeRequest(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull SdeCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        super(context, identities, monitoringParams, null);
        this.callback = callback2;
    }

    @NotNull
    public final SdeCallback getCallback() {
        return this.callback;
    }

    @Override
    @NotNull
    protected HttpRequest getRequest() {
        return (HttpRequest)new HttpPutRequest(this.buildRequestUrl(), LPTraceType.SHARK_SEND_SDE_REQ);
    }

    @Override
    @NotNull
    protected String getRequestUrl() {
        String string2 = this.getContext().getResources().getString(R.string.send_sde_url);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getString(R.string.send_sde_url)");
        return string2;
    }

    @Override
    protected void handleResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        EngagementWithSession engagement = EngagementWithSession.Companion.invoke(response);
        String it = engagement.getSessionId();
        boolean bl = false;
        MonitoringParamsCache monitoringParamsCache = this.getParamsCache();
        if (monitoringParamsCache != null) {
            monitoringParamsCache.setSessionId(engagement.getSessionId());
        }
        it = engagement.getVisitorId();
        boolean bl2 = false;
        MonitoringParamsCache monitoringParamsCache2 = this.getParamsCache();
        if (monitoringParamsCache2 != null) {
            monitoringParamsCache2.setVisitorId(engagement.getVisitorId());
        }
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(() -> SendSdeRequest.handleResponse$lambda$2(this, engagement));
    }

    @Override
    @NotNull
    protected JSONObject buildRequestBody(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        JSONObject engagementBody;
        block1: {
            engagementBody = super.buildRequestBody(identities, monitoringParams);
            MonitoringParams monitoringParams2 = monitoringParams;
            if (TextUtils.isEmpty((CharSequence)(monitoringParams2 != null ? monitoringParams2.getPageId() : null))) break block1;
            Object object = monitoringParams;
            if (object != null && (object = ((MonitoringParams)object).getPageId()) != null) {
                Object it = object;
                boolean bl = false;
                engagementBody.put(KEY_PAGE_ID, (Object)monitoringParams.getPageId());
            }
        }
        return engagementBody;
    }

    @Override
    protected void callErrorCallback(@NotNull MonitoringErrorType monitoringErrorType, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)((Object)monitoringErrorType), (String)"monitoringErrorType");
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(() -> SendSdeRequest.callErrorCallback$lambda$4(this, monitoringErrorType, exception));
    }

    private static final void handleResponse$lambda$2(SendSdeRequest this$0, EngagementWithSession $engagement) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$engagement, (String)"$engagement");
        this$0.callback.onSuccess(new LPSdeResponse($engagement));
    }

    private static final void callErrorCallback$lambda$4(SendSdeRequest this$0, MonitoringErrorType $monitoringErrorType, Exception $exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$monitoringErrorType), (String)"$monitoringErrorType");
        this$0.callback.onError($monitoringErrorType, $exception);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/monitoring/requests/SendSdeRequest$Companion;", "", "()V", "KEY_PAGE_ID", "", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

