/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.model;

import com.liveperson.monitoring.model.EngagementDetails;
import com.liveperson.monitoring.model.ModelKeyNames;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tR\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/liveperson/monitoring/model/EngagementWithSession;", "", "sessionId", "", "visitorId", "pageId", "engagementDetailsList", "", "Lcom/liveperson/monitoring/model/EngagementDetails;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getEngagementDetailsList", "()Ljava/util/List;", "setEngagementDetailsList", "(Ljava/util/List;)V", "getPageId", "()Ljava/lang/String;", "getSessionId", "getVisitorId", "Companion", "monitoring_release"})
public final class EngagementWithSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final String visitorId;
    @NotNull
    private final String pageId;
    @Nullable
    private List<EngagementDetails> engagementDetailsList;

    public EngagementWithSession(@NotNull String sessionId, @NotNull String visitorId, @NotNull String pageId, @Nullable List<EngagementDetails> engagementDetailsList) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)visitorId, (String)"visitorId");
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        this.sessionId = sessionId;
        this.visitorId = visitorId;
        this.pageId = pageId;
        this.engagementDetailsList = engagementDetailsList;
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getVisitorId() {
        return this.visitorId;
    }

    @NotNull
    public final String getPageId() {
        return this.pageId;
    }

    @Nullable
    public final List<EngagementDetails> getEngagementDetailsList() {
        return this.engagementDetailsList;
    }

    public final void setEngagementDetailsList(@Nullable List<EngagementDetails> list) {
        this.engagementDetailsList = list;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/monitoring/model/EngagementWithSession$Companion;", "", "()V", "invoke", "Lcom/liveperson/monitoring/model/EngagementWithSession;", "engagementJson", "", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EngagementWithSession invoke(@NotNull String engagementJson) {
            Intrinsics.checkNotNullParameter((Object)engagementJson, (String)"engagementJson");
            List engagementDetailsList = null;
            JSONObject jsonObject = new JSONObject(engagementJson);
            String sId = jsonObject.getString(ModelKeyNames.SESSION_ID);
            String vId = jsonObject.getString(ModelKeyNames.VISITOR_ID);
            String pId = jsonObject.getString(ModelKeyNames.PAGE_ID);
            JSONArray engagementDetailsJsonArray = jsonObject.optJSONArray(ModelKeyNames.ENGAGEMENT_DETAILS);
            if (engagementDetailsJsonArray != null) {
                engagementDetailsList = new ArrayList(engagementDetailsJsonArray.length());
                int n = engagementDetailsJsonArray.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject engagementDetailsJson = engagementDetailsJsonArray.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)engagementDetailsJson, (String)"engagementDetailsJson");
                    EngagementDetails engagementDetails = EngagementDetails.Companion.invoke(engagementDetailsJson);
                    ((ArrayList)engagementDetailsList).add(engagementDetails);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)sId, (String)"sId");
            Intrinsics.checkNotNullExpressionValue((Object)vId, (String)"vId");
            Intrinsics.checkNotNullExpressionValue((Object)pId, (String)"pId");
            return new EngagementWithSession(sId, vId, pId, engagementDetailsList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

