/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.connection.tasks;

import android.content.Context;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.AuthCallBack;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.errors.AuthError;
import com.liveperson.infra.network.http.requests.AuthRequest;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.connection.MonitoringTaskHandler;
import com.liveperson.monitoring.sdk.callbacks.IMonitoringCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPSdeResponse;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u001f\u001a\u00020 2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0016J\u0014\u0010$\u001a\u00020 2\n\u0010%\u001a\u00060\rj\u0002`\u000eH\u0002R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\n\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lcom/liveperson/monitoring/connection/tasks/IdpTask;", "Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "brandId", "", "context", "Landroid/content/Context;", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "Lcom/liveperson/monitoring/sdk/responses/LPSdeResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "nextTask", "(Ljava/lang/String;Landroid/content/Context;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/monitoring/cache/MonitoringParamsCache;Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;)V", "TAG", "getBrandId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "connectorId", "getContext", "()Landroid/content/Context;", "getLpAuthenticationParams", "()Lcom/liveperson/infra/auth/LPAuthenticationParams;", "getNextTask", "()Lcom/liveperson/monitoring/connection/MonitoringTaskHandler;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "execute", "", "args", "", "", "onTaskError", "exception", "monitoring_release"})
public final class IdpTask
implements MonitoringTaskHandler {
    @NotNull
    private final String brandId;
    @NotNull
    private final Context context;
    @NotNull
    private final LPAuthenticationParams lpAuthenticationParams;
    @NotNull
    private final MonitoringParamsCache paramsCache;
    @NotNull
    private final IMonitoringCallback<? extends LPSdeResponse, Exception> callback;
    @NotNull
    private final MonitoringTaskHandler nextTask;
    @NotNull
    private final String TAG;
    @Nullable
    private String connectorId;

    public IdpTask(@NotNull String brandId, @NotNull Context context, @NotNull LPAuthenticationParams lpAuthenticationParams, @NotNull MonitoringParamsCache paramsCache, @NotNull IMonitoringCallback<? extends LPSdeResponse, Exception> callback2, @NotNull MonitoringTaskHandler nextTask) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lpAuthenticationParams, (String)"lpAuthenticationParams");
        Intrinsics.checkNotNullParameter((Object)paramsCache, (String)"paramsCache");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)nextTask, (String)"nextTask");
        this.brandId = brandId;
        this.context = context;
        this.lpAuthenticationParams = lpAuthenticationParams;
        this.paramsCache = paramsCache;
        this.callback = callback2;
        this.nextTask = nextTask;
        this.TAG = "IdpTask";
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final LPAuthenticationParams getLpAuthenticationParams() {
        return this.lpAuthenticationParams;
    }

    @NotNull
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @NotNull
    public final IMonitoringCallback<? extends LPSdeResponse, Exception> getCallback() {
        return this.callback;
    }

    @NotNull
    public final MonitoringTaskHandler getNextTask() {
        return this.nextTask;
    }

    @Override
    public void execute(@NotNull Map<String, ? extends Object> args) {
        String string2;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        LPLog.INSTANCE.i(this.TAG, "executeNextTask: Starting " + this.TAG);
        this.connectorId = (String)args.get("connectorId");
        String it = string2 = this.paramsCache.getIdpDomain();
        boolean bl = false;
        CharSequence charSequence = it;
        String string3 = !(charSequence == null || charSequence.length() == 0) ? string2 : null;
        if (string3 == null) {
            IdpTask $this$execute_u24lambda_u241 = this;
            boolean bl2 = false;
            $this$execute_u24lambda_u241.onTaskError(new Exception("Domain not found"));
            return;
        }
        String idpDomain = string3;
        AuthCallBack callback2 = new AuthCallBack(this){
            final /* synthetic */ IdpTask this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAuthSuccess(@NotNull Consumer consumer) {
                Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
                LPLog.INSTANCE.i(IdpTask.access$getTAG$p(this.this$0), "On Auth success: " + LPLog.INSTANCE.mask((Object)consumer));
                this.this$0.getNextTask().execute(MapsKt.mapOf((Pair)TuplesKt.to((Object)"token", (Object)consumer.getLpToken())));
            }

            public void onConsumerSwitch(@NotNull Consumer oldConsumer, @NotNull Consumer newConsumer) {
                Intrinsics.checkNotNullParameter((Object)oldConsumer, (String)"oldConsumer");
                Intrinsics.checkNotNullParameter((Object)newConsumer, (String)"newConsumer");
            }

            public void onAuthFailed(@NotNull AuthError error) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    LPLog.INSTANCE.w(IdpTask.access$getTAG$p(this.this$0), "onAuthFailed: " + error);
                    Exception exception = error.getException();
                    if (exception == null) break block0;
                    Exception exception2 = exception;
                    IdpTask idpTask = this.this$0;
                    Exception it = exception2;
                    boolean bl = false;
                    IdpTask.access$onTaskError(idpTask, it);
                }
            }
        };
        it = string2 = new AuthRequest(this.context, this.brandId, idpDomain, this.lpAuthenticationParams, this.paramsCache.getHostVersion(), this.lpAuthenticationParams.getCertificatePinningKeys(), null, this.connectorId, false, callback2);
        boolean bl3 = false;
        it.authenticate();
    }

    private final void onTaskError(Exception exception) {
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(() -> IdpTask.onTaskError$lambda$3(this, exception));
    }

    private static final void onTaskError$lambda$3(IdpTask this$0, Exception $exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        this$0.callback.onError(MonitoringErrorType.IDP_ERROR, (Exception)((Throwable)$exception));
    }

    public static final /* synthetic */ String access$getTAG$p(IdpTask $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$onTaskError(IdpTask $this, Exception exception) {
        $this.onTaskError(exception);
    }
}

