/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.ModelKeyNames;
import com.liveperson.monitoring.requests.GetWelcomeMessageRequest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/monitoring/requests/AcCdnRequest;", "Lcom/liveperson/monitoring/Command;", "campaignId", "", "engagementId", "engagementRevision", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCampaignId", "()Ljava/lang/String;", "getEngagementId", "getEngagementRevision", "mParamsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "execute", "", "getConfiguredWelcomeMessage", "windowId", "getRequestUrl", "parseAcCdnResponse", "acCdnResponse", "setParamsCache", "paramsCache", "Companion", "monitoring_release"})
public final class AcCdnRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String campaignId;
    @Nullable
    private final String engagementId;
    @Nullable
    private final String engagementRevision;
    @Nullable
    private MonitoringParamsCache mParamsCache;
    @NotNull
    private static final String TAG = "ACCDNRequest";
    @NotNull
    private static final String ACCDN_URL = "https://%1$s/api/account/%2$s/configuration/le-campaigns/campaigns/%3$s/engagements/%4$s/revision/%5$s";

    public AcCdnRequest(@Nullable String campaignId, @Nullable String engagementId, @Nullable String engagementRevision) {
        this.campaignId = campaignId;
        this.engagementId = engagementId;
        this.engagementRevision = engagementRevision;
        this.mParamsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
    }

    @Nullable
    public final String getCampaignId() {
        return this.campaignId;
    }

    @Nullable
    public final String getEngagementId() {
        return this.engagementId;
    }

    @Nullable
    public final String getEngagementRevision() {
        return this.engagementRevision;
    }

    @Override
    public void execute() {
        String acCdnRequestUrl = this.getRequestUrl();
        LPLog.INSTANCE.d(TAG, "acCdn request url: " + acCdnRequestUrl);
        HttpGetRequest httpGetRequest = new HttpGetRequest(acCdnRequestUrl, LPTraceType.ACCDN_ENGAGEMENT_REQ);
        httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ AcCdnRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@NotNull String response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                LPLog.INSTANCE.d("ACCDNRequest", "AcCdn response: " + response);
                this.this$0.parseAcCdnResponse(response);
            }

            public void onError(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LPLog.INSTANCE.e("ACCDNRequest", ErrorCode.ERR_00000050, "Failed to get engagement language.", (Throwable)exception);
            }
        });
        HttpHandler.execute((HttpRequest)((HttpRequest)httpGetRequest));
    }

    public final void parseAcCdnResponse(@NotNull String acCdnResponse) {
        Intrinsics.checkNotNullParameter((Object)acCdnResponse, (String)"acCdnResponse");
        try {
            JSONObject acCdnJSON = new JSONObject(acCdnResponse);
            String language = acCdnJSON.getString(ModelKeyNames.LANGUAGE);
            LocaleUtils.getInstance().setEngagementLanguageCode(language);
            String windowId = acCdnJSON.optString(ModelKeyNames.WINDOW_ID);
            Intrinsics.checkNotNullExpressionValue((Object)windowId, (String)"windowId");
            if (((CharSequence)windowId).length() > 0) {
                this.getConfiguredWelcomeMessage(windowId);
            } else {
                Object object = this.mParamsCache;
                if (object == null || (object = ((MonitoringParamsCache)object).getBrandId()) == null) {
                    return;
                }
                Object brandId = object;
                MonitoringFactory.INSTANCE.getMonitoring().getWelcomeMessageMap().put((String)brandId, null);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000051, "Failed to parse engagement language.", (Throwable)exception);
        }
    }

    private final void getConfiguredWelcomeMessage(String windowId) {
        new GetWelcomeMessageRequest(windowId).execute();
    }

    @NotNull
    public final String getRequestUrl() {
        String string2 = ACCDN_URL;
        Object[] objectArray = new Object[5];
        MonitoringParamsCache monitoringParamsCache = this.mParamsCache;
        objectArray[0] = monitoringParamsCache != null ? monitoringParamsCache.getAcCdnDomain() : null;
        MonitoringParamsCache monitoringParamsCache2 = this.mParamsCache;
        objectArray[1] = monitoringParamsCache2 != null ? monitoringParamsCache2.getBrandId() : null;
        objectArray[2] = this.campaignId;
        objectArray[3] = this.engagementId;
        objectArray[4] = this.engagementRevision;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    @VisibleForTesting
    public final void setParamsCache(@NotNull MonitoringParamsCache paramsCache) {
        Intrinsics.checkNotNullParameter((Object)paramsCache, (String)"paramsCache");
        this.mParamsCache = paramsCache;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/monitoring/requests/AcCdnRequest$Companion;", "", "()V", "ACCDN_URL", "", "TAG", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

