/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.content.Context;
import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 +2\u00020\u0001:\u0001+B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\u0016\u001a\u00020\u000bH\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001dH$J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0012\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u000bH\u0004J\b\u0010!\u001a\u00020\u000bH\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010$\u001a\u00020%H$J\b\u0010&\u001a\u00020\u000bH$J \u0010'\u001a\u00020\u00182\u000e\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d2\u0006\u0010(\u001a\u00020%H\u0014J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u000bH$R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/liveperson/monitoring/requests/BaseMonitoringRequest;", "Lcom/liveperson/monitoring/Command;", "context", "Landroid/content/Context;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/monitoring/sdk/MonitoringParams;", "(Landroid/content/Context;Ljava/util/List;Lcom/liveperson/monitoring/sdk/MonitoringParams;)V", "baseSessionVisitorString", "", "getContext", "()Landroid/content/Context;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "retryCounter", "", "buildRequestBody", "Lorg/json/JSONObject;", "buildRequestUrl", "callErrorCallback", "", "monitoringErrorType", "Lcom/liveperson/monitoring/sdk/callbacks/MonitoringErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "execute", "extractAndSetVid", "message", "getIDPAnonymousUrl", "getOriginalConsumerId", "brandId", "getRequest", "Lcom/liveperson/infra/network/http/request/HttpRequest;", "getRequestUrl", "handleError", "httpRequest", "handleResponse", "response", "Companion", "monitoring_release"})
public abstract class BaseMonitoringRequest
implements Command {
    private final String baseSessionVisitorString = "&vid=%s&sid=%s";
    @Nullable
    private final MonitoringParamsCache paramsCache;
    private int retryCounter;
    @NotNull
    private final Context context;
    private final List<LPMonitoringIdentity> identities;
    private final MonitoringParams monitoringParams;
    private static final String TAG = "BaseMonitoringRequest";
    protected static final int NUM_OF_RETRIES = 4;
    @NotNull
    public static final String DEFAULT_AUTH_ACR = "loa1";
    @NotNull
    public static final String DEFAULT_UNAUTH_ACR = "0";
    @NotNull
    public static final String ISSUER = "iss";
    @NotNull
    public static final String ACR = "acr";
    @NotNull
    public static final String SUB = "sub";
    @NotNull
    public static final String KEY_CONSUMER_ID_ENC = "account_original_consumer_id_enc";
    private static final String KEY_CONSUMER_ID = "consumerId";
    private static final String KEY_ENTRY_POINTS = "entryPoints";
    private static final String KEY_ENGAGEMENT_ATTRIBUTES = "engagementAttributes";
    private static final String KEY_IDENTITIES = "identities";
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @NotNull
    protected abstract HttpRequest getRequest();

    protected abstract void handleResponse(@NotNull String var1);

    protected abstract void callErrorCallback(@NotNull MonitoringErrorType var1, @Nullable Exception var2);

    @NotNull
    protected abstract String getRequestUrl();

    @Override
    public void execute() {
        HttpRequest httpRequest = this.getRequest();
        JSONObject body = this.buildRequestBody(this.identities, this.monitoringParams);
        LPJSONObjectBody httpPostBody = new LPJSONObjectBody(body);
        httpRequest.setBody((HttpRequestBody)httpPostBody);
        LPLog.INSTANCE.d(TAG, "Sending body: " + LPLog.INSTANCE.mask((Object)body.toString(4)));
        httpRequest.setCallback((ICallback)new ICallback<String, Exception>(this, httpRequest){
            final /* synthetic */ BaseMonitoringRequest this$0;
            final /* synthetic */ HttpRequest $httpRequest;

            public void onSuccess(@Nullable String value) {
                if (value != null) {
                    try {
                        JSONObject messageObject = new JSONObject(value);
                        LPLog.INSTANCE.d("BaseMonitoringRequest", "Response: " + LPLog.INSTANCE.mask((Object)messageObject.toString(4)));
                    }
                    catch (JSONException e) {
                        LPLog.INSTANCE.w("BaseMonitoringRequest", "Error parsing response: " + LPLog.INSTANCE.mask((Object)value), (Throwable)e);
                    }
                    this.this$0.handleResponse(value);
                } else {
                    LPLog.INSTANCE.w("BaseMonitoringRequest", "Error parsing response: value is null.");
                }
            }

            public void onError(@Nullable Exception exception) {
                String message;
                Exception exception2 = exception;
                String string = message = exception2 != null ? exception2.getMessage() : null;
                if (message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"internalCode\":20", (boolean)false, (int)2, null)) {
                    this.this$0.extractAndSetVid(message);
                    this.$httpRequest.setUrl(this.this$0.buildRequestUrl());
                    LPLog.INSTANCE.d("BaseMonitoringRequest", "Account is not loaded yet. Retry...");
                } else if (exception != null) {
                    LPLog.INSTANCE.w("BaseMonitoringRequest", "Request error.", (Throwable)exception);
                }
                this.this$0.handleError(exception, this.$httpRequest);
            }
            {
                this.this$0 = $outer;
                this.$httpRequest = $captured_local_variable$1;
            }
        });
        HttpHandler.execute((HttpRequest)httpRequest);
    }

    protected final void extractAndSetVid(@Nullable String message) {
        block1: {
            String mess;
            if (message == null) break block1;
            String temp = StringsKt.substringAfter$default((String)message, (String)"body:", null, (int)2, null);
            JSONObject jsonObject = new JSONObject(temp);
            String string = mess = jsonObject.getString("message");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mess");
            String vid = StringsKt.substringAfter$default((String)string, (String)"vid: ", null, (int)2, null);
            MonitoringParamsCache monitoringParamsCache = this.paramsCache;
            if (monitoringParamsCache != null) {
                monitoringParamsCache.setVisitorId(vid);
            }
        }
    }

    protected void handleError(@Nullable Exception exception, @NotNull HttpRequest httpRequest) {
        Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
        if (this.retryCounter > 4) {
            LPLog.INSTANCE.d(TAG, "Done with retries (retry number " + this.retryCounter + ").");
            if (exception != null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000052, "Error: ", (Throwable)exception);
            }
            this.callErrorCallback(MonitoringErrorType.REQUEST_ERROR, exception);
            return;
        }
        int n = this.retryCounter;
        this.retryCounter = n + 1;
        LPLog.INSTANCE.d(TAG, "Retry No. " + n);
        HttpHandler.executeDelayed((HttpRequest)httpRequest, (long)(this.retryCounter * 1000));
    }

    @NotNull
    protected String buildRequestUrl() {
        String requestUrlString;
        block3: {
            boolean bl;
            Object[] objectArray;
            String string;
            StringCompanionObject stringCompanionObject;
            block2: {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string = this.getRequestUrl();
                Object[] objectArray2 = new Object[3];
                MonitoringParamsCache monitoringParamsCache = this.paramsCache;
                objectArray2[0] = monitoringParamsCache != null ? monitoringParamsCache.getSharkDomain() : null;
                MonitoringParamsCache monitoringParamsCache2 = this.paramsCache;
                objectArray2[1] = monitoringParamsCache2 != null ? monitoringParamsCache2.getBrandId() : null;
                MonitoringParamsCache monitoringParamsCache3 = this.paramsCache;
                objectArray2[2] = monitoringParamsCache3 != null ? monitoringParamsCache3.getAppInstallId() : null;
                objectArray = objectArray2;
                bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                requestUrlString = string2;
                MonitoringParamsCache monitoringParamsCache4 = this.paramsCache;
                if ((monitoringParamsCache4 != null ? monitoringParamsCache4.getSessionId() : null) != null) break block2;
                MonitoringParamsCache monitoringParamsCache5 = this.paramsCache;
                if ((monitoringParamsCache5 != null ? monitoringParamsCache5.getVisitorId() : null) == null) break block3;
            }
            LPLog.INSTANCE.d(TAG, "SessionId and VisitorId exist. Add them as request params (SessionId=" + this.paramsCache.getSessionId() + ", VisitorId=" + this.paramsCache.getVisitorId() + ')');
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = this.baseSessionVisitorString;
            objectArray = new Object[]{this.paramsCache.getVisitorId(), this.paramsCache.getSessionId()};
            StringBuilder stringBuilder = new StringBuilder().append(requestUrlString);
            bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            requestUrlString = stringBuilder.append(string4).toString();
        }
        return requestUrlString;
    }

    @NotNull
    protected JSONObject buildRequestBody(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        JSONObject getEngagementBody;
        block7: {
            MonitoringParams monitoringParams2;
            MonitoringParams it;
            boolean bl;
            MonitoringParams monitoringParams3;
            getEngagementBody = new JSONObject();
            JSONArray identitiesBody = new JSONArray();
            List<LPMonitoringIdentity> list = identities;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LPMonitoringIdentity it2 = (LPMonitoringIdentity)element$iv;
                    boolean bl2 = false;
                    JSONObject identity = new JSONObject();
                    if (!TextUtils.isEmpty((CharSequence)it2.getConsumerId())) {
                        if (!TextUtils.isEmpty((CharSequence)it2.getIssuer())) {
                            identity.put(ISSUER, (Object)it2.getIssuer());
                        }
                        identity.put(ACR, (Object)DEFAULT_AUTH_ACR);
                        identity.put(SUB, (Object)it2.getConsumerId());
                    } else {
                        identity.put(ACR, (Object)DEFAULT_UNAUTH_ACR);
                        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
                        String brandId = monitoringParamsCache != null ? monitoringParamsCache.getBrandId() : null;
                        identity.put(ISSUER, (Object)this.getIDPAnonymousUrl());
                        String originalConsumerId = this.getOriginalConsumerId(brandId);
                        CharSequence charSequence = originalConsumerId;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                            identity.put(SUB, (Object)originalConsumerId);
                        }
                    }
                    identitiesBody.put((Object)identity);
                }
            }
            getEngagementBody.put(KEY_IDENTITIES, (Object)identitiesBody);
            MonitoringParams monitoringParams4 = monitoringParams;
            if (monitoringParams4 != null && (monitoringParams4 = monitoringParams4.getEntryPoints()) != null) {
                monitoringParams3 = monitoringParams4;
                bl = false;
                boolean bl5 = false;
                it = monitoringParams3;
                boolean bl6 = false;
                getEngagementBody.put(KEY_ENTRY_POINTS, (Object)it);
            }
            if ((monitoringParams2 = monitoringParams) == null || (monitoringParams2 = monitoringParams2.getEngagementAttributes()) == null) break block7;
            monitoringParams3 = monitoringParams2;
            bl = false;
            boolean bl7 = false;
            it = monitoringParams3;
            boolean bl8 = false;
            getEngagementBody.put(KEY_ENGAGEMENT_ATTRIBUTES, (Object)it);
        }
        return getEngagementBody;
    }

    private final String getOriginalConsumerId(String brandId) {
        String decryptedConsumerId;
        String string = decryptedConsumerId = PreferenceManager.getInstance().getStringValue(KEY_CONSUMER_ID_ENC, brandId, null);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)it);
        }
        return null;
    }

    private final String getIDPAnonymousUrl() {
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        String idpDomain = monitoringParamsCache != null ? monitoringParamsCache.getIdpDomain() : null;
        return "https://" + idpDomain;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public BaseMonitoringRequest(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.identities = identities;
        this.monitoringParams = monitoringParams;
        this.baseSessionVisitorString = "&vid=%s&sid=%s";
        this.paramsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
        this.retryCounter = 1;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/monitoring/requests/BaseMonitoringRequest$Companion;", "", "()V", "ACR", "", "DEFAULT_AUTH_ACR", "DEFAULT_UNAUTH_ACR", "ISSUER", "KEY_CONSUMER_ID", "KEY_CONSUMER_ID_ENC", "KEY_ENGAGEMENT_ATTRIBUTES", "KEY_ENTRY_POINTS", "KEY_IDENTITIES", "NUM_OF_RETRIES", "", "SUB", "TAG", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

