/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.sdk.callbacks.IMonitoringCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSDSRequest
implements Command {
    private static final String TAG = CSDSRequest.class.getSimpleName();
    private static final String CSDS_URL = "https://%1$s/csdr/account/%2$s/service/baseURI.json?version=1.0";
    private static final int CSDS_REQUEST_TIMEOUT = 30000;
    private IMonitoringCallback mCallback;
    private String mBrandId;
    private String mDomain;

    public CSDSRequest(String domain, String brandId, IMonitoringCallback callback) {
        this.mCallback = callback;
        this.mBrandId = brandId;
        this.mDomain = domain;
    }

    @Override
    public void execute() {
        final String cSDSRequestUrl = String.format(CSDS_URL, this.mDomain, this.mBrandId);
        HttpGetRequest httpGetRequest = new HttpGetRequest(cSDSRequestUrl);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String csdsString) {
                block5: {
                    if (!TextUtils.isEmpty((CharSequence)csdsString)) {
                        try {
                            JSONObject csdsJson = new JSONObject(csdsString);
                            JSONArray csdsResponse = csdsJson.optJSONArray("baseURIs");
                            if (csdsResponse.length() == 0) {
                                CSDSRequest.this.mCallback.onError(MonitoringErrorType.CSDS_ERROR, new Exception("CSDS response: Brand not found. url = " + cSDSRequestUrl));
                                break block5;
                            }
                            HashMap mCSDSUrls = CSDSRequest.this.parseCSDSResponse(csdsResponse);
                            CSDSRequest.this.mCallback.onSuccess(mCSDSUrls);
                        }
                        catch (JSONException jSONException) {}
                    } else {
                        CSDSRequest.this.mCallback.onError(MonitoringErrorType.CSDS_ERROR, new Exception("CSDS response: csdsString is empty"));
                    }
                }
            }

            public void onError(Exception exception) {
                CSDSRequest.this.mCallback.onError(MonitoringErrorType.CSDS_ERROR, new Exception("CSDS failed! url = " + cSDSRequestUrl + ". error: " + exception.getMessage()));
            }
        });
        HttpHandler.execute((HttpRequest)httpGetRequest);
    }

    private HashMap<String, String> parseCSDSResponse(JSONArray cSDSResponse) throws JSONException {
        HashMap<String, String> mCSDSUrls = new HashMap<String, String>(cSDSResponse.length());
        for (int i = 0; i < cSDSResponse.length(); ++i) {
            JSONObject service = cSDSResponse.optJSONObject(i);
            String serviceName = service.optString("service");
            String baseURIName = service.optString("baseURI");
            LPLog.INSTANCE.d(TAG, "serviceName: " + serviceName + " : " + baseURIName);
            mCSDSUrls.put(serviceName, baseURIName);
        }
        return mCSDSUrls;
    }
}

