package com.liveperson.monitoring.utils;

import android.content.Context;
import android.text.TextUtils;

import com.liveperson.infra.log.LPLog;
import com.liveperson.lp_monitoring_sdk.R;

/**
 * Created by nirni on 12/26/17.
 */

public class DomainBuilder {

	public static final String TAG = "DomainBuilder";


	private static String defaultDomain = "adminlogin.liveperson.net";

	public static String getCsdsDomain(Context context, String brandId) {

		String domainToReturn;

		if (context == null || TextUtils.isEmpty(brandId)) {
			LPLog.INSTANCE.w(TAG, "getCsdsDomain: context or brandId is empty. Using default domain");
			return defaultDomain;
		}

		if (brandId.startsWith("qa") || brandId.startsWith("le")) {
			domainToReturn = context.getResources().getString(R.string.csds_qa_url);
		} else {
			domainToReturn = context.getResources().getString(R.string.csds_url);
		}

		// If there was a problem getting from resources
		if (TextUtils.isEmpty(domainToReturn)) {
			LPLog.INSTANCE.w(TAG, "getCsdsDomain: could not get domain from resources. Using default domain");
			return defaultDomain;
		}

		return domainToReturn;
	}
}
