/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.ui;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.ui.R;

public class TooltipWindow {
    public static final String TAG = "TooltipWindow";
    private static final int MSG_DISMISS_TOOLTIP = 100;
    private Context mContext;
    private PopupWindow mTooltipPopupWindow;
    private View mTooltipContentView;
    private LayoutInflater inflater;
    private int mTooltipDelayMs;
    private boolean mEnabled;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 100: {
                    if (TooltipWindow.this.mTooltipPopupWindow == null || !TooltipWindow.this.mTooltipPopupWindow.isShowing()) break;
                    TooltipWindow.this.mTooltipPopupWindow.dismiss();
                }
            }
            return true;
        }
    });

    public TooltipWindow(Context ctx) {
        this.mContext = ctx;
        this.mTooltipPopupWindow = new PopupWindow(ctx);
        this.inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        this.mTooltipContentView = this.inflater.inflate(R.layout.lpinfra_ui_tooltip_layout, null);
        this.mTooltipDelayMs = ctx.getResources().getInteger(R.integer.lp_mic_tooltip_display_time_ms);
        this.mEnabled = true;
    }

    public void showToolTip(View anchor, String tooltipText) {
        this.showToolTip(anchor, tooltipText, false);
    }

    public void showToolTip(View anchor, String tooltipText, boolean indefenetly) {
        if (!this.mEnabled) {
            LPMobileLog.d((String)TAG, (String)"showToolTip: tooltips disabled. Not showing.");
            return;
        }
        int[] anchorScreenPos = new int[2];
        TextView tooltipTextView = (TextView)this.mTooltipContentView.findViewById(R.id.lpui_tooltip_text);
        if (tooltipTextView != null) {
            tooltipTextView.setText((CharSequence)tooltipText);
        }
        this.mTooltipPopupWindow.setHeight(-2);
        this.mTooltipPopupWindow.setWidth(-2);
        this.mTooltipPopupWindow.setOutsideTouchable(true);
        this.mTooltipPopupWindow.setTouchable(true);
        this.mTooltipPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.mTooltipPopupWindow.setContentView(this.mTooltipContentView);
        anchor.getLocationOnScreen(anchorScreenPos);
        Rect anchorRect = new Rect(anchorScreenPos[0], anchorScreenPos[1], anchorScreenPos[0] + anchor.getWidth(), anchorScreenPos[1] + anchor.getHeight());
        this.mTooltipContentView.measure(-2, -2);
        int contentViewHeight = this.mTooltipContentView.getMeasuredHeight();
        int contentViewWidth = this.mTooltipContentView.getMeasuredWidth();
        int tooltipPositionX = anchorRect.centerX() - contentViewWidth / 2;
        int tooltipPositionY = anchorRect.top - (int)((double)contentViewHeight * 1.5);
        this.mTooltipPopupWindow.showAtLocation(anchor, 0, tooltipPositionX, tooltipPositionY);
        if (!indefenetly) {
            this.handler.sendEmptyMessageDelayed(100, (long)this.mTooltipDelayMs);
        }
    }

    public void enable(boolean enabled) {
        LPMobileLog.d((String)TAG, (String)("enable: " + enabled));
        this.mEnabled = enabled;
    }

    public boolean isTooltipShown() {
        return this.mTooltipPopupWindow != null && this.mTooltipPopupWindow.isShowing();
    }

    public void dismissTooltip() {
        if (this.mTooltipPopupWindow != null && this.mTooltipPopupWindow.isShowing()) {
            this.mTooltipPopupWindow.dismiss();
        }
    }
}

