/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.os.Bundle;
import android.support.v4.text.util.LinkifyCompat;
import android.support.v7.widget.RecyclerView;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.util.Patterns;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.utils.DateUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseViewHolder
extends RecyclerView.ViewHolder {
    private int position;
    protected TextView mMessageTextView;
    protected String mTimestampAccessibilityString;
    private boolean isNumericTimestampOnly;
    private static Linkify.TransformFilter mFilter = new Linkify.TransformFilter(){

        public final String transformUrl(Matcher match, String url) {
            return match.group();
        }
    };
    private static Linkify.MatchFilter mUrlMatchFilter = new Linkify.MatchFilter(){

        public final boolean acceptMatch(CharSequence s, int start, int end) {
            if (start == 0) {
                return true;
            }
            return s.charAt(start - 1) != '@';
        }
    };
    private static Linkify.MatchFilter mPhoneMatchFilter = new Linkify.MatchFilter(){

        public final boolean acceptMatch(CharSequence s, int start, int end) {
            if (start == 0) {
                return true;
            }
            return s.charAt(start - 1) == ' ' && s.charAt(start - 1) == '+' && s.charAt(start - 1) == '*' && s.charAt(start - 1) == '#' && s.charAt(end + 1) == ' ' && s.charAt(end + 1) == '+' && s.charAt(end + 1) == '*' && s.charAt(end + 1) == '#';
        }
    };

    public BaseViewHolder(View itemView) {
        super(itemView);
        this.mMessageTextView = (TextView)itemView.findViewById(R.id.lpui_message_text);
    }

    public abstract void updateContentDescription();

    public void setTempPosition(int position) {
        this.position = position;
    }

    public void setMessageTextView(String message) {
        this.mMessageTextView.setText((CharSequence)message);
    }

    public int getTempPosition() {
        return this.position;
    }

    public String getTextToCopy() {
        return this.mMessageTextView.getText().toString();
    }

    public void setContentDescription(String message) {
        this.itemView.setContentDescription((CharSequence)message);
        this.itemView.setAccessibilityDelegate(new View.AccessibilityDelegate(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setAccessibilityFocused(false);
            }
        });
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.itemView.setLongClickable(true);
        this.itemView.setOnLongClickListener(onLongClickListener);
        this.mMessageTextView.setOnLongClickListener(onLongClickListener);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.itemView.setClickable(true);
        this.itemView.setOnClickListener(onClickListener);
        this.mMessageTextView.setOnClickListener(onClickListener);
    }

    public void setContextualBehaviorOnClick(View.OnClickListener onClickListener) {
        this.itemView.setClickable(true);
        onClickListener.onClick(this.itemView);
    }

    public boolean setContextualBehaviorOnLongClick(View.OnLongClickListener onClickListener) {
        this.itemView.setLongClickable(true);
        return onClickListener.onLongClick(this.itemView);
    }

    public void setTimestampTextView(long timestamp) {
        this.mTimestampAccessibilityString = this.getAccessibilityDateTimeFormat(timestamp);
    }

    protected String getTimeFormat(long timestamp) {
        this.isNumericTimestampOnly = Configuration.getBoolean((int)R.bool.message_status_numeric_timestamp_only);
        if (!this.isNumericTimestampOnly) {
            long timeDiff = System.currentTimeMillis() - timestamp;
            if (timeDiff < 60000L) {
                return this.itemView.getContext().getString(R.string.lp_message_time_now);
            }
            if (timeDiff < 1200000L) {
                long minutes = timeDiff / 60000L;
                return String.format(this.itemView.getContext().getString(R.string.lp_message_time_min_ago), minutes);
            }
        }
        String customTimeFormat = this.itemView.getContext().getString(R.string.lp_time_format);
        return DateUtils.getFormattedTime((String)customTimeFormat, (int)3, (long)timestamp);
    }

    protected String getAccessibilityDateTimeFormat(long timestamp) {
        String customTimeFormat = this.itemView.getContext().getString(R.string.lp_time_format);
        return DateUtils.getFormattedDateAndTime((String)customTimeFormat, (int)3, (int)3, (long)timestamp);
    }

    protected boolean linkifyText(TextView textView) {
        boolean linkified = false;
        String customPhoneRegex = textView.getContext().getString(R.string.lp_bubble_phone_links_regex);
        String customUrlRegex = textView.getContext().getString(R.string.lp_bubble_url_links_regex);
        String customEmailRegex = textView.getContext().getString(R.string.lp_bubble_email_links_regex);
        if (TextUtils.isEmpty((CharSequence)customPhoneRegex) && TextUtils.isEmpty((CharSequence)customUrlRegex) && TextUtils.isEmpty((CharSequence)customEmailRegex)) {
            if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (int)7)) {
                linkified = true;
            }
        } else {
            Pattern customLinkPattern;
            if (!TextUtils.isEmpty((CharSequence)customPhoneRegex)) {
                customLinkPattern = Pattern.compile(customPhoneRegex);
                if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)customLinkPattern, (String)"tel:", null, (Linkify.TransformFilter)mFilter)) {
                    linkified = true;
                }
            } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)Patterns.PHONE, (String)"tel:", (Linkify.MatchFilter)mPhoneMatchFilter, (Linkify.TransformFilter)mFilter)) {
                linkified = true;
            }
            if (!TextUtils.isEmpty((CharSequence)customUrlRegex)) {
                customLinkPattern = Pattern.compile(customUrlRegex);
                if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)customLinkPattern, null, (Linkify.MatchFilter)mUrlMatchFilter, (Linkify.TransformFilter)mFilter)) {
                    linkified = true;
                }
            } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)Patterns.WEB_URL, (String)"http://", (String[])new String[]{"https://"}, (Linkify.MatchFilter)mUrlMatchFilter, (Linkify.TransformFilter)mFilter)) {
                linkified = true;
            }
            if (!TextUtils.isEmpty((CharSequence)customEmailRegex)) {
                customLinkPattern = Pattern.compile(customEmailRegex);
                if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)customLinkPattern, (String)"mailto:", null, (Linkify.TransformFilter)mFilter)) {
                    linkified = true;
                }
            } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)Patterns.EMAIL_ADDRESS, (String)"mailto:", null, (Linkify.TransformFilter)mFilter)) {
                linkified = true;
            }
        }
        return linkified;
    }

    public void applyChanges(Bundle changes, Message message) {
        String newText = changes.getString("EXTRA_MESSAGE_TEXT", null);
        if (!TextUtils.isEmpty((CharSequence)newText)) {
            this.setMessageTextView(newText);
            this.updateContentDescription();
        }
    }

    public void onBind() {
    }

    public void recycle() {
    }
}

