/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.uicomponents;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import android.os.Build;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.URLUtil;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ViewSwitcher;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.uicomponents.ICloseMenuListener;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.infra.ui.view.uicomponents.IConversationProvider;
import com.liveperson.infra.ui.view.uicomponents.IEnterMessageListener;
import com.liveperson.infra.ui.view.uicomponents.IOverflowMenu;
import com.liveperson.infra.ui.view.uicomponents.IUpdateFromBrand;
import com.liveperson.infra.ui.view.utils.ImageUrlUtil;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.LinkPreviewCallback;
import com.liveperson.infra.utils.SourceContent;
import com.liveperson.infra.utils.TextCrawler;
import java.util.ArrayList;

public abstract class BaseEnterMessage
extends LinearLayout
implements IConnectionChangedCustomView,
IUpdateFromBrand {
    private static final String TAG = BaseEnterMessage.class.getSimpleName();
    private static final int ATTACH_ICON_RESOURCE = R.drawable.lpinfra_ui_ic_attach;
    public static final int RECORDING_LAYOUT_ANIMATION_DURATION_MILLIS = 200;
    private EditText mTextInput;
    protected Button mTextSendButton;
    protected ImageButton mImageSendButton;
    private ImageSwitcher mAttachBtn;
    protected ImageButton mTrashButton;
    private View mDivider;
    protected ViewSwitcher mEnterMessageLayoutSwitcher;
    protected IConversationProvider mBrandIdProvider;
    protected IEnterMessageListener mEnterMessageListener;
    private Animation mAnimationOut;
    private Animation mAnimationIn;
    protected boolean mIsConnected;
    protected boolean mIsUpdated;
    private boolean mPhotoSharingKillSwitchEnabled;
    private boolean mPhotoSharingSiteSettingsEnabled;
    private IOverflowMenu mOverflowMenu;
    private ViewGroup mDropPreview;
    private LinearLayout mLinearLayout;
    private TextCrawler mTextCrawler;
    private String mCurrentTitle;
    private String mCurrentDescription;
    private String mCurrentImageURL;
    private String mCurrentUrl;
    private String mSiteName;
    private String mCurrentText;
    private Bitmap mCurrentImage;
    private boolean mIsRealTimePreviewEnabled;
    private boolean mIsLinkPreviewEnabled;
    private boolean mIsSufficientToDisplayLinkPreview;
    private boolean mIsDivider;
    private InputState mInputState = InputState.NONE;
    private LinkPreviewCallback callback = new LinkPreviewCallback(){

        public void onPre() {
        }

        private boolean validateSufficientConditionsToDisplayPreview(SourceContent sourceContent) {
            int counter = 0;
            counter = sourceContent.getSiteName().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getDescription().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getTitle().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getImages().isEmpty() ? --counter : ++counter;
            LPMobileLog.d((String)TAG, (String)("**** URL Conditions Site = " + !sourceContent.getSiteName().isEmpty() + " Description = " + !sourceContent.getDescription().isEmpty() + " Title = " + !sourceContent.getTitle().isEmpty() + " Images = " + !sourceContent.getImages().isEmpty()));
            return BaseEnterMessage.this.mIsSufficientToDisplayLinkPreview = counter >= 0;
        }

        public void onPos(final SourceContent sourceContent, boolean isNull) {
            if (isNull || sourceContent == null || TextUtils.isEmpty((CharSequence)sourceContent.getFinalUrl())) {
                BaseEnterMessage.this.mDropPreview.setVisibility(8);
                BaseEnterMessage.this.clean();
                BaseEnterMessage.this.mCurrentUrl = "";
            } else {
                if (BaseEnterMessage.this.mTextInput.getText().toString().trim().isEmpty() || !BaseEnterMessage.this.mCurrentText.equals(BaseEnterMessage.this.mTextInput.getText().toString().trim())) {
                    return;
                }
                if (this.validateSufficientConditionsToDisplayPreview(sourceContent) && BaseEnterMessage.this.mIsRealTimePreviewEnabled) {
                    final ImageView imageSet = (ImageView)BaseEnterMessage.this.mDropPreview.findViewById(R.id.image_post_set);
                    TextView titleTextView = (TextView)BaseEnterMessage.this.mDropPreview.findViewById(R.id.title);
                    TextView descriptionTextView = (TextView)BaseEnterMessage.this.mDropPreview.findViewById(R.id.description);
                    ImageButton closeBtn = (ImageButton)BaseEnterMessage.this.mDropPreview.findViewById(R.id.close_btn);
                    imageSet.setImageDrawable(null);
                    BaseEnterMessage.this.mDropPreview.setVisibility(0);
                    closeBtn.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            this.clean();
                            BaseEnterMessage.this.mDropPreview.setVisibility(8);
                        }
                    });
                    sourceContent.setImages(ImageUrlUtil.completeToValidImageUrl(sourceContent.getFinalUrl(), sourceContent.getImages()));
                    AsyncTask.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (sourceContent.getImages().isEmpty()) {
                                LPMobileLog.d((String)TAG, (String)"image isEmpty()");
                                imageSet.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        imageSet.setVisibility(8);
                                        imageSet.setImageDrawable(null);
                                    }
                                });
                                return;
                            }
                            BaseEnterMessage.this.mCurrentImage = ImageUtils.createBitmapFromURL((Context)BaseEnterMessage.this.getContext(), (String)sourceContent.getImages(), (int)imageSet.getWidth(), (int)imageSet.getHeight());
                            if (BaseEnterMessage.this.mCurrentImage != null) {
                                LPMobileLog.d((String)TAG, (String)"image mCurrentUrl != null");
                                imageSet.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        imageSet.setImageBitmap(BaseEnterMessage.this.mCurrentImage);
                                        imageSet.setVisibility(0);
                                    }
                                });
                            } else {
                                LPMobileLog.d((String)TAG, (String)"Exception in loading image ");
                                imageSet.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        imageSet.setVisibility(8);
                                        imageSet.setImageDrawable(null);
                                    }
                                });
                            }
                        }
                    });
                    if (Build.VERSION.SDK_INT >= 24) {
                        titleTextView.setText((CharSequence)Html.fromHtml((String)sourceContent.getTitle(), (int)63));
                        descriptionTextView.setText((CharSequence)Html.fromHtml((String)sourceContent.getDescription(), (int)63));
                    } else {
                        titleTextView.setText((CharSequence)Html.fromHtml((String)sourceContent.getTitle()));
                        descriptionTextView.setText((CharSequence)Html.fromHtml((String)sourceContent.getDescription()));
                    }
                }
                BaseEnterMessage.this.mCurrentTitle = sourceContent.getTitle();
                BaseEnterMessage.this.mCurrentDescription = sourceContent.getDescription();
                BaseEnterMessage.this.mCurrentUrl = sourceContent.getUrl();
                BaseEnterMessage.this.mCurrentImageURL = sourceContent.getImages();
                BaseEnterMessage.this.mSiteName = sourceContent.getSiteName();
                LPMobileLog.i((String)TAG, (String)("**** URL finished parsing: mCurrentUrl " + BaseEnterMessage.this.mCurrentUrl + " mIsRealTimePreviewEnabled: " + BaseEnterMessage.this.mIsRealTimePreviewEnabled + " mIsSufficientToDisplayLinkPreview: " + BaseEnterMessage.this.mIsSufficientToDisplayLinkPreview + " ***"));
            }
        }

        public void clean() {
            LayoutInflater inflater = (LayoutInflater)BaseEnterMessage.this.getContext().getSystemService("layout_inflater");
            View content = inflater.inflate(R.layout.lpinfra_ui_enter_message_preview_content_layout, (ViewGroup)BaseEnterMessage.this.mLinearLayout);
            ImageView imageSet = (ImageView)content.findViewById(R.id.image_post_set);
            imageSet.setImageDrawable(null);
            imageSet.setVisibility(8);
        }
    };

    public BaseEnterMessage(Context context) {
        super(context);
        this.init(context);
    }

    public BaseEnterMessage(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BaseEnterMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.lpinfra_ui_enter_message_layout, (ViewGroup)this);
    }

    public void setBrandIdProvider(IConversationProvider provider) {
        this.mBrandIdProvider = provider;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mTextInput = (EditText)this.findViewById(R.id.lpui_enter_message_text);
        this.mTextSendButton = (Button)this.findViewById(R.id.lpui_enter_message_send);
        this.mImageSendButton = (ImageButton)this.findViewById(R.id.lpui_enter_message_send_button);
        this.mAttachBtn = (ImageSwitcher)this.findViewById(R.id.lpui_attach_file);
        this.mTrashButton = (ImageButton)this.findViewById(R.id.lpui_voice_trash_button);
        this.mDivider = this.findViewById(R.id.lpui_enter_message_divider);
        this.mEnterMessageLayoutSwitcher = (ViewSwitcher)this.findViewById(R.id.lpui_enter_view_switcher);
        this.mIsRealTimePreviewEnabled = Configuration.getBoolean((int)R.bool.link_preview_enable_real_time_preview);
        this.mIsLinkPreviewEnabled = Configuration.getBoolean((int)R.bool.link_preview_enable_feature);
        this.mDropPreview = (ViewGroup)this.findViewById(R.id.lpui_drop_preview_view);
        this.mTextCrawler = new TextCrawler();
        this.setEditTextPreferences();
        this.setSendButtonPreferences();
        this.setAttachButtonPreferences();
    }

    private void setEditTextPreferences() {
        this.mTextInput.setHint(R.string.lp_enter_message);
        this.mTextInput.setImeOptions(4);
        this.mTextInput.setInputType(278529);
        this.mTextInput.setSingleLine(false);
        this.mTextInput.setMaxLines(3);
        this.mTextInput.setTextSize(2, 14.0f);
        this.mTextInput.setTextColor(Configuration.getColor((int)R.color.lp_enter_msg_text));
        this.mTextInput.setHintTextColor(Configuration.getColor((int)R.color.lp_enter_msg_hint));
        this.mTextInput.setLinksClickable(false);
        this.mTextInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 0 && event.getAction() == 0) {
                    BaseEnterMessage.this.sendMessage();
                } else if (actionId == 4) {
                    BaseEnterMessage.this.sendMessage();
                }
                return true;
            }
        });
        this.mTextInput.cancelLongPress();
        this.mTextInput.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                BaseEnterMessage.this.onAfterChangedText(s.toString());
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                BaseEnterMessage.this.onBeforeChangedText();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String msgStr = BaseEnterMessage.this.mTextInput.getText().toString().trim();
                BaseEnterMessage.this.mCurrentText = msgStr;
                if (!TextUtils.isEmpty((CharSequence)msgStr)) {
                    if (BaseEnterMessage.this.mIsLinkPreviewEnabled) {
                        BaseEnterMessage.this.generateMessageWithURL(msgStr);
                    }
                    if (BaseEnterMessage.this.mInputState != InputState.HAS_TEXT) {
                        BaseEnterMessage.this.mInputState = InputState.HAS_TEXT;
                        BaseEnterMessage.this.onHasText(true);
                        BaseEnterMessage.this.updateSendButtonState();
                    }
                } else {
                    BaseEnterMessage.this.mCurrentUrl = "";
                    BaseEnterMessage.this.clean();
                    if (BaseEnterMessage.this.mInputState == InputState.HAS_TEXT) {
                        BaseEnterMessage.this.mInputState = InputState.NONE;
                        BaseEnterMessage.this.onHasText(false);
                        BaseEnterMessage.this.updateSendButtonState();
                    }
                }
            }
        });
    }

    private void setSendButtonPreferences() {
        if (Configuration.getBoolean((int)R.bool.use_send_image_button)) {
            this.mImageSendButton.setVisibility(0);
            this.mTextSendButton.setVisibility(8);
            this.mImageSendButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseEnterMessage.this.sendMessage();
                }
            });
        } else {
            this.mImageSendButton.setVisibility(8);
            this.mTextSendButton.setVisibility(0);
            this.mTextSendButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseEnterMessage.this.sendMessage();
                }
            });
        }
        this.setEnterTextMinWidth();
    }

    private void setEnterTextMinWidth() {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mTextSendButton.setMaxWidth(metrics.widthPixels / 2);
    }

    private void setAttachButtonPreferences() {
        this.mPhotoSharingKillSwitchEnabled = PreferenceManager.getInstance().getBooleanValue("kill_switch_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        this.mPhotoSharingSiteSettingsEnabled = PreferenceManager.getInstance().getBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        if (!(Configuration.getBoolean((int)R.bool.enable_photo_sharing) && this.mPhotoSharingKillSwitchEnabled && this.mPhotoSharingSiteSettingsEnabled)) {
            this.mAttachBtn.setVisibility(8);
        }
        this.mAnimationOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.menu_icon_amination_out);
        this.mAnimationIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.menu_icon_amination_in);
        this.mAttachBtn.setFactory(new ViewSwitcher.ViewFactory(){

            public View makeView() {
                ImageView imageView = new ImageView(BaseEnterMessage.this.getContext());
                imageView.setScaleType(ImageView.ScaleType.CENTER);
                imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                return imageView;
            }
        });
        this.mAttachBtn.setImageResource(R.drawable.lpinfra_ui_ic_attach);
        this.disableAttachButton();
        this.mAttachBtn.setOnClickListener(new View.OnClickListener(){
            private ICloseMenuListener menuListener = new ICloseMenuListener(){

                @Override
                public void onCloseMenu() {
                    BaseEnterMessage.this.mAttachBtn.setImageResource(R.drawable.lpinfra_ui_ic_attach);
                    BaseEnterMessage.this.mAttachBtn.setContentDescription((CharSequence)BaseEnterMessage.this.getResources().getString(R.string.lp_accessibility_attachment_menu_button_collapsed));
                    BaseEnterMessage.this.requestFocus();
                }
            };

            public void onClick(View v) {
                if (BaseEnterMessage.this.mOverflowMenu != null) {
                    if (BaseEnterMessage.this.mOverflowMenu.isMenuOpen()) {
                        BaseEnterMessage.this.mOverflowMenu.hide();
                    } else {
                        if (BaseEnterMessage.this.mDropPreview != null) {
                            BaseEnterMessage.this.mDropPreview.setVisibility(8);
                        }
                        BaseEnterMessage.this.mAttachBtn.setImageResource(R.drawable.lpinfra_ui_ic_close);
                        BaseEnterMessage.this.mAttachBtn.setContentDescription((CharSequence)BaseEnterMessage.this.getResources().getString(R.string.lp_accessibility_attachment_menu_button_expanded));
                        BaseEnterMessage.this.mOverflowMenu.show();
                        BaseEnterMessage.this.mOverflowMenu.setOnCloseListener(this.menuListener);
                    }
                }
            }
        });
    }

    private void disableAttachButton() {
        this.mAttachBtn.setEnabled(false);
        this.mAttachBtn.setAlpha(0.5f);
    }

    private void generateMessageWithURL(String msgStr) {
        String[] urls = BaseEnterMessage.extractLinks(msgStr);
        if (urls.length > 0) {
            this.mTextCrawler.makePreview(this.callback, urls[0]);
        } else {
            this.mCurrentUrl = "";
        }
    }

    public static String[] extractLinks(String text) {
        ArrayList<String> links = new ArrayList<String>();
        String[] l = text.split("\\s+");
        for (int i = 0; i < l.length; ++i) {
            if (!URLUtil.isValidUrl((String)l[i])) continue;
            links.add(l[i]);
        }
        return links.toArray(new String[links.size()]);
    }

    private void clean() {
        this.mCurrentImageURL = "";
        this.mCurrentUrl = "";
        this.mCurrentDescription = "";
        this.mCurrentTitle = "";
        this.mCurrentImage = null;
        if (this.callback != null) {
            this.callback.clean();
        }
        if (this.mDropPreview != null) {
            this.mDropPreview.setVisibility(8);
        }
    }

    protected void clearText() {
        this.mTextInput.setText((CharSequence)"");
        this.clean();
    }

    protected void showNoNetworkMessage() {
        if (ForegroundService.getInstance().isBrandForeground()) {
            Toast.makeText((Context)this.getContext(), (int)R.string.lp_no_network_toast_message, (int)1).show();
        }
    }

    protected void sendMessage() {
        String msgStr = this.mTextInput.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)msgStr)) {
            if (TextUtils.isEmpty((CharSequence)this.mCurrentUrl) || !this.mIsSufficientToDisplayLinkPreview) {
                LPMobileLog.d((String)TAG, (String)("url send Message, mIsSufficientToDisplayLinkPreview: " + this.mIsSufficientToDisplayLinkPreview));
                this.sendMessage(msgStr);
            } else {
                LPMobileLog.d((String)TAG, (String)"url sendMessageWithURL");
                this.sendMessageWithURL(msgStr, this.mCurrentUrl, this.mCurrentTitle, this.mCurrentImageURL, this.mCurrentDescription, this.mSiteName);
            }
            this.clean();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mTextInput.setEnabled(enabled);
        this.mAttachBtn.setEnabled(enabled);
        if (enabled) {
            this.updateAttachButton();
        } else {
            this.mTextSendButton.setEnabled(enabled);
            this.mImageSendButton.setEnabled(enabled);
        }
    }

    @Override
    public void onUpdate(boolean isUpdated) {
        this.mIsUpdated = isUpdated;
        this.updateSendButtonState();
    }

    @Override
    public void onConnectionChanged(boolean isConnected) {
        this.mIsConnected = isConnected;
        this.updateAttachButton();
        this.mPhotoSharingKillSwitchEnabled = PreferenceManager.getInstance().getBooleanValue("kill_switch_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        this.mPhotoSharingSiteSettingsEnabled = PreferenceManager.getInstance().getBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        if (!(Configuration.getBoolean((int)R.bool.enable_photo_sharing) && this.mPhotoSharingKillSwitchEnabled && this.mPhotoSharingSiteSettingsEnabled)) {
            this.mAttachBtn.setVisibility(8);
        } else {
            this.mAttachBtn.setVisibility(0);
        }
    }

    private void setAnimationOnAttachButton() {
        this.mAttachBtn.setInAnimation(this.mAnimationIn);
        this.mAttachBtn.setOutAnimation(this.mAnimationOut);
    }

    private void cancelAnimationOnAttachButton() {
        this.mAttachBtn.setInAnimation(null);
        this.mAttachBtn.setOutAnimation(null);
    }

    protected void updateSendButtonState() {
        int sendBtnColor;
        if (!this.shouldUpdateSendButton()) {
            return;
        }
        String msgStr = this.mTextInput.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)msgStr) && this.mIsConnected && this.mIsUpdated) {
            sendBtnColor = R.color.lp_send_button_text_enable;
            this.mTextSendButton.setEnabled(true);
            this.mImageSendButton.setEnabled(true);
        } else if (TextUtils.isEmpty((CharSequence)msgStr)) {
            sendBtnColor = R.color.lp_send_button_text_disable;
            this.mTextSendButton.setEnabled(false);
            this.mImageSendButton.setEnabled(false);
            this.clean();
        } else {
            sendBtnColor = R.color.lp_send_button_text_disable;
            this.mTextSendButton.setEnabled(false);
            this.mImageSendButton.setEnabled(false);
        }
        this.mTextSendButton.setTextColor(Configuration.getColor((int)sendBtnColor));
        this.mImageSendButton.getDrawable().setColorFilter(Configuration.getColor((int)sendBtnColor), PorterDuff.Mode.SRC_IN);
    }

    protected void enableSendButton() {
        int sendBtnColor = R.color.lp_send_button_text_enable;
        this.mTextSendButton.setEnabled(true);
        this.mImageSendButton.setEnabled(true);
        this.mTextSendButton.setTextColor(Configuration.getColor((int)sendBtnColor));
        this.mImageSendButton.getDrawable().setColorFilter(Configuration.getColor((int)sendBtnColor), PorterDuff.Mode.SRC_IN);
    }

    private void updateAttachButton() {
        if (this.mIsConnected) {
            this.cancelAnimationOnAttachButton();
            this.enableAttachButton();
            this.setAnimationOnAttachButton();
        } else {
            if (this.mOverflowMenu.isMenuOpen()) {
                this.mOverflowMenu.hide();
            }
            this.cancelAnimationOnAttachButton();
            this.disableAttachButton();
        }
    }

    public void setOverflowMenu(IOverflowMenu menu) {
        this.mOverflowMenu = menu;
        this.mOverflowMenu.setOnCloseListener(new ICloseMenuListener(){

            @Override
            public void onCloseMenu() {
            }
        });
    }

    private void enableAttachButton() {
        this.mAttachBtn.setEnabled(true);
        this.mAttachBtn.setAlpha(1.0f);
    }

    public void setEnterMessageListener(IEnterMessageListener enterMessageListener) {
        this.mEnterMessageListener = enterMessageListener;
    }

    public void setText(String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg) && this.mTextInput != null) {
            this.mTextInput.setText((CharSequence)msg);
        } else {
            LPMobileLog.d((String)TAG, (String)("Failed to set text message with text: " + msg));
        }
    }

    protected abstract void sendMessageWithURL(String var1, String var2, String var3, String var4, String var5, String var6);

    protected abstract void sendMessage(String var1);

    protected abstract void onHasText(boolean var1);

    protected abstract void onAfterChangedText(String var1);

    protected abstract void onBeforeChangedText();

    protected abstract boolean shouldUpdateSendButton();

    private static enum InputState {
        HAS_TEXT,
        NONE;

    }
}

