/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.header.caching;

import android.support.v4.util.LongSparseArray;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.header.StickyRecyclerHeadersAdapter;
import com.liveperson.infra.ui.view.header.caching.HeaderProvider;
import com.liveperson.infra.ui.view.header.util.OrientationProvider;

public class HeaderViewCache
implements HeaderProvider {
    private final StickyRecyclerHeadersAdapter mAdapter;
    private final LongSparseArray<BaseViewHolder> mHeaderViews = new LongSparseArray();
    private final OrientationProvider mOrientationProvider;

    public HeaderViewCache(StickyRecyclerHeadersAdapter adapter, OrientationProvider orientationProvider) {
        this.mAdapter = adapter;
        this.mOrientationProvider = orientationProvider;
    }

    @Override
    public View getHeader(RecyclerView parent, int position) {
        long headerId = this.mAdapter.getHeaderId(position);
        BaseViewHolder headerHolder = (BaseViewHolder)((Object)this.mHeaderViews.get(headerId));
        if (headerHolder == null) {
            headerHolder = (BaseViewHolder)((Object)this.mAdapter.onCreateHeaderViewHolder((ViewGroup)parent));
            this.mHeaderViews.put(headerId, (Object)headerHolder);
        }
        this.mAdapter.onBindHeaderViewHolder(headerHolder, position);
        this.measureHeader(parent, headerHolder);
        return headerHolder.itemView;
    }

    @Override
    public void invalidate() {
        this.mHeaderViews.clear();
    }

    private void measureHeader(RecyclerView parent, BaseViewHolder viewHolder) {
        int heightSpec;
        int widthSpec;
        View header = viewHolder.itemView;
        if (header.getLayoutParams() == null) {
            header.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        }
        if (this.mOrientationProvider.getOrientation(parent) == 1) {
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
        } else {
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0);
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0x40000000);
        }
        int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)header.getLayoutParams().width);
        int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)header.getLayoutParams().height);
        header.measure(childWidth, childHeight);
        header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
    }
}

