/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.view.View;
import android.widget.TextView;

import com.liveperson.infra.ui.R;

/**
 * Created by nirni on 11/11/15.
 * <p/>
 * A ViewHolder the have message, timestamp and avatar view for messages from agent.
 */
public abstract class StartViewHolder extends BaseMessageViewHolder {

    protected TextView mTimestampTextView;

    public StartViewHolder(View itemView) {
        super(itemView);
        mTimestampTextView = (TextView)itemView.findViewById(R.id.lpui_message_timestamp);
    }

    public void setTimestampTextView(long timestamp){
		super.setTimestampTextView(timestamp);

        String timestampText = getTimeFormat(timestamp);
        mTimestampTextView.setText(timestampText);
    }
}
