package com.liveperson.infra.ui.view.ui;

import android.content.Context;
import android.util.AttributeSet;

import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.utils.UIUtils;

/**
 * Created by nirni on 6/15/17.
 */

public class CustomEditText extends android.support.v7.widget.AppCompatEditText {

	public static final String TAG = CustomEditText.class.getSimpleName();

	private String mFontName;

	public CustomEditText(Context context) {
		super(context);
	}

	public CustomEditText(Context context, AttributeSet attrs) {
		super(context, attrs);

		applyCustomFont(context, attrs);
	}

	public CustomEditText(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);

		applyCustomFont(context, attrs);
	}

	/**
	 *
	 * @param context
	 * @param attrs
	 */
	private void applyCustomFont(Context context, AttributeSet attrs) {

		UIUtils.changeCustomTextViewFont(this, context, attrs, R.styleable.CustomEditText, R.styleable.CustomEditText_font_name);

	}

}
