package com.liveperson.infra.ui.view.ui;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.utils.UIUtils;

/**
 * Created by nirni on 6/14/17.
 */

public class CustomTextView extends android.support.v7.widget.AppCompatTextView {

	public static final String TAG = CustomTextView.class.getSimpleName();

	public CustomTextView(Context context) {
		super(context);
	}

	public CustomTextView(Context context, @Nullable AttributeSet attrs) {
		super(context, attrs);

		applyCustomFont(context, attrs);
	}

	public CustomTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);

		applyCustomFont(context, attrs);
	}

	private void applyCustomFont(Context context, AttributeSet attrs) {


		UIUtils.changeCustomTextViewFont(this, context, attrs, R.styleable.CustomTextView, R.styleable.CustomTextView_font_name);

	}



}
