/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.resources;

import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.widget.TextView;
import com.liveperson.infra.configuration.Configuration;

public class ResourceHelper {
    public static void updateTextColor(TextView textView, @ColorRes int colorResId) {
        if (textView == null) {
            return;
        }
        textView.setTextColor(Configuration.getColor((int)colorResId));
    }

    public static void updateTextColorLink(TextView textView, @ColorRes int colorResId) {
        if (textView == null) {
            return;
        }
        textView.setLinkTextColor(Configuration.getColor((int)colorResId));
    }

    public static void updateBackgroundStrokeColor(View view, @ColorRes int colorResId, @DimenRes int strokeWidthDimensionId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable = (GradientDrawable)background;
            drawable.setStroke((int)Configuration.getDimension((int)strokeWidthDimensionId), Configuration.getColor((int)colorResId));
        }
    }

    public static void updateBackgroundDrawable(View view, @DrawableRes int drawableResId) {
        if (view == null) {
            return;
        }
        Drawable bg = ResourcesCompat.getDrawable((Resources)view.getResources(), (int)drawableResId, null);
        view.setBackground(bg);
    }

    public static void updateBackgroundSolidColor(View view, @ColorRes int colorResId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable = (GradientDrawable)background;
            drawable.setColor(Configuration.getColor((int)colorResId));
        }
    }

    public static void updateBackgroundColor(View view, int colorResId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof ColorDrawable) {
            ((ColorDrawable)background).setColor(Configuration.getColor((int)colorResId));
        }
    }
}

