/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.resources;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.widget.TextView;
import com.liveperson.infra.configuration.Configuration;

public class ResourceHelper {
    public static void updateTextColor(TextView textView, @ColorRes int colorResId) {
        if (textView == null) {
            return;
        }
        textView.setTextColor(ContextCompat.getColor((Context)textView.getContext(), (int)colorResId));
    }

    public static void updateTextColorLink(TextView textView, @ColorRes int colorResId) {
        if (textView == null) {
            return;
        }
        textView.setLinkTextColor(ContextCompat.getColor((Context)textView.getContext(), (int)colorResId));
    }

    public static void updateBackgroundStrokeColor(View view, @ColorRes int colorResId, @DimenRes int strokeWidthDimensionId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable2 = (GradientDrawable)background;
            drawable2.setStroke((int)Configuration.getDimension((int)strokeWidthDimensionId), ContextCompat.getColor((Context)view.getContext(), (int)colorResId));
        }
    }

    public static void updateBackgroundDrawable(View view, @DrawableRes int drawableResId) {
        if (view == null) {
            return;
        }
        Drawable bg = ResourcesCompat.getDrawable((Resources)view.getResources(), (int)drawableResId, null);
        view.setBackground(bg);
    }

    public static void updateBackgroundSolidColor(View view, @ColorRes int colorResId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable2 = (GradientDrawable)background;
            drawable2.setColor(ContextCompat.getColor((Context)view.getContext(), (int)colorResId));
        }
    }

    public static void updateBackgroundColor(View view, int colorResId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof ColorDrawable) {
            ((ColorDrawable)background).setColor(ContextCompat.getColor((Context)view.getContext(), (int)colorResId));
        }
    }
}

