/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.liveperson.infra.log.LPLog;

public class UIUtils {
    public static final String TAG = UIUtils.class.getSimpleName();
    private static final String[] HTML_TAGS = new String[]{"<b>", "</b>", "<i>", "</i>"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeCustomTextViewFont(TextView view, Context context, AttributeSet attrs, int[] customViewResId, int customViewFontAttributeResId) {
        String fontName;
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, customViewResId, 0, 0);
        try {
            fontName = array.getString(customViewFontAttributeResId);
        }
        finally {
            array.recycle();
        }
        if (!view.isInEditMode() && !TextUtils.isEmpty((CharSequence)fontName)) {
            try {
                Typeface typeFace = fontName.toLowerCase().contains(".") ? Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName) : Typeface.create((String)fontName, (int)view.getTypeface().getStyle());
                view.setTypeface(typeFace, view.getTypeface().getStyle());
            }
            catch (Exception e) {
                LPLog.INSTANCE.w(TAG, "applyCustomFont: Error setting custom font: " + fontName, (Throwable)e);
            }
        }
    }

    public static void startProgressBarAnimation(ImageView view, @DrawableRes int progressBarDrawable) {
        RotateAnimation a = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        a.setInterpolator((Interpolator)new LinearInterpolator());
        a.setFillEnabled(true);
        a.setFillAfter(true);
        a.setDuration(1000L);
        a.setRepeatCount(-1);
        view.setImageResource(progressBarDrawable);
        view.startAnimation((Animation)a);
    }

    private static boolean isEmoji(String message) {
        return message.matches("(?:[\ud83c\udf00-\ud83d\uddff]|[\ud83e\udd00-\ud83e\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]|[\u2600-\u26ff]\ufe0f?|[\u2700-\u27bf]\ufe0f?|\u24c2\ufe0f?|[\ud83c\udde6-\ud83c\uddff]{1,2}|[\ud83c\udd70\ud83c\udd71\ud83c\udd7e\ud83c\udd7f\ud83c\udd8e\ud83c\udd91-\ud83c\udd9a]\ufe0f?|[#*0-9]\ufe0f?\u20e3|[\u2194-\u2199\u21a9-\u21aa]\ufe0f?|[\u2b05-\u2b07\u2b1b\u2b1c\u2b50\u2b55]\ufe0f?|[\u2934\u2935]\ufe0f?|[\u3030\u303d]\ufe0f?|[\u3297\u3299]\ufe0f?|[\ud83c\ude01\ud83c\ude02\ud83c\ude1a\ud83c\ude2f\ud83c\ude32-\ud83c\ude3a\ud83c\ude50\ud83c\ude51]\ufe0f?|[\u203c\u2049]\ufe0f?|[\u25aa\u25ab\u25b6\u25c0\u25fb-\u25fe]\ufe0f?|[\u00a9\u00ae]\ufe0f?|[\u2122\u2139]\ufe0f?|\ud83c\udc04\ufe0f?|\ud83c\udccf\ufe0f?|[\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa]\ufe0f?)+");
    }

    public static int detectEmojis(String message) {
        int len = message.length();
        int NumEmoji = 0;
        if (UIUtils.isEmoji(message) && len < 5) {
            for (int i = 0; i < len; ++i) {
                if (UIUtils.isEmoji(message.charAt(i) + "")) {
                    ++NumEmoji;
                    continue;
                }
                if (i >= len - 1 || !Character.isSurrogatePair(message.charAt(i), message.charAt(i + 1))) continue;
                ++i;
                ++NumEmoji;
            }
            return NumEmoji;
        }
        return 0;
    }

    public static boolean containsHtmlTag(String message) {
        for (String tag : HTML_TAGS) {
            if (!message.contains(tag)) continue;
            return true;
        }
        return false;
    }
}

