package com.liveperson.infra.ui.view.resources;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.widget.TextView;

import com.liveperson.infra.configuration.Configuration;

/**
 * Created by Ilya Gazman on 12/15/2015.
 * Edited by Perry on 4/2/2016.
 */
public class ResourceHelper {

    public static void updateTextColor(TextView textView, @ColorRes int colorResId) {
        if (textView == null) return;

        textView.setTextColor(ContextCompat.getColor(textView.getContext(), colorResId));
    }

    public static void updateTextColorLink(TextView textView, @ColorRes int colorResId) {
        if (textView == null) return;

        textView.setLinkTextColor(ContextCompat.getColor(textView.getContext(), colorResId));
    }

    public static void updateBackgroundStrokeColor(View view, @ColorRes int colorResId, @DimenRes int strokeWidthDimensionId) {
        if (view == null) return;

        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable = (GradientDrawable) background;
            drawable.setStroke((int) Configuration.getDimension(strokeWidthDimensionId), ContextCompat.getColor(view.getContext(), colorResId));
        }
    }

    public static void updateBackgroundDrawable(View view, @DrawableRes int drawableResId) {
        if (view == null) return;

        Drawable bg = ResourcesCompat.getDrawable(view.getResources(), drawableResId, null);
        view.setBackground(bg);
    }

    public static void updateBackgroundSolidColor(View view, @ColorRes int colorResId) {
        if (view == null) return;

        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable = (GradientDrawable) background;
            drawable.setColor(ContextCompat.getColor(view.getContext(), colorResId));
        }
    }

    /**
     * Update background color set by android:background
     * @param view
     * @param colorResId
     */
    public static void updateBackgroundColor(View view, int colorResId) {
        if (view == null) return;

        Drawable background = view.getBackground();
        if (background instanceof ColorDrawable) {
            ((ColorDrawable) background).setColor(ContextCompat.getColor(view.getContext(), colorResId));
        }
    }
}
