/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.sticky;

import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.ui.view.sticky.StickyHeaderHolder;
import java.util.ArrayList;
import java.util.List;

public class StickyHeadersLinearLayoutManager<T extends RecyclerView.Adapter>
extends LinearLayoutManager {
    private static final String TAG = "StickyHeadersLinearLayoutManager";
    private T mAdapter;
    private float mTranslationX;
    private float mTranslationY;
    private int mStickyHeaderAttachCount = 0;
    private List<Integer> mHeaderPositions = new ArrayList<Integer>(0);
    private RecyclerView.AdapterDataObserver mHeaderPositionsObserver = new HeaderPositionsAdapterDataObserver();
    private View mStickyHeader;
    private int mStickyHeaderPosition = -1;
    private int mPendingScrollPosition = -1;
    private int mPendingScrollOffset = 0;

    public StickyHeadersLinearLayoutManager(Context context) {
        super(context);
    }

    public StickyHeadersLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public void setStickyHeaderTranslationY(float translationY) {
        this.mTranslationY = translationY;
        this.requestLayout();
    }

    public void setStickyHeaderTranslationX(float translationX) {
        this.mTranslationX = translationX;
        this.requestLayout();
    }

    public boolean isStickyHeader(View view) {
        return view == this.mStickyHeader;
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull AccessibilityNodeInfoCompat info) {
        super.onInitializeAccessibilityNodeInfo(recycler, state, info);
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.setAdapter(view.getAdapter());
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        super.onAdapterChanged(oldAdapter, newAdapter);
        this.setAdapter(newAdapter);
    }

    private void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mHeaderPositionsObserver);
        }
        if (adapter instanceof StickyHeaderHolder) {
            this.mAdapter = adapter;
            this.mAdapter.registerAdapterDataObserver(this.mHeaderPositionsObserver);
            this.mHeaderPositionsObserver.onChanged();
        } else {
            this.mAdapter = null;
            this.mHeaderPositions.clear();
        }
    }

    public int findLastVisibleItemPosition() {
        this.detachStickyHeader();
        int position = super.findLastVisibleItemPosition();
        this.attachStickyHeader();
        return position;
    }

    public int findFirstVisibleItemPosition() {
        this.detachStickyHeader();
        int position = super.findFirstVisibleItemPosition();
        this.attachStickyHeader();
        return position;
    }

    public int findFirstCompletelyVisibleItemPosition() {
        this.detachStickyHeader();
        int position = super.findFirstCompletelyVisibleItemPosition();
        this.attachStickyHeader();
        return position;
    }

    public int findLastCompletelyVisibleItemPosition() {
        this.detachStickyHeader();
        int position = super.findLastCompletelyVisibleItemPosition();
        this.attachStickyHeader();
        return position;
    }

    public Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState();
        ss.superState = super.onSaveInstanceState();
        ss.pendingScrollPosition = this.mPendingScrollPosition;
        ss.pendingScrollOffset = this.mPendingScrollOffset;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState ss = (SavedState)state;
            this.mPendingScrollPosition = ss.pendingScrollPosition;
            this.mPendingScrollOffset = ss.pendingScrollOffset;
            state = ss.superState;
        }
        super.onRestoreInstanceState(state);
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachStickyHeader();
        int scrolled = super.scrollVerticallyBy(dy, recycler, state);
        this.attachStickyHeader();
        if (scrolled != 0) {
            this.updateStickyHeader(recycler, false);
        }
        return scrolled;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachStickyHeader();
        int scrolled = super.scrollHorizontallyBy(dx, recycler, state);
        this.attachStickyHeader();
        if (scrolled != 0) {
            this.updateStickyHeader(recycler, false);
        }
        return scrolled;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachStickyHeader();
        super.onLayoutChildren(recycler, state);
        this.attachStickyHeader();
        if (!state.isPreLayout()) {
            this.updateStickyHeader(recycler, true);
        }
    }

    public void scrollToPosition(int position) {
        this.scrollToPositionWithOffset(position, Integer.MIN_VALUE);
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        this.scrollToPositionWithOffset(position, offset, true);
    }

    private void scrollToPositionWithOffset(int position, int offset, boolean adjustForStickyHeader) {
        this.setPendingScroll(-1, Integer.MIN_VALUE);
        if (!adjustForStickyHeader) {
            super.scrollToPositionWithOffset(position, offset);
            return;
        }
        int headerIndex = this.findHeaderIndexOrBefore(position);
        if (headerIndex == -1 || this.findHeaderIndex(position) != -1) {
            super.scrollToPositionWithOffset(position, offset);
            return;
        }
        if (this.findHeaderIndex(position - 1) != -1) {
            super.scrollToPositionWithOffset(position - 1, offset);
            return;
        }
        if (this.mStickyHeader != null && headerIndex == this.findHeaderIndex(this.mStickyHeaderPosition)) {
            int adjustedOffset = (offset != Integer.MIN_VALUE ? offset : 0) + this.mStickyHeader.getHeight();
            super.scrollToPositionWithOffset(position, adjustedOffset);
            return;
        }
        this.setPendingScroll(position, offset);
        super.scrollToPositionWithOffset(position, offset);
    }

    public int computeVerticalScrollExtent(RecyclerView.State state) {
        this.detachStickyHeader();
        int extent = super.computeVerticalScrollExtent(state);
        this.attachStickyHeader();
        return extent;
    }

    public int computeVerticalScrollOffset(RecyclerView.State state) {
        this.detachStickyHeader();
        int offset = super.computeVerticalScrollOffset(state);
        this.attachStickyHeader();
        return offset;
    }

    public int computeVerticalScrollRange(RecyclerView.State state) {
        this.detachStickyHeader();
        int range = super.computeVerticalScrollRange(state);
        this.attachStickyHeader();
        return range;
    }

    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        this.detachStickyHeader();
        int extent = super.computeHorizontalScrollExtent(state);
        this.attachStickyHeader();
        return extent;
    }

    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        this.detachStickyHeader();
        int offset = super.computeHorizontalScrollOffset(state);
        this.attachStickyHeader();
        return offset;
    }

    public int computeHorizontalScrollRange(RecyclerView.State state) {
        this.detachStickyHeader();
        int range = super.computeHorizontalScrollRange(state);
        this.attachStickyHeader();
        return range;
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        this.detachStickyHeader();
        PointF vector = super.computeScrollVectorForPosition(targetPosition);
        this.attachStickyHeader();
        return vector;
    }

    public View onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachStickyHeader();
        View view = super.onFocusSearchFailed(focused, focusDirection, recycler, state);
        this.attachStickyHeader();
        return view;
    }

    public void onInitializeAccessibilityNodeInfoForItem(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
        if (host != this.mStickyHeader) {
            super.onInitializeAccessibilityNodeInfoForItem(recycler, state, host, info);
        }
    }

    private void detachStickyHeader() {
        if (--this.mStickyHeaderAttachCount == 0 && this.mStickyHeader != null) {
            this.detachView(this.mStickyHeader);
        }
    }

    private void attachStickyHeader() {
        if (++this.mStickyHeaderAttachCount == 1 && this.mStickyHeader != null) {
            try {
                this.attachView(this.mStickyHeader);
            }
            catch (IllegalArgumentException exception) {
                LPLog.INSTANCE.d(TAG, "Header is already attached", (Throwable)exception);
            }
        }
    }

    private void updateStickyHeader(RecyclerView.Recycler recycler, boolean layout2) {
        int headerCount = this.mHeaderPositions.size();
        int childCount = this.getChildCount();
        if (headerCount > 0 && childCount > 0) {
            View anchorView = null;
            int anchorIndex = -1;
            int anchorPos = -1;
            for (int i = 0; i < childCount; ++i) {
                RecyclerView.LayoutParams params;
                View child = this.getChildAt(i);
                if (!this.isViewValidAnchor(child, params = (RecyclerView.LayoutParams)child.getLayoutParams())) continue;
                anchorView = child;
                anchorIndex = i;
                anchorPos = params.getViewAdapterPosition();
                break;
            }
            if (anchorView != null && anchorPos != -1) {
                int nextHeaderPos;
                int headerIndex = this.findHeaderIndexOrBefore(anchorPos);
                int headerPos = headerIndex != -1 ? this.mHeaderPositions.get(headerIndex) : -1;
                int n = nextHeaderPos = headerCount > headerIndex + 1 ? this.mHeaderPositions.get(headerIndex + 1) : -1;
                if (headerPos != -1 && (headerPos != anchorPos || this.isViewOnBoundary(anchorView)) && nextHeaderPos != headerPos + 1) {
                    if (this.mStickyHeader != null && this.getItemViewType(this.mStickyHeader) != this.mAdapter.getItemViewType(headerPos)) {
                        this.scrapStickyHeader(recycler);
                    }
                    if (this.mStickyHeader == null) {
                        this.createStickyHeader(recycler, headerPos);
                    }
                    if (layout2 || this.getPosition(this.mStickyHeader) != headerPos) {
                        this.bindStickyHeader(recycler, headerPos);
                    }
                    View nextHeaderView = null;
                    if (nextHeaderPos != -1 && (nextHeaderView = this.getChildAt(anchorIndex + (nextHeaderPos - anchorPos))) == this.mStickyHeader) {
                        nextHeaderView = null;
                    }
                    this.mStickyHeader.setTranslationX(this.getX(this.mStickyHeader, nextHeaderView));
                    this.mStickyHeader.setTranslationY(this.getY(this.mStickyHeader, nextHeaderView));
                    return;
                }
            }
        }
        if (this.mStickyHeader != null) {
            this.scrapStickyHeader(recycler);
        }
    }

    private void createStickyHeader(@NonNull RecyclerView.Recycler recycler, int position) {
        int listSize;
        T adapter = this.mAdapter;
        int n = listSize = adapter == null ? 0 : adapter.getItemCount();
        if (position < 0 || position >= listSize) {
            return;
        }
        View stickyHeader = recycler.getViewForPosition(position);
        if (this.mAdapter instanceof StickyHeaderHolder.ViewDecorator) {
            ((StickyHeaderHolder.ViewDecorator)this.mAdapter).decorateHeaderView(stickyHeader, position);
        }
        this.addView(stickyHeader);
        this.measureAndLayout(stickyHeader);
        this.ignoreView(stickyHeader);
        this.mStickyHeader = stickyHeader;
        this.mStickyHeaderPosition = position;
        this.mStickyHeaderAttachCount = 1;
    }

    private void bindStickyHeader(@NonNull RecyclerView.Recycler recycler, int position) {
        recycler.bindViewToPosition(this.mStickyHeader, position);
        this.mStickyHeaderPosition = position;
        this.measureAndLayout(this.mStickyHeader);
        if (this.mPendingScrollPosition != -1) {
            final ViewTreeObserver vto = this.mStickyHeader.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    if (StickyHeadersLinearLayoutManager.this.mPendingScrollPosition != -1) {
                        StickyHeadersLinearLayoutManager.this.scrollToPositionWithOffset(StickyHeadersLinearLayoutManager.this.mPendingScrollPosition, StickyHeadersLinearLayoutManager.this.mPendingScrollOffset);
                        StickyHeadersLinearLayoutManager.this.setPendingScroll(-1, Integer.MIN_VALUE);
                    }
                }
            });
        }
    }

    private void measureAndLayout(View stickyHeader) {
        this.measureChildWithMargins(stickyHeader, 0, 0);
        if (this.getOrientation() == 1) {
            stickyHeader.layout(this.getPaddingLeft(), 0, this.getWidth() - this.getPaddingRight(), stickyHeader.getMeasuredHeight());
        } else {
            stickyHeader.layout(0, this.getPaddingTop(), stickyHeader.getMeasuredWidth(), this.getHeight() - this.getPaddingBottom());
        }
    }

    private void scrapStickyHeader(@Nullable RecyclerView.Recycler recycler) {
        View stickyHeader = this.mStickyHeader;
        this.mStickyHeader = null;
        this.mStickyHeaderPosition = -1;
        stickyHeader.setTranslationX(0.0f);
        stickyHeader.setTranslationY(0.0f);
        if (this.mAdapter instanceof StickyHeaderHolder.ViewDecorator) {
            ((StickyHeaderHolder.ViewDecorator)this.mAdapter).removeHeaderViewDecoration(stickyHeader);
        }
        this.stopIgnoringView(stickyHeader);
        this.removeView(stickyHeader);
        if (recycler != null) {
            recycler.recycleView(stickyHeader);
        }
    }

    private boolean isViewValidAnchor(View view, RecyclerView.LayoutParams params) {
        if (!params.isItemRemoved() && !params.isViewInvalid()) {
            if (this.getOrientation() == 1) {
                if (this.getReverseLayout()) {
                    return (float)view.getTop() + view.getTranslationY() <= (float)this.getHeight() + this.mTranslationY;
                }
                return (float)view.getBottom() - view.getTranslationY() >= this.mTranslationY;
            }
            if (this.getReverseLayout()) {
                return (float)view.getLeft() + view.getTranslationX() <= (float)this.getWidth() + this.mTranslationX;
            }
            return (float)view.getRight() - view.getTranslationX() >= this.mTranslationX;
        }
        return false;
    }

    private boolean isViewOnBoundary(View view) {
        if (this.getOrientation() == 1) {
            if (this.getReverseLayout()) {
                return (float)view.getBottom() - view.getTranslationY() > (float)this.getHeight() + this.mTranslationY;
            }
            return (float)view.getTop() + view.getTranslationY() < this.mTranslationY;
        }
        if (this.getReverseLayout()) {
            return (float)view.getRight() - view.getTranslationX() > (float)this.getWidth() + this.mTranslationX;
        }
        return (float)view.getLeft() + view.getTranslationX() < this.mTranslationX;
    }

    private float getY(View headerView, View nextHeaderView) {
        if (this.getOrientation() == 1) {
            float y = this.mTranslationY;
            if (this.getReverseLayout()) {
                y += (float)(this.getHeight() - headerView.getHeight());
            }
            if (nextHeaderView != null) {
                y = this.getReverseLayout() ? Math.max((float)nextHeaderView.getBottom(), y) : Math.min((float)(nextHeaderView.getTop() - headerView.getHeight()), y);
            }
            return y;
        }
        return this.mTranslationY;
    }

    private float getX(View headerView, View nextHeaderView) {
        if (this.getOrientation() != 1) {
            float x = this.mTranslationX;
            if (this.getReverseLayout()) {
                x += (float)(this.getWidth() - headerView.getWidth());
            }
            if (nextHeaderView != null) {
                x = this.getReverseLayout() ? Math.max((float)nextHeaderView.getRight(), x) : Math.min((float)(nextHeaderView.getLeft() - headerView.getWidth()), x);
            }
            return x;
        }
        return this.mTranslationX;
    }

    private int findHeaderIndex(int position) {
        int low = 0;
        int high = this.mHeaderPositions.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (this.mHeaderPositions.get(middle) > position) {
                high = middle - 1;
                continue;
            }
            if (this.mHeaderPositions.get(middle) < position) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private int findHeaderIndexOrBefore(int position) {
        int low = 0;
        int high = this.mHeaderPositions.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (this.mHeaderPositions.get(middle) > position) {
                high = middle - 1;
                continue;
            }
            if (middle < this.mHeaderPositions.size() - 1 && this.mHeaderPositions.get(middle + 1) <= position) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private int findHeaderIndexOrNext(int position) {
        int low = 0;
        int high = this.mHeaderPositions.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (middle > 0 && this.mHeaderPositions.get(middle - 1) >= position) {
                high = middle - 1;
                continue;
            }
            if (this.mHeaderPositions.get(middle) < position) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private void setPendingScroll(int position, int offset) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollOffset = offset;
    }

    public static class SavedState
    implements Parcelable {
        private Parcelable superState;
        private int pendingScrollPosition;
        private int pendingScrollOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState() {
        }

        public SavedState(Parcel in) {
            this.superState = in.readParcelable(SavedState.class.getClassLoader());
            this.pendingScrollPosition = in.readInt();
            this.pendingScrollOffset = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable(this.superState, flags);
            dest.writeInt(this.pendingScrollPosition);
            dest.writeInt(this.pendingScrollOffset);
        }
    }

    private class HeaderPositionsAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private HeaderPositionsAdapterDataObserver() {
        }

        public void onChanged() {
            StickyHeadersLinearLayoutManager.this.mHeaderPositions.clear();
            int itemCount = StickyHeadersLinearLayoutManager.this.mAdapter.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                if (!((StickyHeaderHolder)StickyHeadersLinearLayoutManager.this.mAdapter).isStickyHeader(i)) continue;
                StickyHeadersLinearLayoutManager.this.mHeaderPositions.add(i);
            }
            if (StickyHeadersLinearLayoutManager.this.mStickyHeader != null && !StickyHeadersLinearLayoutManager.this.mHeaderPositions.contains(StickyHeadersLinearLayoutManager.this.mStickyHeaderPosition)) {
                StickyHeadersLinearLayoutManager.this.scrapStickyHeader(null);
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            int i;
            int headerCount = StickyHeadersLinearLayoutManager.this.mHeaderPositions.size();
            if (headerCount > 0) {
                for (i = StickyHeadersLinearLayoutManager.this.findHeaderIndexOrNext(positionStart); i != -1 && i < headerCount; ++i) {
                    StickyHeadersLinearLayoutManager.this.mHeaderPositions.set(i, (Integer)StickyHeadersLinearLayoutManager.this.mHeaderPositions.get(i) + itemCount);
                }
            }
            for (i = positionStart; i < positionStart + itemCount; ++i) {
                if (!((StickyHeaderHolder)StickyHeadersLinearLayoutManager.this.mAdapter).isStickyHeader(i)) continue;
                int headerIndex = StickyHeadersLinearLayoutManager.this.findHeaderIndexOrNext(i);
                if (headerIndex != -1) {
                    StickyHeadersLinearLayoutManager.this.mHeaderPositions.add(headerIndex, i);
                    continue;
                }
                StickyHeadersLinearLayoutManager.this.mHeaderPositions.add(i);
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            int headerCount = StickyHeadersLinearLayoutManager.this.mHeaderPositions.size();
            if (headerCount > 0) {
                int i;
                for (i = positionStart + itemCount - 1; i >= positionStart; --i) {
                    int index = StickyHeadersLinearLayoutManager.this.findHeaderIndex(i);
                    if (index == -1) continue;
                    StickyHeadersLinearLayoutManager.this.mHeaderPositions.remove(index);
                    --headerCount;
                }
                if (StickyHeadersLinearLayoutManager.this.mStickyHeader != null && !StickyHeadersLinearLayoutManager.this.mHeaderPositions.contains(StickyHeadersLinearLayoutManager.this.mStickyHeaderPosition)) {
                    StickyHeadersLinearLayoutManager.this.scrapStickyHeader(null);
                }
                for (i = StickyHeadersLinearLayoutManager.this.findHeaderIndexOrNext(positionStart + itemCount); i != -1 && i < headerCount; ++i) {
                    StickyHeadersLinearLayoutManager.this.mHeaderPositions.set(i, (Integer)StickyHeadersLinearLayoutManager.this.mHeaderPositions.get(i) - itemCount);
                }
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            block8: {
                int headerCount = StickyHeadersLinearLayoutManager.this.mHeaderPositions.size();
                if (headerCount <= 0) break block8;
                if (fromPosition < toPosition) {
                    for (int i = StickyHeadersLinearLayoutManager.this.findHeaderIndexOrNext(fromPosition); i != -1 && i < headerCount; ++i) {
                        int headerPos = (Integer)StickyHeadersLinearLayoutManager.this.mHeaderPositions.get(i);
                        if (headerPos >= fromPosition && headerPos < fromPosition + itemCount) {
                            StickyHeadersLinearLayoutManager.this.mHeaderPositions.set(i, headerPos - (toPosition - fromPosition));
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        if (headerPos >= fromPosition + itemCount && headerPos <= toPosition) {
                            StickyHeadersLinearLayoutManager.this.mHeaderPositions.set(i, headerPos - itemCount);
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = StickyHeadersLinearLayoutManager.this.findHeaderIndexOrNext(toPosition); i != -1 && i < headerCount; ++i) {
                        int headerPos = (Integer)StickyHeadersLinearLayoutManager.this.mHeaderPositions.get(i);
                        if (headerPos >= fromPosition && headerPos < fromPosition + itemCount) {
                            StickyHeadersLinearLayoutManager.this.mHeaderPositions.set(i, headerPos + (toPosition - fromPosition));
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        if (headerPos >= toPosition && headerPos <= fromPosition) {
                            StickyHeadersLinearLayoutManager.this.mHeaderPositions.set(i, headerPos + itemCount);
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        break;
                    }
                }
            }
        }

        private void sortHeaderAtIndex(int index) {
            int headerPos = (Integer)StickyHeadersLinearLayoutManager.this.mHeaderPositions.remove(index);
            int headerIndex = StickyHeadersLinearLayoutManager.this.findHeaderIndexOrNext(headerPos);
            if (headerIndex != -1) {
                StickyHeadersLinearLayoutManager.this.mHeaderPositions.add(headerIndex, headerPos);
            } else {
                StickyHeadersLinearLayoutManager.this.mHeaderPositions.add(headerPos);
            }
        }
    }
}

