/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.view.View;

/**
 * Base ViewHolder class for {@link StartViewHolder}, {@link MiddleViewHolder} and {@link EndViewHolder}.
 * Used to display agent, consumer and system messages.
 * <p>
 * Created by yanda on 01/07/2019.
 */
public abstract class BaseMessageViewHolder extends BaseViewHolder {

    protected String mTimestampAccessibilityString;

    BaseMessageViewHolder(View itemView) {
        super(itemView);
    }

    public abstract void applyColors();

    @Override
    public void onUpdateTimestampText() {
        String timestampText = getTimeFormat(mTimeStamp);
        if (mTimestampTextView != null) {
            mTimestampTextView.setText(timestampText);
        }
        mTimestampAccessibilityString = isTimestampEnabled() ? timestampText : "";
    }
}
