/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.LinearLayout;

public class RoundedCornersLayout
extends LinearLayout {
    private float mDensity;
    private Paint mPaint;
    private Path mPathCorners;
    private Path mPathCornersBorder;
    private RectF rect;
    private RectF rectBorder;
    private float mBottomLeftRadiusPx;
    private float mTopLeftRadiusPx;
    private float mTopRightRadiusPx;
    private float mBottomRightRadiusPx;
    private boolean mDrawBottomBorder;
    private boolean mDrawLeftBorder;
    private boolean mDrawTopBorder;
    private boolean mDrawRightBorder;
    private float mBorderWidth;
    private float mBorderHalf;
    private boolean mShowBorder;
    private int mBorderColor;
    private float mMaxRadiusPx;
    private int save;

    public RoundedCornersLayout(Context context) {
        this(context, null);
    }

    public RoundedCornersLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedCornersLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mDensity = Resources.getSystem().getDisplayMetrics().density;
        this.mPaint = new Paint();
        this.mPathCorners = new Path();
        this.mPathCornersBorder = new Path();
        this.rect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.rectBorder = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mShowBorder = false;
        this.mBorderColor = Color.parseColor((String)"#000000");
        this.mMaxRadiusPx = 50.0f;
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mBorderColor);
    }

    public void setBorderWidth(float width) {
        this.mBorderWidth = width;
        this.mShowBorder = this.mBorderWidth > 0.0f;
        this.mBorderHalf = this.mBorderWidth / 2.0f;
        this.mPaint.setStrokeWidth(this.mBorderWidth);
        this.updateRectangleBorder();
        this.invalidate();
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
        this.mPaint.setColor(color2);
        this.invalidate();
    }

    public void setCornersRadius(float bottomLeftRadiusDp, float topLeftRadiusDp, float topRightRadiusDp, float bottomRightRadiusDp) {
        float scale = this.mDensity / 2.2f;
        this.mBottomLeftRadiusPx = (float)this.dpToPx(bottomLeftRadiusDp) / scale;
        this.mTopLeftRadiusPx = (float)this.dpToPx(topLeftRadiusDp) / scale;
        this.mTopRightRadiusPx = (float)this.dpToPx(topRightRadiusDp) / scale;
        this.mBottomRightRadiusPx = (float)this.dpToPx(bottomRightRadiusDp) / scale;
        this.mMaxRadiusPx = this.findMax(this.mTopLeftRadiusPx, this.mTopRightRadiusPx, this.mBottomLeftRadiusPx, this.mBottomRightRadiusPx);
    }

    private int dpToPx(float dp) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)displayMetrics);
        return Math.round(px);
    }

    public void setBorders(boolean bottomBorder, boolean leftBorder, boolean topBorder, boolean rightBorder) {
        this.mDrawBottomBorder = bottomBorder;
        this.mDrawLeftBorder = leftBorder;
        this.mDrawTopBorder = topBorder;
        this.mDrawRightBorder = rightBorder;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.rect.bottom = this.mDrawBottomBorder ? (float)h - this.mBorderHalf : (float)h + this.mMaxRadiusPx;
        this.rect.left = this.mDrawLeftBorder ? 0.0f + this.mBorderHalf : -this.mMaxRadiusPx;
        this.rect.top = this.mDrawTopBorder ? 0.0f + this.mBorderHalf : -this.mMaxRadiusPx;
        this.rect.right = this.mDrawRightBorder ? (float)w - this.mBorderHalf : (float)w + this.mMaxRadiusPx;
        this.mPathCorners.reset();
        this.mPathCorners = this.roundedRect(this.rect, this.mTopLeftRadiusPx, this.mTopRightRadiusPx, this.mBottomRightRadiusPx, this.mBottomLeftRadiusPx);
        this.mPathCorners.close();
        this.updateRectangleBorder();
    }

    private void updateRectangleBorder() {
        this.rectBorder.bottom = this.mDrawBottomBorder ? this.rect.bottom : this.rect.bottom + this.mMaxRadiusPx;
        this.rectBorder.left = this.mDrawLeftBorder ? this.rect.left : this.rect.left - this.mMaxRadiusPx;
        this.rectBorder.top = this.mDrawTopBorder ? this.rect.top : this.rect.top - this.mMaxRadiusPx;
        this.rectBorder.right = this.mDrawRightBorder ? this.rect.right : this.rect.right + this.mMaxRadiusPx;
        this.mPathCornersBorder.reset();
        this.mPathCornersBorder = this.roundedRect(this.rectBorder, this.mTopLeftRadiusPx, this.mTopRightRadiusPx, this.mBottomRightRadiusPx, this.mBottomLeftRadiusPx);
        this.mPathCornersBorder.close();
    }

    protected void dispatchDraw(Canvas canvas) {
        this.save = canvas.save();
        canvas.clipPath(this.mPathCorners);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(this.save);
        if (this.mShowBorder) {
            canvas.drawPath(this.mPathCornersBorder, this.mPaint);
        }
    }

    private Path roundedRect(RectF rect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
        Path path = new Path();
        path.moveTo(rect.left + topLeftDiameter / 2.0f, rect.top);
        path.lineTo(rect.right - topRightDiameter / 2.0f, rect.top);
        path.quadTo(rect.right, rect.top, rect.right, rect.top + topRightDiameter / 2.0f);
        path.lineTo(rect.right, rect.bottom - bottomRightDiameter / 2.0f);
        path.quadTo(rect.right, rect.bottom, rect.right - bottomRightDiameter / 2.0f, rect.bottom);
        path.lineTo(rect.left + bottomLeftDiameter / 2.0f, rect.bottom);
        path.quadTo(rect.left, rect.bottom, rect.left, rect.bottom - bottomLeftDiameter / 2.0f);
        path.lineTo(rect.left, rect.top + topLeftDiameter / 2.0f);
        path.quadTo(rect.left, rect.top, rect.left + topLeftDiameter / 2.0f, rect.top);
        path.close();
        return path;
    }

    private float findMax(float a, float b, float c, float d) {
        float max = this.mMaxRadiusPx;
        if (a > max) {
            max = a;
        }
        if (b > max) {
            max = b;
        }
        if (c > max) {
            max = c;
        }
        if (d > max) {
            max = d;
        }
        return max;
    }
}

