package com.liveperson.infra.ui.view.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import androidx.annotation.DrawableRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.TextView;

import com.liveperson.infra.log.LPLog;

/**
 * Created by ofira on 04/08/2015.
 */
public class UIUtils {

	public static final String TAG = UIUtils.class.getSimpleName();
	private static final String[] HTML_TAGS = {"<b>", "</b>", "<i>", "</i>"};

	/**
	 *
	 * @param view
	 * @param context
	 * @param attrs
	 * @param customViewResId
	 * @param customViewFontAttributeResId
	 */
	public static void changeCustomTextViewFont(TextView view, Context context, AttributeSet attrs, int[] customViewResId, int customViewFontAttributeResId) {

		String fontName;

		TypedArray array = context.getTheme().obtainStyledAttributes(
				attrs,
				customViewResId,
				0, 0);

		try {
			fontName = array.getString(customViewFontAttributeResId);
		} finally {
			array.recycle();
		}


		if (!view.isInEditMode() && (!TextUtils.isEmpty(fontName))) {
			Typeface typeFace;

			try{
				if(fontName.toLowerCase().contains(".")) {
					typeFace = Typeface.createFromAsset(context.getAssets(), fontName);
				}
				else {
					typeFace = Typeface.create(fontName, view.getTypeface().getStyle());
				}

				view.setTypeface(typeFace, view.getTypeface().getStyle());

			} catch (Exception e) {
				LPLog.INSTANCE.w(TAG, "applyCustomFont: Error setting custom font: " + fontName, e);
			}

		}
	}

	public static void startProgressBarAnimation(ImageView view, @DrawableRes int progressBarDrawable) {
		Animation a = new RotateAnimation(0, 360,
				Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF,0.5f);
		a.setInterpolator(new LinearInterpolator());
		a.setFillEnabled(true);
		a.setFillAfter(true);
		a.setDuration(1000);
		a.setRepeatCount(Animation.INFINITE);
		view.setImageResource(progressBarDrawable);
		view.startAnimation(a);
	}

	/**
	 * Checks if given String consists of only emojis. if so return true.
	 * if any of the characters arent an emoji returns false.
	 *
	 * Notice: must add to Regex any New emoji unicode added.
	 * updated 09/04/2018
	 */
	private static boolean isEmoji(String message){
        return message.matches("(?:[\uD83C\uDF00-\uD83D\uDDFF]|[\uD83E\uDD00-\uD83E\uDDFF]|" +
                "[\uD83D\uDE00-\uD83D\uDE4F]|[\uD83D\uDE80-\uD83D\uDEFF]|" +
                "[\u2600-\u26FF]\uFE0F?|[\u2700-\u27BF]\uFE0F?|\u24C2\uFE0F?|" +
                "[\uD83C\uDDE6-\uD83C\uDDFF]{1,2}|" +
                "[\uD83C\uDD70\uD83C\uDD71\uD83C\uDD7E\uD83C\uDD7F\uD83C\uDD8E\uD83C\uDD91-\uD83C\uDD9A]\uFE0F?|" +
                "[\u0023\u002A\u0030-\u0039]\uFE0F?\u20E3|[\u2194-\u2199\u21A9-\u21AA]\uFE0F?|[\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55]\uFE0F?|" +
                "[\u2934\u2935]\uFE0F?|[\u3030\u303D]\uFE0F?|[\u3297\u3299]\uFE0F?|" +
                "[\uD83C\uDE01\uD83C\uDE02\uD83C\uDE1A\uD83C\uDE2F\uD83C\uDE32-\uD83C\uDE3A\uD83C\uDE50\uD83C\uDE51]\uFE0F?|" +
                "[\u203C\u2049]\uFE0F?|[\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE]\uFE0F?|" +
                "[\u00A9\u00AE]\uFE0F?|[\u2122\u2139]\uFE0F?|\uD83C\uDC04\uFE0F?|\uD83C\uDCCF\uFE0F?|" +
                "[\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA]\uFE0F?)+");
	}

	/**
	 * checks if given string is only emojis if so returns number of emojis that consists it.
	 * @param message
	 * @return number of emojis (1\2)
	 */
	public static int detectEmojis(String message){
		int len = message.length(), NumEmoji = 0;
		// if the the given String is only emojis. && if it's length is smaller than 5 - if the string is 3 emojis we want it to be normal size.
		if(isEmoji(message) && len < 5){
            for (int i = 0; i < len; i++) {
            	// if the charAt(i) is an emoji by it self -> ++NumEmoji
				if (isEmoji(message.charAt(i)+"")) {
					NumEmoji++;
				} else {
					// maybe the emoji is of size 2 - so lets check.
                	if (i < (len - 1)) { // some Emojis are two characters long in java, e.g. a rocket emoji is "\uD83D\uDE80";
                    	if (Character.isSurrogatePair(message.charAt(i), message.charAt(i + 1))) {
                        	i += 1; //also skip the second character of the emoji
							NumEmoji++;
                    	}
                	}
				}
            }
		    return NumEmoji;
		}
		return 0;
	}

	/**
	 * @param message The message.
	 * @return if the message contains bold or italic HTML tags
	 */
	public static boolean containsHtmlTag(String message) {
		for (String tag : HTML_TAGS) {
			if (message.contains(tag)) {
				return true;
			}
		}
		return false;
	}
}
