/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.Patterns;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import androidx.core.text.util.LinkifyCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.utils.ArithmeticUtilsKt;
import com.liveperson.infra.ui.view.utils.UIUtils;
import com.liveperson.infra.ui.view.utils.linkify.DefaultTransformFilter;
import com.liveperson.infra.ui.view.utils.linkify.PhoneMatchFilter;
import com.liveperson.infra.ui.view.utils.linkify.UrlMatchFilter;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.patterns.PatternsCompat;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public abstract class BaseViewHolder
extends RecyclerView.ViewHolder
implements Runnable {
    private static final long UPDATE_PERIOD = TimeUnit.MINUTES.toMillis(21L);
    private static final long UPDATE_DELAY = TimeUnit.SECONDS.toMillis(15L);
    private static final String TAG = "BaseViewHolder";
    protected TextView mMessageTextView;
    protected TextView mTimestampTextView;
    protected long mTimeStamp;
    private LinkType linkType;
    private OnRequestTimestampUpdateListener listener;
    private static Linkify.TransformFilter mFilter = new DefaultTransformFilter();
    private static Linkify.MatchFilter mUrlMatchFilter = new UrlMatchFilter();
    private static Linkify.MatchFilter mPhoneMatchFilter = new PhoneMatchFilter();

    public BaseViewHolder(View itemView) {
        super(itemView);
        this.mMessageTextView = (TextView)itemView.findViewById(R.id.lpui_message_text);
        this.mTimestampTextView = (TextView)itemView.findViewById(R.id.lpui_message_timestamp);
        this.setupTimestamp();
    }

    protected Context getContext() {
        return this.itemView.getContext();
    }

    public abstract void updateContentDescription();

    public abstract void onUpdateTimestampText();

    public void setMessageTextView(String message) {
        if (UIUtils.containsHtmlTag(message)) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mMessageTextView.setText((CharSequence)Html.fromHtml((String)message, (int)0));
            } else {
                this.mMessageTextView.setText((CharSequence)Html.fromHtml((String)message));
            }
        } else {
            this.mMessageTextView.setText((CharSequence)message);
        }
    }

    public String getTextToCopy() {
        return this.mMessageTextView.getText().toString();
    }

    public void setContentDescription(String message) {
        this.itemView.setContentDescription((CharSequence)message);
        this.itemView.setAccessibilityDelegate(new View.AccessibilityDelegate(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setAccessibilityFocused(false);
            }
        });
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.itemView.setLongClickable(true);
        this.itemView.setOnLongClickListener(onLongClickListener);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.itemView.setClickable(true);
        this.itemView.setOnClickListener(onClickListener);
    }

    protected void setMessageTextOnClickListener(View.OnClickListener onClickListener) {
        this.mMessageTextView.setOnClickListener(onClickListener);
    }

    protected void setMessageTextOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mMessageTextView.setOnLongClickListener(onLongClickListener);
    }

    public void setContextualBehaviorOnClick(View.OnClickListener onClickListener) {
        this.itemView.setClickable(true);
        onClickListener.onClick(this.itemView);
    }

    public boolean setContextualBehaviorOnLongClick(View.OnLongClickListener onClickListener) {
        this.itemView.setLongClickable(true);
        return onClickListener.onLongClick(this.itemView);
    }

    public final void setTimestamp(long timestamp) {
        this.mTimeStamp = timestamp;
        this.onUpdateTimestampText();
    }

    protected void setupTimestamp() {
        if (this.mTimestampTextView != null) {
            if (this.isTimestampEnabled()) {
                this.mTimestampTextView.setVisibility(0);
                this.mTimestampTextView.setTextSize(Configuration.getDimension((int)R.dimen.lp_timestamps_font_size, (int)2));
            } else {
                this.mTimestampTextView.setVisibility(8);
            }
        }
    }

    @SuppressLint(value={"StringFormatMatches"})
    protected String getTimeFormat(long timestamp) {
        boolean isNumericTimestampOnly = Configuration.getBoolean((int)R.bool.message_status_numeric_timestamp_only);
        if (!isNumericTimestampOnly) {
            long timeDiff = System.currentTimeMillis() - timestamp;
            if (timeDiff < 60000L) {
                return this.itemView.getContext().getString(R.string.lp_message_time_now);
            }
            if (timeDiff < 1200000L) {
                long minutes = timeDiff / 60000L;
                return String.format(this.itemView.getContext().getString(R.string.lp_message_time_min_ago), minutes);
            }
        }
        String customTimeFormat = this.itemView.getContext().getString(R.string.lp_time_format);
        return DateUtils.getFormattedTime((String)customTimeFormat, (int)3, (long)timestamp);
    }

    protected boolean linkifyText(TextView textView) {
        Pattern customLinkPattern;
        boolean linkified = false;
        String customPhoneRegex = textView.getContext().getString(R.string.lp_bubble_phone_links_regex);
        String customUrlRegex = textView.getContext().getString(R.string.lp_bubble_url_links_regex);
        String customEmailRegex = textView.getContext().getString(R.string.lp_bubble_email_links_regex);
        if (!TextUtils.isEmpty((CharSequence)customPhoneRegex)) {
            customLinkPattern = Pattern.compile(customPhoneRegex);
            if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)customLinkPattern, (String)"tel:", null, (Linkify.TransformFilter)mFilter)) {
                linkified = true;
                this.linkType = LinkType.PHONE;
            }
        } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)Patterns.PHONE, (String)"tel:", (Linkify.MatchFilter)mPhoneMatchFilter, (Linkify.TransformFilter)mFilter)) {
            linkified = true;
            this.linkType = LinkType.PHONE;
        }
        if (!TextUtils.isEmpty((CharSequence)customUrlRegex)) {
            customLinkPattern = Pattern.compile(customUrlRegex);
            if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)customLinkPattern, null, (Linkify.MatchFilter)mUrlMatchFilter, (Linkify.TransformFilter)mFilter)) {
                linkified = true;
                this.linkType = LinkType.URL;
            }
        } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)PatternsCompat.AUTOLINK_WEB_URL, (String)"http://", (String[])new String[]{"https://"}, (Linkify.MatchFilter)mUrlMatchFilter, (Linkify.TransformFilter)mFilter)) {
            linkified = true;
            this.linkType = LinkType.URL;
        }
        if (!TextUtils.isEmpty((CharSequence)customEmailRegex)) {
            customLinkPattern = Pattern.compile(customEmailRegex);
            if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)customLinkPattern, (String)"mailto:", null, (Linkify.TransformFilter)mFilter)) {
                linkified = true;
                this.linkType = LinkType.EMAIL;
            }
        } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (Pattern)Patterns.EMAIL_ADDRESS, (String)"mailto:", null, (Linkify.TransformFilter)mFilter)) {
            linkified = true;
            this.linkType = LinkType.EMAIL;
        }
        if (!linkified) {
            if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (int)1)) {
                linkified = true;
                this.linkType = LinkType.URL;
            } else if (LinkifyCompat.addLinks((Spannable)((Spannable)textView.getText()), (int)2)) {
                linkified = true;
                this.linkType = LinkType.EMAIL;
            }
        }
        return linkified;
    }

    public void applyChanges(Bundle changes, Message message) {
        String newText = changes.getString("EXTRA_MESSAGE_TEXT", null);
        if (!TextUtils.isEmpty((CharSequence)newText)) {
            this.setMessageTextView(newText);
            this.updateContentDescription();
        }
    }

    protected boolean isTimestampEnabled() {
        return Configuration.getBoolean((int)R.bool.lp_enable_timestamps);
    }

    protected boolean isReadReceiptDisabled() {
        return !Configuration.getBoolean((int)R.bool.lp_enable_read_receipts);
    }

    protected boolean shouldUpdateTimestamps() {
        boolean isNumericTimestamp = Configuration.getBoolean((int)R.bool.message_status_numeric_timestamp_only);
        return this.isTimestampEnabled() && !isNumericTimestamp && Math.abs(System.currentTimeMillis() - this.mTimeStamp) < UPDATE_PERIOD;
    }

    public void setRequestTimestampListener(OnRequestTimestampUpdateListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        if (this.listener == null) {
            return;
        }
        this.listener.requestTimestampsUpdate(this.getAdapterPosition());
        if (this.shouldUpdateTimestamps()) {
            this.updateTimestamp(this.getUpdateDelay(), this);
        }
    }

    public void onBind() {
    }

    public void observeTimestampChanges() {
        this.cancelUpdates(this);
        if (this.shouldUpdateTimestamps()) {
            this.updateTimestamp(0L, this);
        }
    }

    public void stopObservingTimestampsChanges() {
        this.cancelUpdates(this);
        this.listener = null;
    }

    public void recycle() {
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public Long getUpdateDelay() {
        return UPDATE_DELAY;
    }

    protected void removeUrlSpans() {
        Spannable spannableString;
        URLSpan[] urlSpans;
        CharSequence text = this.mMessageTextView.getText();
        if (text instanceof Spannable && (urlSpans = (URLSpan[])(spannableString = (Spannable)text).getSpans(0, spannableString.length(), URLSpan.class)) != null) {
            for (URLSpan span : urlSpans) {
                spannableString.removeSpan((Object)span);
            }
        }
    }

    protected void clearSelection() {
        CharSequence text = this.mMessageTextView.getText();
        if (text instanceof Spannable) {
            Selection.removeSelection((Spannable)((Spannable)text));
        }
    }

    protected int getTimestampAsInteger() {
        return ArithmeticUtilsKt.asIntegerValue(this.mTimeStamp);
    }

    private void updateTimestamp(long delay, Runnable runnable) {
        if (this.listener != null) {
            this.listener.onUpdateTimestampWithDelay(delay, runnable);
        }
    }

    private void cancelUpdates(Runnable runnable) {
        if (this.listener != null) {
            this.listener.cancelTimestampsUpdate(runnable);
        }
    }

    public static interface OnRequestTimestampUpdateListener {
        public void requestTimestampsUpdate(int var1);

        public void onUpdateTimestampWithDelay(long var1, Runnable var3);

        public void cancelTimestampsUpdate(Runnable var1);
    }

    public static enum LinkType {
        URL,
        PHONE,
        EMAIL,
        NAVIGATION;

    }
}

