package com.liveperson.infra.ui.view.utils.linkify

import android.text.util.Linkify
import com.liveperson.infra.utils.urlHasCorrectCharAtIndex

/**
 * Implementation of [Linkify.MatchFilter] used to filter web urls
 * matches that occur after an at-sign (@). This is used to prevent
 * turning the domain name in an email address into a web link.
 *
 * @see urlHasCorrectCharAtIndex
 */
class UrlMatchFilter: Linkify.MatchFilter {

    override fun acceptMatch(s: CharSequence, start: Int, end: Int): Boolean {
        return s.urlHasCorrectCharAtIndex(start - 1) && s.urlHasCorrectCharAtIndex(end)
    }
}