/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.ui.progress;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.ui.progress.ProgressDrawable;
import com.liveperson.infra.ui.view.ui.progress.ProgressDrawableUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0001/B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0007H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0014J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J$\u0010&\u001a\u00020\u0016*\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J;\u0010)\u001a\u00020\u0016*\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00160+H\u0082\bJ\u0014\u0010-\u001a\u00020\u000b*\u00020\u00032\u0006\u0010.\u001a\u00020\u000bH\u0002R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/liveperson/infra/ui/view/ui/progress/LPProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "value", "", "progress", "setProgress", "(F)V", "progressAnimator", "Landroid/animation/ValueAnimator;", "progressDrawable", "Lcom/liveperson/infra/ui/view/ui/progress/ProgressDrawable;", "progressTrackWeight", "getSuggestedMinimumHeight", "onAttachedToWindow", "", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setVisibility", "visibility", "startAnimation", "stopAnimation", "verifyDrawable", "", "who", "Landroid/graphics/drawable/Drawable;", "changeProgressBounds", "width", "height", "readFromAttributes", "block", "Lkotlin/Function1;", "Landroid/content/res/TypedArray;", "toPx", "dp", "Companion", "ui_release"})
public final class LPProgressBar
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float progressTrackWeight;
    @NotNull
    private final ProgressDrawable progressDrawable;
    @NotNull
    private final ValueAnimator progressAnimator;
    private float progress;
    private static final float DEFAULT_PROGRESS_TRACK = 0.5f;
    private static final float DEFAULT_MINIMUM_HEIGHT_IN_DP = 4.0f;
    private static final int DEFAULT_DURATION = 1250;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public LPProgressBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray typedArray;
        void $this$progressAnimator_u24lambda_u2d1;
        Object $this$progressAnimator_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.progressTrackWeight = 0.5f;
        this.progressDrawable = new ProgressDrawable();
        Object object = new float[]{0.0f, 1.0f};
        Object object2 = object = (Object)ValueAnimator.ofFloat((float[])object);
        LPProgressBar lPProgressBar = this;
        boolean bl = false;
        $this$progressAnimator_u24lambda_u2d0.setRepeatCount(-1);
        $this$progressAnimator_u24lambda_u2d0 = object;
        boolean bl2 = false;
        $this$progressAnimator_u24lambda_u2d1.setRepeatMode(1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofFloat(0f, 1f)\n        \u2026= ValueAnimator.RESTART }");
        lPProgressBar.progressAnimator = (ValueAnimator)object;
        LPProgressBar lPProgressBar2 = this;
        Context $this$readFromAttributes$iv = context;
        boolean $i$f$readFromAttributes = false;
        TypedArray typedArray2 = $this$readFromAttributes$iv.obtainStyledAttributes(attrs, R.styleable.LPProgressBar, defStyleAttr, defStyleRes);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"obtainStyledAttributes(a\u2026efStyleAttr, defStyleRes)");
        TypedArray it = typedArray = typedArray2;
        boolean bl3 = false;
        ProgressDrawableUtilsKt.setColor(this.progressDrawable, it.getColor(R.styleable.LPProgressBar_progress_color, -16776961));
        this.progressDrawable.setCornerRadius(it.getDimension(R.styleable.LPProgressBar_progress_corner_radius, 0.0f));
        this.progressTrackWeight = it.getFloat(R.styleable.LPProgressBar_progress_weight, 0.5f);
        int animationDuration = it.getInt(R.styleable.LPProgressBar_progress_animation_duration, 1250);
        this.progressAnimator.setDuration((long)animationDuration);
        typedArray.recycle();
    }

    public /* synthetic */ LPProgressBar(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    private final void setProgress(float value) {
        this.progress = value;
        this.changeProgressBounds(this.progressDrawable, value, this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.progressDrawable.setCallback((Drawable.Callback)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (widthMode) {
            case 0x40000000: {
                n2 = widthSize;
                break;
            }
            case -2147483648: {
                n2 = RangesKt.coerceAtMost((int)this.getSuggestedMinimumWidth(), (int)widthSize);
                break;
            }
            default: {
                n2 = this.getSuggestedMinimumWidth();
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                n = RangesKt.coerceAtMost((int)this.getSuggestedMinimumHeight(), (int)heightSize);
                break;
            }
            default: {
                n = this.getSuggestedMinimumHeight();
            }
        }
        int height = n;
        this.setMeasuredDimension(width, height);
        this.changeProgressBounds(this.progressDrawable, this.progress, width, height);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.progressDrawable.draw(canvas);
    }

    protected void onDetachedFromWindow() {
        this.progressDrawable.setCallback(null);
        this.stopAnimation();
        super.onDetachedFromWindow();
    }

    protected boolean verifyDrawable(@NotNull Drawable who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        return super.verifyDrawable(who) || Intrinsics.areEqual((Object)who, (Object)((Object)this.progressDrawable));
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    private final void readFromAttributes(Context $this$readFromAttributes, AttributeSet attrs, int defStyleAttr, int defStyleRes, Function1<? super TypedArray, Unit> block) {
        boolean $i$f$readFromAttributes = false;
        TypedArray typedArray = $this$readFromAttributes.obtainStyledAttributes(attrs, R.styleable.LPProgressBar, defStyleAttr, defStyleRes);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(a\u2026efStyleAttr, defStyleRes)");
        TypedArray typedArray2 = typedArray;
        block.invoke((Object)typedArray2);
        typedArray2.recycle();
    }

    private final float toPx(Context $this$toPx, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)$this$toPx.getResources().getDisplayMetrics());
    }

    private final void startAnimation() {
        block1: {
            ValueAnimator valueAnimator;
            ValueAnimator valueAnimator2;
            ValueAnimator valueAnimator3;
            ValueAnimator valueAnimator4;
            ValueAnimator it = valueAnimator4 = this.progressAnimator;
            boolean bl = false;
            Object object = valueAnimator3 = !(it.isStarted() || it.isRunning()) ? valueAnimator4 : null;
            if (valueAnimator3 == null) break block1;
            ValueAnimator it2 = valueAnimator2 = valueAnimator3;
            boolean bl2 = false;
            if (Build.VERSION.SDK_INT >= 22) {
                it2.setCurrentFraction(this.progress);
            }
            ValueAnimator $this$startAnimation_u24lambda_u2d6 = valueAnimator = valueAnimator2;
            boolean bl3 = false;
            $this$startAnimation_u24lambda_u2d6.addUpdateListener(arg_0 -> LPProgressBar.startAnimation$lambda-6$lambda-5(this, arg_0));
            valueAnimator.start();
        }
    }

    protected int getSuggestedMinimumHeight() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return (int)this.toPx(context, 4.0f);
    }

    private final void stopAnimation() {
        ValueAnimator valueAnimator;
        ValueAnimator valueAnimator2;
        ValueAnimator $this$stopAnimation_u24lambda_u2d7 = valueAnimator2 = this.progressAnimator;
        boolean bl = false;
        $this$stopAnimation_u24lambda_u2d7.removeAllUpdateListeners();
        ValueAnimator it = valueAnimator2;
        boolean bl2 = false;
        Object object = valueAnimator = it.isStarted() || it.isRunning() ? valueAnimator2 : null;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
    }

    private final void changeProgressBounds(ProgressDrawable $this$changeProgressBounds, float progress, int width, int height) {
        float progressWidth = (float)width * this.progressTrackWeight;
        float offsetX = progress * ((float)width + progressWidth) - progressWidth;
        $this$changeProgressBounds.setBounds((int)offsetX, 0, (int)(progressWidth + offsetX), height);
    }

    @JvmOverloads
    public LPProgressBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public LPProgressBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public LPProgressBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }

    private static final void startAnimation$lambda-6$lambda-5(LPProgressBar this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnimatedValue();
        Float f = object instanceof Float ? (Float)object : null;
        this$0.setProgress(f != null ? f.floatValue() : 0.0f);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/liveperson/infra/ui/view/ui/progress/LPProgressBar$Companion;", "", "()V", "DEFAULT_DURATION", "", "DEFAULT_MINIMUM_HEIGHT_IN_DP", "", "DEFAULT_PROGRESS_TRACK", "ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

