package com.liveperson.infra.ui.view.ui.progress

import android.graphics.Canvas
import android.graphics.ColorFilter
import android.graphics.Paint
import android.graphics.PixelFormat
import android.graphics.Rect
import android.graphics.RectF
import android.graphics.drawable.Drawable
import android.util.Log

internal class ProgressDrawable: Drawable() {

    private val progressBounds = RectF()

    internal var progressPaint: Paint = Paint(Paint.ANTI_ALIAS_FLAG)
        set(value) {
            field = value
            invalidateSelf()
        }

    var cornerRadius: Float = 0f
        set(value) {
            field = value
            invalidateSelf()
        }

    override fun onBoundsChange(bounds: Rect) {
        this.progressBounds.set(bounds)
        this.invalidateSelf()
    }

    override fun draw(canvas: Canvas) {
        canvas.drawRoundRect(progressBounds, cornerRadius, cornerRadius, progressPaint)
    }

    override fun setAlpha(alpha: Int) {
        this.progressPaint.alpha = alpha
    }

    override fun setColorFilter(colorFilter: ColorFilter?) {
        this.progressPaint.colorFilter = colorFilter
    }

    @Deprecated(message = "This method is no longer used in graphics optimizations")
    override fun getOpacity(): Int = PixelFormat.OPAQUE
}