/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.utils.text;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.util.Linkify;
import android.util.Patterns;
import androidx.core.text.util.LinkifyCompat;
import com.liveperson.infra.html.HtmlUtils;
import com.liveperson.infra.md.MarkdownUtils;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.utils.text.linkify.DefaultTransformFilter;
import com.liveperson.infra.ui.view.utils.text.linkify.PhoneMatchFilter;
import com.liveperson.infra.ui.view.utils.text.linkify.UrlMatchFilter;
import com.liveperson.infra.utils.patterns.PatternsCompat;
import java.util.Iterator;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a!\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010H\u0082\b\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u001a!\u0010\u001b\u001a\u00020\u000e*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001c0\u0010H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"CHAR_CUSTOM_ENDLINE", "", "DEFAULT_TRANSFORM_FILTER", "Lcom/liveperson/infra/ui/view/utils/text/linkify/DefaultTransformFilter;", "PHONE_MATCH_FILTER", "Lcom/liveperson/infra/ui/view/utils/text/linkify/PhoneMatchFilter;", "SCHEME_EMAIL", "SCHEME_HTTP", "SCHEME_HTTPS", "SCHEME_TELEPHONE", "URL_MATCH_FILTER", "Lcom/liveperson/infra/ui/view/utils/text/linkify/UrlMatchFilter;", "asFormattedMessage", "changeString", "Landroid/text/SpannableString;", "block", "Lkotlin/Function1;", "linkifyEmails", "", "Landroid/content/Context;", "spannableString", "linkifyPhoneNumbers", "linkifyText", "text", "markdownLinkColor", "", "linkifyUrls", "withRestoredSpans", "", "ui_release"})
@JvmName(name="LPTextUtils")
@SourceDebugExtension(value={"SMAP\nLPTextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPTextUtils.kt\ncom/liveperson/infra/ui/view/utils/text/LPTextUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 SpannableString.kt\nandroidx/core/text/SpannableStringKt\n+ 4 SpannedString.kt\nandroidx/core/text/SpannedStringKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n141#1,4:156\n145#1:162\n146#1:170\n141#1,4:171\n145#1:177\n146#1:185\n141#1,4:186\n145#1:192\n146#1:200\n150#1,3:201\n153#1:206\n154#1:214\n1295#2,2:160\n1295#2,2:175\n1295#2,2:190\n1295#2,2:204\n1295#2,2:215\n1295#2,2:224\n34#3:163\n34#3:178\n34#3:193\n34#3:207\n34#3:217\n34#3:226\n31#4,4:164\n31#4,4:179\n31#4,4:194\n31#4,4:208\n31#4,4:218\n31#4,4:227\n13536#5,2:168\n13536#5,2:183\n13536#5,2:198\n13536#5,2:212\n13536#5,2:222\n13536#5,2:231\n*S KotlinDebug\n*F\n+ 1 LPTextUtils.kt\ncom/liveperson/infra/ui/view/utils/text/LPTextUtils\n*L\n49#1:156,4\n49#1:162\n49#1:170\n50#1:171,4\n50#1:177\n50#1:185\n51#1:186,4\n51#1:192\n51#1:200\n52#1:201,3\n52#1:206\n52#1:214\n49#1:160,2\n50#1:175,2\n51#1:190,2\n52#1:204,2\n144#1:215,2\n152#1:224,2\n49#1:163\n50#1:178\n51#1:193\n52#1:207\n145#1:217\n153#1:226\n49#1:164,4\n50#1:179,4\n51#1:194,4\n52#1:208,4\n145#1:218,4\n153#1:227,4\n49#1:168,2\n50#1:183,2\n51#1:198,2\n52#1:212,2\n145#1:222,2\n153#1:231,2\n*E\n"})
public final class LPTextUtils {
    @NotNull
    private static final PhoneMatchFilter PHONE_MATCH_FILTER = new PhoneMatchFilter();
    @NotNull
    private static final UrlMatchFilter URL_MATCH_FILTER = new UrlMatchFilter();
    @NotNull
    private static final DefaultTransformFilter DEFAULT_TRANSFORM_FILTER = new DefaultTransformFilter();
    @NotNull
    private static final String SCHEME_TELEPHONE = "tel:";
    @NotNull
    private static final String SCHEME_EMAIL = "mailto:";
    @NotNull
    private static final String SCHEME_HTTP = "http://";
    @NotNull
    private static final String SCHEME_HTTPS = "https://";
    @NotNull
    private static final String CHAR_CUSTOM_ENDLINE = "\u2307";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SpannableString linkifyText(@NotNull Context $this$linkifyText, @NotNull String text, int markdownLinkColor) {
        void $this$forEach$iv$iv$iv;
        Object object;
        boolean bl;
        Iterator it$iv$iv;
        Iterator element$iv$iv$iv;
        Iterator $this$forEach$iv$iv$iv2;
        boolean bl2;
        SpannableString copyString$iv;
        Intrinsics.checkNotNullParameter((Object)$this$linkifyText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return new SpannableString((CharSequence)text);
        }
        SpannableString $this$withRestoredSpans$iv = HtmlUtils.convertHtmlToStyledString((String)MarkdownUtils.convertMarkdownToHTML((String)StringsKt.replace$default((String)text, (String)"\n", (String)CHAR_CUSTOM_ENDLINE, (boolean)false, (int)4, null), (int)markdownLinkColor));
        boolean $i$f$withRestoredSpans = false;
        Object[] objectArray = $this$withRestoredSpans$iv.getSpans(0, $this$withRestoredSpans$iv.length(), Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(0, length, Object::class.java)");
        Sequence currentSpans$iv = ArraysKt.asSequence((Object[])objectArray);
        SpannableString it = copyString$iv = new SpannableString((CharSequence)$this$withRestoredSpans$iv);
        boolean bl3 = false;
        LPTextUtils.linkifyPhoneNumbers($this$linkifyText, it);
        Sequence $this$forEach$iv$iv = SequencesKt.filterNotNull((Sequence)currentSpans$iv);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it$iv = element$iv$iv = iterator.next();
            bl2 = false;
            copyString$iv.setSpan(it$iv, $this$withRestoredSpans$iv.getSpanStart(it$iv), $this$withRestoredSpans$iv.getSpanEnd(it$iv), 0);
        }
        Spannable $this$clearSpans$iv$iv = (Spannable)$this$withRestoredSpans$iv;
        boolean $i$f$clearSpans = false;
        Object[] $this$getSpans_u24default$iv$iv$iv = (Object[])$this$clearSpans$iv$iv;
        int start$iv$iv$iv = 0;
        int end$iv$iv$iv = $this$getSpans_u24default$iv$iv$iv.length();
        int $i$f$getSpans = 0;
        Object[] objectArray2 = $this$getSpans_u24default$iv$iv$iv.getSpans(start$iv$iv$iv, end$iv$iv$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getSpans(start, end, T::class.java)");
        $this$getSpans_u24default$iv$iv$iv = objectArray2;
        boolean $i$f$forEach2 = false;
        $i$f$getSpans = ((void)$this$forEach$iv$iv$iv2).length;
        for (end$iv$iv$iv = 0; end$iv$iv$iv < $i$f$getSpans; ++end$iv$iv$iv) {
            it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv2[end$iv$iv$iv];
            bl = false;
            $this$clearSpans$iv$iv.removeSpan((Object)it$iv$iv);
        }
        $this$withRestoredSpans$iv = copyString$iv;
        $i$f$withRestoredSpans = false;
        Object[] objectArray3 = $this$withRestoredSpans$iv.getSpans(0, $this$withRestoredSpans$iv.length(), Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"getSpans(0, length, Object::class.java)");
        currentSpans$iv = ArraysKt.asSequence((Object[])objectArray3);
        it = copyString$iv = new SpannableString((CharSequence)$this$withRestoredSpans$iv);
        boolean bl4 = false;
        LPTextUtils.linkifyUrls($this$linkifyText, it);
        $this$forEach$iv$iv = SequencesKt.filterNotNull((Sequence)currentSpans$iv);
        $i$f$forEach = false;
        $this$forEach$iv$iv$iv2 = $this$forEach$iv$iv.iterator();
        while ($this$forEach$iv$iv$iv2.hasNext()) {
            Object element$iv$iv;
            Object it$iv = element$iv$iv = $this$forEach$iv$iv$iv2.next();
            bl2 = false;
            copyString$iv.setSpan(it$iv, $this$withRestoredSpans$iv.getSpanStart(it$iv), $this$withRestoredSpans$iv.getSpanEnd(it$iv), 0);
        }
        $this$clearSpans$iv$iv = (Spannable)$this$withRestoredSpans$iv;
        $i$f$clearSpans = false;
        $this$getSpans_u24default$iv$iv$iv = (Object[])$this$clearSpans$iv$iv;
        start$iv$iv$iv = 0;
        end$iv$iv$iv = $this$getSpans_u24default$iv$iv$iv.length();
        $i$f$getSpans = 0;
        Object[] objectArray4 = $this$getSpans_u24default$iv$iv$iv.getSpans(start$iv$iv$iv, end$iv$iv$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"getSpans(start, end, T::class.java)");
        $this$getSpans_u24default$iv$iv$iv = objectArray4;
        $i$f$forEach = false;
        $i$f$getSpans = ((Iterator)$this$forEach$iv$iv$iv2).length;
        for (end$iv$iv$iv = 0; end$iv$iv$iv < $i$f$getSpans; ++end$iv$iv$iv) {
            it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv2[end$iv$iv$iv];
            bl = false;
            $this$clearSpans$iv$iv.removeSpan((Object)it$iv$iv);
        }
        $this$withRestoredSpans$iv = copyString$iv;
        $i$f$withRestoredSpans = false;
        Object[] objectArray5 = $this$withRestoredSpans$iv.getSpans(0, $this$withRestoredSpans$iv.length(), Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"getSpans(0, length, Object::class.java)");
        currentSpans$iv = ArraysKt.asSequence((Object[])objectArray5);
        it = copyString$iv = new SpannableString((CharSequence)$this$withRestoredSpans$iv);
        boolean bl5 = false;
        LPTextUtils.linkifyEmails($this$linkifyText, it);
        $this$forEach$iv$iv = SequencesKt.filterNotNull((Sequence)currentSpans$iv);
        $i$f$forEach = false;
        $this$forEach$iv$iv$iv2 = $this$forEach$iv$iv.iterator();
        while ($this$forEach$iv$iv$iv2.hasNext()) {
            Object element$iv$iv;
            Object it$iv = element$iv$iv = $this$forEach$iv$iv$iv2.next();
            bl2 = false;
            copyString$iv.setSpan(it$iv, $this$withRestoredSpans$iv.getSpanStart(it$iv), $this$withRestoredSpans$iv.getSpanEnd(it$iv), 0);
        }
        $this$clearSpans$iv$iv = (Spannable)$this$withRestoredSpans$iv;
        $i$f$clearSpans = false;
        $this$getSpans_u24default$iv$iv$iv = (Object[])$this$clearSpans$iv$iv;
        start$iv$iv$iv = 0;
        end$iv$iv$iv = $this$getSpans_u24default$iv$iv$iv.length();
        $i$f$getSpans = 0;
        Object[] objectArray6 = $this$getSpans_u24default$iv$iv$iv.getSpans(start$iv$iv$iv, end$iv$iv$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray6, (String)"getSpans(start, end, T::class.java)");
        $this$getSpans_u24default$iv$iv$iv = objectArray6;
        $i$f$forEach22 = false;
        $i$f$getSpans = ((Iterator)$this$forEach$iv$iv$iv2).length;
        for (end$iv$iv$iv = 0; end$iv$iv$iv < $i$f$getSpans; ++end$iv$iv$iv) {
            it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv2[end$iv$iv$iv];
            bl = false;
            $this$clearSpans$iv$iv.removeSpan((Object)it$iv$iv);
        }
        SpannableString $this$changeString$iv = copyString$iv;
        boolean $i$f$changeString = false;
        Object[] objectArray7 = $this$changeString$iv.getSpans(0, $this$changeString$iv.length(), Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray7, (String)"getSpans(0, length, Object::class.java)");
        currentSpans$iv = ArraysKt.asSequence((Object[])objectArray7);
        String string2 = $this$changeString$iv.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        String it2 = string2;
        boolean bl6 = false;
        String result = StringsKt.replace$default((String)StringsKt.replace$default((String)it2, (String)"\u2307\n", (String)" \n", (boolean)false, (int)4, null), (String)CHAR_CUSTOM_ENDLINE, (String)"\n", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((CharSequence)result, (char)'\n', (boolean)false, (int)2, null)) {
            String string3 = result.substring(0, StringsKt.getLastIndex((CharSequence)result));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string3 + " ";
        } else {
            object = result;
        }
        CharSequence charSequence = (CharSequence)object;
        SpannableString copyString$iv2 = new SpannableString(charSequence);
        Sequence $this$forEach$iv$iv2 = SequencesKt.filterNotNull((Sequence)currentSpans$iv);
        boolean $i$f$forEach3 = false;
        Iterator $i$f$forEach22 = $this$forEach$iv$iv2.iterator();
        while ($i$f$forEach22.hasNext()) {
            Object element$iv$iv;
            Object it$iv = element$iv$iv = $i$f$forEach22.next();
            boolean bl7 = false;
            copyString$iv2.setSpan(it$iv, $this$changeString$iv.getSpanStart(it$iv), $this$changeString$iv.getSpanEnd(it$iv), 0);
        }
        Spannable $this$clearSpans$iv$iv2 = (Spannable)$this$changeString$iv;
        boolean $i$f$clearSpans2 = false;
        Object[] $this$getSpans_u24default$iv$iv$iv2 = (Object[])$this$clearSpans$iv$iv2;
        int start$iv$iv$iv2 = 0;
        int end$iv$iv$iv2 = $this$getSpans_u24default$iv$iv$iv2.length();
        boolean $i$f$getSpans2 = false;
        Object[] objectArray8 = $this$getSpans_u24default$iv$iv$iv2.getSpans(start$iv$iv$iv2, end$iv$iv$iv2, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray8, (String)"getSpans(start, end, T::class.java)");
        $this$getSpans_u24default$iv$iv$iv2 = objectArray8;
        boolean $i$f$forEach4 = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv$iv2;
            void it$iv$iv2 = element$iv$iv$iv2 = $this$forEach$iv$iv$iv[i];
            boolean bl8 = false;
            $this$clearSpans$iv$iv2.removeSpan((Object)it$iv$iv2);
        }
        return copyString$iv2;
    }

    @NotNull
    public static final String asFormattedMessage(@NotNull String $this$asFormattedMessage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asFormattedMessage, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$asFormattedMessage)) {
            return $this$asFormattedMessage;
        }
        String it = HtmlUtils.convertHtmlToStyledString((String)MarkdownUtils.markdownToHtml((String)StringsKt.replace$default((String)$this$asFormattedMessage, (String)"\n", (String)CHAR_CUSTOM_ENDLINE, (boolean)false, (int)4, null))).toString();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String result = StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"\u2307\n", (String)" \n", (boolean)false, (int)4, null), (String)CHAR_CUSTOM_ENDLINE, (String)"\n", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((CharSequence)result, (char)'\n', (boolean)false, (int)2, null)) {
            String string2 = result.substring(0, StringsKt.getLastIndex((CharSequence)result));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string2 + " ";
        } else {
            object = result;
        }
        return object;
    }

    private static final boolean linkifyPhoneNumbers(Context $this$linkifyPhoneNumbers, SpannableString spannableString) {
        String string2 = $this$linkifyPhoneNumbers.getString(R.string.lp_bubble_phone_links_regex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.lp_bubble_phone_links_regex)");
        String customPhoneRegex = string2;
        Pair pair = ((CharSequence)customPhoneRegex).length() == 0 ? TuplesKt.to((Object)Patterns.PHONE, (Object)PHONE_MATCH_FILTER) : TuplesKt.to((Object)Pattern.compile(customPhoneRegex), null);
        Pattern phonePattern = (Pattern)pair.component1();
        PhoneMatchFilter matchFilter = (PhoneMatchFilter)pair.component2();
        return LinkifyCompat.addLinks((Spannable)((Spannable)spannableString), (Pattern)phonePattern, (String)SCHEME_TELEPHONE, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)DEFAULT_TRANSFORM_FILTER);
    }

    private static final boolean linkifyUrls(Context $this$linkifyUrls, SpannableString spannableString) {
        boolean bl;
        String string2 = $this$linkifyUrls.getString(R.string.lp_bubble_url_links_regex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.lp_bubble_url_links_regex)");
        String customUrlRegex = string2;
        if (((CharSequence)customUrlRegex).length() == 0) {
            String[] stringArray = new String[]{SCHEME_HTTPS};
            bl = LinkifyCompat.addLinks((Spannable)((Spannable)spannableString), (Pattern)PatternsCompat.AUTOLINK_WEB_URL, (String)SCHEME_HTTP, (String[])stringArray, (Linkify.MatchFilter)URL_MATCH_FILTER, (Linkify.TransformFilter)DEFAULT_TRANSFORM_FILTER);
        } else {
            bl = LinkifyCompat.addLinks((Spannable)((Spannable)spannableString), (Pattern)Pattern.compile(customUrlRegex), null, (Linkify.MatchFilter)URL_MATCH_FILTER, (Linkify.TransformFilter)DEFAULT_TRANSFORM_FILTER);
        }
        return bl;
    }

    private static final boolean linkifyEmails(Context $this$linkifyEmails, SpannableString spannableString) {
        Pattern pattern;
        String string2 = $this$linkifyEmails.getString(R.string.lp_bubble_email_links_regex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.lp_bubble_email_links_regex)");
        String customEmailRegex = string2;
        if (((CharSequence)customEmailRegex).length() == 0) {
            Pattern pattern2 = Patterns.EMAIL_ADDRESS;
            pattern = pattern2;
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"{\n        Patterns.EMAIL_ADDRESS\n    }");
        } else {
            Pattern pattern3 = Pattern.compile(customEmailRegex);
            pattern = pattern3;
            Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"{\n        Pattern.compile(customEmailRegex)\n    }");
        }
        Pattern emailPattern = pattern;
        return LinkifyCompat.addLinks((Spannable)((Spannable)spannableString), (Pattern)emailPattern, (String)SCHEME_EMAIL, null, (Linkify.TransformFilter)DEFAULT_TRANSFORM_FILTER);
    }

    /*
     * WARNING - void declaration
     */
    private static final SpannableString withRestoredSpans(SpannableString $this$withRestoredSpans, Function1<? super SpannableString, Unit> block) {
        void $this$forEach$iv$iv;
        boolean $i$f$withRestoredSpans = false;
        Object[] objectArray = $this$withRestoredSpans.getSpans(0, $this$withRestoredSpans.length(), Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(0, length, Object::class.java)");
        Sequence currentSpans = ArraysKt.asSequence((Object[])objectArray);
        SpannableString copyString = new SpannableString((CharSequence)$this$withRestoredSpans);
        block.invoke((Object)copyString);
        Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)currentSpans);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            copyString.setSpan(it, $this$withRestoredSpans.getSpanStart(it), $this$withRestoredSpans.getSpanEnd(it), 0);
        }
        Spannable $this$clearSpans$iv = (Spannable)$this$withRestoredSpans;
        boolean $i$f$clearSpans = false;
        Object[] $this$getSpans_u24default$iv$iv = (Object[])$this$clearSpans$iv;
        int start$iv$iv = 0;
        int end$iv$iv = $this$getSpans_u24default$iv$iv.length();
        boolean $i$f$getSpans = false;
        Object[] objectArray2 = $this$getSpans_u24default$iv$iv.getSpans(start$iv$iv, end$iv$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getSpans(start, end, T::class.java)");
        $this$getSpans_u24default$iv$iv = objectArray2;
        boolean $i$f$forEach2 = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it$iv = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            $this$clearSpans$iv.removeSpan((Object)it$iv);
        }
        return copyString;
    }

    /*
     * WARNING - void declaration
     */
    private static final SpannableString changeString(SpannableString $this$changeString, Function1<? super String, String> block) {
        void $this$forEach$iv$iv;
        boolean $i$f$changeString = false;
        Object[] objectArray = $this$changeString.getSpans(0, $this$changeString.length(), Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(0, length, Object::class.java)");
        Sequence currentSpans = ArraysKt.asSequence((Object[])objectArray);
        String string2 = $this$changeString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        SpannableString copyString = new SpannableString((CharSequence)block.invoke((Object)string2));
        Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)currentSpans);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            copyString.setSpan(it, $this$changeString.getSpanStart(it), $this$changeString.getSpanEnd(it), 0);
        }
        Spannable $this$clearSpans$iv = (Spannable)$this$changeString;
        boolean $i$f$clearSpans = false;
        Object[] $this$getSpans_u24default$iv$iv = (Object[])$this$clearSpans$iv;
        int start$iv$iv = 0;
        int end$iv$iv = $this$getSpans_u24default$iv$iv.length();
        boolean $i$f$getSpans = false;
        Object[] objectArray2 = $this$getSpans_u24default$iv$iv.getSpans(start$iv$iv, end$iv$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getSpans(start, end, T::class.java)");
        $this$getSpans_u24default$iv$iv = objectArray2;
        boolean $i$f$forEach2 = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it$iv = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            $this$clearSpans$iv.removeSpan((Object)it$iv);
        }
        return copyString;
    }
}

