package com.liveperson.infra.ui.view.ui;

import android.content.Context;
import android.util.AttributeSet;

import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.utils.UIUtils;

/**
 * Created by nirni on 6/14/17.
 */

public class CustomButton extends androidx.appcompat.widget.AppCompatButton {

	public static final String TAG = CustomButton.class.getSimpleName();

	private String mFontName;

	public CustomButton(Context context) {
		super(context);
	}

	public CustomButton(Context context, AttributeSet attrs) {
		super(context, attrs);

		applyCustomFont(context, attrs);
	}

	public CustomButton(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);

		applyCustomFont(context, attrs);
	}

	private void applyCustomFont(Context context, AttributeSet attrs) {

		UIUtils.changeCustomTextViewFont(this, context, attrs, R.styleable.CustomButton, R.styleable.CustomButton_font_name);

	}

}
