package com.liveperson.infra.ui.view.utils.text.linkify

import android.text.util.Linkify
import com.liveperson.infra.utils.phoneHasCorrectCharAtIndex


/**
 * Implementation of [Linkify.MatchFilter] used to filter phone
 * numbers matches that starts or ends with '+', '#', '*' characters.
 *
 * @see phoneHasCorrectCharAtIndex
 */
class PhoneMatchFilter: Linkify.MatchFilter {

    override fun acceptMatch(s: CharSequence, start: Int, end: Int): Boolean {
        return s.phoneHasCorrectCharAtIndex(start - 1) && s.phoneHasCorrectCharAtIndex(end)
    }
}