/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.uicomponents;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ViewSwitcher;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.controller.DBEncryptionService;
import com.liveperson.infra.html.HtmlUtils;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.uicomponents.ICloseMenuListener;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.infra.ui.view.uicomponents.IConversationProvider;
import com.liveperson.infra.ui.view.uicomponents.IEnterMessageListener;
import com.liveperson.infra.ui.view.uicomponents.IOverflowMenu;
import com.liveperson.infra.ui.view.uicomponents.IUpdateFromBrand;
import com.liveperson.infra.ui.view.utils.ImageUrlUtil;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.LinkPreviewCallback;
import com.liveperson.infra.utils.SourceContent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class BaseEnterMessage
extends LinearLayout
implements IConnectionChangedCustomView,
IUpdateFromBrand {
    private static final String TAG = "BaseEnterMessage";
    private static final String KEY_TYPED_TEXT_ENCRYPT_VERSION = "KEY_TYPED_TEXT_ENCRYPT_VERSION";
    public static final int RECORDING_LAYOUT_ANIMATION_DURATION_MILLIS = 200;
    private ExecutorService executorService;
    private Handler mainHandler;
    protected EditText textInput;
    protected Button mTextSendButton;
    protected ImageButton mImageSendButton;
    private ImageSwitcher mAttachBtn;
    protected ImageButton trashButton;
    protected ViewSwitcher mEnterMessageLayoutSwitcher;
    protected IConversationProvider mBrandIdProvider;
    protected IEnterMessageListener mEnterMessageListener;
    private Animation mAnimationOut;
    private Animation mAnimationIn;
    protected boolean mIsConnected;
    protected boolean mIsUpdated;
    private boolean mPhotoSharingKillSwitchEnabled;
    private boolean mPhotoSharingSiteSettingsEnabled;
    private IOverflowMenu mOverflowMenu;
    private ViewGroup mDropPreview;
    private String mCurrentTitle;
    private String mCurrentDescription;
    private String mCurrentImageURL;
    private String mCurrentUrl;
    private String mSiteName;
    private String mCurrentText;
    private Bitmap mCurrentImage;
    private boolean mIsRealTimePreviewEnabled;
    private boolean mIsSufficientToDisplayLinkPreview;
    protected boolean mIsOfflineMessagingEnabled;
    private InputState mInputState = InputState.NONE;
    protected LinkPreviewCallback callback = new LinkPreviewCallback(){

        private boolean validateSufficientConditionsToDisplayPreview(SourceContent sourceContent) {
            int counter = 0;
            counter = sourceContent.getSiteName().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getDescription().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getTitle().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getImages().isEmpty() ? --counter : ++counter;
            BaseEnterMessage.this.mIsSufficientToDisplayLinkPreview = counter >= 0;
            return BaseEnterMessage.this.mIsSufficientToDisplayLinkPreview;
        }

        public void onPos(SourceContent sourceContent, boolean isNull) {
            if (isNull || sourceContent == null || TextUtils.isEmpty((CharSequence)sourceContent.getFinalUrl())) {
                BaseEnterMessage.this.mDropPreview.setVisibility(8);
                BaseEnterMessage.this.clean();
                BaseEnterMessage.this.mCurrentUrl = "";
            } else {
                if (BaseEnterMessage.this.textInput.getText().toString().trim().isEmpty() || !BaseEnterMessage.this.mCurrentText.equals(BaseEnterMessage.this.textInput.getText().toString().trim()) || !sourceContent.getFinalUrl().equalsIgnoreCase(BaseEnterMessage.this.prepareLink(BaseEnterMessage.this.mCurrentText))) {
                    return;
                }
                if (this.validateSufficientConditionsToDisplayPreview(sourceContent) && BaseEnterMessage.this.mIsRealTimePreviewEnabled) {
                    ImageView imageSet = (ImageView)BaseEnterMessage.this.mDropPreview.findViewById(R.id.image_post_set);
                    TextView titleTextView = (TextView)BaseEnterMessage.this.mDropPreview.findViewById(R.id.title);
                    TextView descriptionTextView = (TextView)BaseEnterMessage.this.mDropPreview.findViewById(R.id.description);
                    ImageButton closeBtn = (ImageButton)BaseEnterMessage.this.mDropPreview.findViewById(R.id.close_btn);
                    imageSet.setImageDrawable(null);
                    BaseEnterMessage.this.mDropPreview.setVisibility(0);
                    closeBtn.setOnClickListener(v -> {
                        this.clean();
                        BaseEnterMessage.this.mDropPreview.setVisibility(8);
                    });
                    sourceContent.setImages(ImageUrlUtil.completeToValidImageUrl(sourceContent.getFinalUrl(), sourceContent.getImages()));
                    BaseEnterMessage.this.executorService.execute(() -> {
                        if (sourceContent.getImages().isEmpty()) {
                            BaseEnterMessage.this.mainHandler.post(() -> {
                                imageSet.setVisibility(8);
                                imageSet.setImageDrawable(null);
                            });
                            return;
                        }
                        BaseEnterMessage.this.mCurrentImage = ImageUtils.createBitmapFromURL((Context)BaseEnterMessage.this.getContext(), (String)sourceContent.getImages(), (int)imageSet.getWidth(), (int)imageSet.getHeight());
                        if (BaseEnterMessage.this.mCurrentImage != null) {
                            BaseEnterMessage.this.mainHandler.post(() -> {
                                imageSet.setImageBitmap(BaseEnterMessage.this.mCurrentImage);
                                imageSet.setVisibility(0);
                            });
                        } else {
                            BaseEnterMessage.this.mainHandler.post(() -> {
                                imageSet.setVisibility(8);
                                imageSet.setImageDrawable(null);
                            });
                        }
                    });
                    SpannableString title = HtmlUtils.convertHtmlToStyledString((String)sourceContent.getTitle());
                    SpannableString description = HtmlUtils.convertHtmlToStyledString((String)sourceContent.getDescription());
                    titleTextView.setText((CharSequence)title);
                    descriptionTextView.setText((CharSequence)description);
                }
                BaseEnterMessage.this.mCurrentTitle = sourceContent.getTitle();
                BaseEnterMessage.this.mCurrentDescription = sourceContent.getDescription();
                BaseEnterMessage.this.mCurrentUrl = sourceContent.getUrl();
                BaseEnterMessage.this.mCurrentImageURL = sourceContent.getImages();
                BaseEnterMessage.this.mSiteName = sourceContent.getSiteName();
            }
        }

        public void clean() {
            LayoutInflater inflater = (LayoutInflater)BaseEnterMessage.this.getContext().getSystemService("layout_inflater");
            View content = inflater.inflate(R.layout.lpinfra_ui_enter_message_preview_content_layout, null);
            ImageView imageSet = (ImageView)content.findViewById(R.id.image_post_set);
            imageSet.setImageDrawable(null);
            imageSet.setVisibility(8);
        }
    };

    public BaseEnterMessage(Context context) {
        super(context);
        this.init(context);
    }

    public BaseEnterMessage(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BaseEnterMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.executorService = Executors.newSingleThreadExecutor();
        this.mainHandler = new Handler(Looper.getMainLooper());
        LayoutInflater.from((Context)context).inflate(R.layout.lpinfra_ui_enter_message_layout, (ViewGroup)this);
        this.initializeViews();
    }

    public void setBrandIdProvider(IConversationProvider provider) {
        this.mBrandIdProvider = provider;
    }

    protected void initializeViews() {
        this.textInput = (EditText)this.findViewById(R.id.lpui_enter_message_text);
        this.mTextSendButton = (Button)this.findViewById(R.id.lpui_enter_message_send);
        this.mImageSendButton = (ImageButton)this.findViewById(R.id.lpui_enter_message_send_button);
        this.mAttachBtn = (ImageSwitcher)this.findViewById(R.id.lpui_attach_file);
        this.trashButton = (ImageButton)this.findViewById(R.id.lpui_voice_trash_button);
        this.mEnterMessageLayoutSwitcher = (ViewSwitcher)this.findViewById(R.id.lpui_enter_view_switcher);
        this.mIsRealTimePreviewEnabled = Configuration.getBoolean((int)R.bool.link_preview_enable_real_time_preview);
        this.mDropPreview = (ViewGroup)this.findViewById(R.id.lpui_drop_preview_view);
        this.setEditTextPreferences();
        this.setSendButtonPreferences();
        this.setAttachButtonPreferences();
    }

    private void setEditTextPreferences() {
        this.textInput.setHint(R.string.lp_enter_message);
        if (Configuration.getBoolean((int)R.bool.enable_ime_options_action_send)) {
            this.textInput.setInputType(278529);
            this.textInput.setImeOptions(4);
            this.textInput.setOnEditorActionListener((v, actionId, event) -> {
                boolean handled = false;
                if (actionId == 4) {
                    this.sendMessage();
                    handled = true;
                }
                return handled;
            });
        } else {
            this.textInput.setInputType(147457);
        }
        this.textInput.setTextSize(2, 14.0f);
        this.textInput.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_enter_msg_text));
        this.textInput.setHintTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_enter_msg_hint));
        this.textInput.setLinksClickable(false);
        this.textInput.cancelLongPress();
        this.textInput.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                BaseEnterMessage.this.onAfterChangedText(s.toString());
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                BaseEnterMessage.this.onBeforeChangedText();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String msgStr;
                boolean isDictation;
                Object tag = BaseEnterMessage.this.textInput.getTag();
                boolean bl = isDictation = tag == "TEXT_SOURCE_SPEECH_RECOGNITION";
                if (BaseEnterMessage.this.isSpeechRecognitionInProgress() && !isDictation) {
                    BaseEnterMessage.this.stopSpeechRecognitionIfNeeded();
                }
                BaseEnterMessage.this.mCurrentText = msgStr = BaseEnterMessage.this.textInput.getText().toString().trim();
                if (!TextUtils.isEmpty((CharSequence)msgStr)) {
                    if (BaseEnterMessage.this.mIsRealTimePreviewEnabled) {
                        BaseEnterMessage.this.generateLinkPreview(msgStr);
                    }
                    if (BaseEnterMessage.this.mInputState != InputState.HAS_TEXT) {
                        BaseEnterMessage.this.mInputState = InputState.HAS_TEXT;
                        BaseEnterMessage.this.onHasText(true);
                        BaseEnterMessage.this.updateSendButtonState();
                    }
                } else {
                    BaseEnterMessage.this.mCurrentUrl = "";
                    BaseEnterMessage.this.clean();
                    if (BaseEnterMessage.this.mInputState == InputState.HAS_TEXT) {
                        BaseEnterMessage.this.mInputState = InputState.NONE;
                        BaseEnterMessage.this.onHasText(false);
                        BaseEnterMessage.this.updateSendButtonState();
                    }
                }
            }
        });
    }

    private void setSendButtonPreferences() {
        if (Configuration.getBoolean((int)R.bool.use_send_image_button)) {
            this.mImageSendButton.setVisibility(0);
            this.mTextSendButton.setVisibility(8);
            this.mImageSendButton.setOnClickListener(v -> this.sendMessage());
        } else {
            this.mImageSendButton.setVisibility(8);
            this.mTextSendButton.setVisibility(0);
            this.mTextSendButton.setOnClickListener(v -> this.sendMessage());
        }
        this.setEnterTextMinWidth();
    }

    private void setEnterTextMinWidth() {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mTextSendButton.setMaxWidth(metrics.widthPixels / 2);
    }

    private void setAttachButtonPreferences() {
        this.mPhotoSharingKillSwitchEnabled = PreferenceManager.getInstance().getBooleanValue("kill_switch_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        this.mPhotoSharingSiteSettingsEnabled = PreferenceManager.getInstance().getBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        if (!(Configuration.getBoolean((int)R.bool.enable_photo_sharing) && this.mPhotoSharingKillSwitchEnabled && this.mPhotoSharingSiteSettingsEnabled)) {
            this.mAttachBtn.setVisibility(8);
        }
        this.mAnimationOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.menu_icon_amination_out);
        this.mAnimationIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.menu_icon_amination_in);
        this.mAttachBtn.setFactory(() -> {
            ImageView imageView = new ImageView(this.getContext());
            imageView.setScaleType(ImageView.ScaleType.CENTER);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            return imageView;
        });
        Drawable attachIcon = AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.lpinfra_ui_ic_attach);
        attachIcon.setColorFilter(this.getResources().getColor(R.color.lp_file_attach_icon_clip_color), PorterDuff.Mode.MULTIPLY);
        this.mAttachBtn.setImageDrawable(attachIcon);
        this.disableAttachButton();
        this.mAttachBtn.setOnClickListener(new View.OnClickListener(){
            private ICloseMenuListener menuListener = new ICloseMenuListener(){

                @Override
                public void onCloseMenu() {
                    Drawable attachIcon = AppCompatResources.getDrawable((Context)BaseEnterMessage.this.getContext(), (int)R.drawable.lpinfra_ui_ic_attach);
                    attachIcon.setColorFilter(BaseEnterMessage.this.getResources().getColor(R.color.lp_file_attach_icon_clip_color), PorterDuff.Mode.MULTIPLY);
                    BaseEnterMessage.this.mAttachBtn.setImageDrawable(attachIcon);
                    BaseEnterMessage.this.mAttachBtn.setContentDescription((CharSequence)BaseEnterMessage.this.getResources().getString(R.string.lp_accessibility_attachment_menu_button_collapsed));
                    BaseEnterMessage.this.requestFocus();
                }
            };

            public void onClick(View v) {
                if (BaseEnterMessage.this.mOverflowMenu != null) {
                    if (BaseEnterMessage.this.mOverflowMenu.isMenuOpen()) {
                        BaseEnterMessage.this.mOverflowMenu.hide();
                    } else {
                        if (BaseEnterMessage.this.mDropPreview != null) {
                            BaseEnterMessage.this.mDropPreview.setVisibility(8);
                        }
                        Drawable closeIcon = AppCompatResources.getDrawable((Context)BaseEnterMessage.this.getContext(), (int)R.drawable.lpinfra_ui_ic_close);
                        closeIcon.setColorFilter(BaseEnterMessage.this.getResources().getColor(R.color.lp_file_close_icon_clip_color), PorterDuff.Mode.MULTIPLY);
                        BaseEnterMessage.this.mAttachBtn.setImageDrawable(closeIcon);
                        BaseEnterMessage.this.mAttachBtn.setContentDescription((CharSequence)BaseEnterMessage.this.getResources().getString(R.string.lp_accessibility_attachment_menu_button_expanded));
                        BaseEnterMessage.this.mOverflowMenu.show();
                        BaseEnterMessage.this.mOverflowMenu.setOnCloseListener(this.menuListener);
                    }
                }
            }
        });
    }

    private void disableAttachButton() {
        this.mAttachBtn.setEnabled(false);
        this.mAttachBtn.setAlpha(0.5f);
    }

    protected abstract void generateLinkPreview(String var1);

    protected abstract String prepareLink(String var1);

    protected void clean() {
        this.mCurrentImageURL = "";
        this.mCurrentUrl = "";
        this.mCurrentDescription = "";
        this.mCurrentTitle = "";
        this.mCurrentImage = null;
        if (this.callback != null) {
            this.callback.clean();
        }
        if (this.mDropPreview != null) {
            this.mDropPreview.setVisibility(8);
        }
    }

    protected void clearText() {
        this.textInput.setText((CharSequence)"");
        this.clean();
    }

    protected void showNoNetworkMessage() {
        if (ForegroundService.getInstance().isBrandForeground()) {
            Toast.makeText((Context)this.getContext(), (int)R.string.lp_no_network_toast_message, (int)1).show();
        }
    }

    protected void sendMessage() {
        String msgStr = this.textInput.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)msgStr)) {
            if (TextUtils.isEmpty((CharSequence)this.mCurrentUrl) || !this.mIsSufficientToDisplayLinkPreview) {
                LPLog.INSTANCE.d(TAG, "url send Message, mIsSufficientToDisplayLinkPreview: " + this.mIsSufficientToDisplayLinkPreview);
                this.sendMessage(msgStr);
            } else {
                LPLog.INSTANCE.d(TAG, "url sendMessageWithURL");
                this.sendMessageWithURL(msgStr, this.mCurrentUrl, this.mCurrentTitle, this.mCurrentImageURL, this.mCurrentDescription, this.mSiteName);
            }
            this.clean();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textInput.setEnabled(enabled);
        this.mAttachBtn.setEnabled(enabled);
        if (enabled) {
            this.updateAttachButton();
        }
        this.updateSendButtonState();
    }

    @Override
    public void onUpdate(boolean isUpdated) {
        this.mIsUpdated = isUpdated;
        this.updateSendButtonState();
    }

    @Override
    public void onConnectionChanged(boolean isConnected) {
        this.mIsConnected = isConnected;
        this.updateAttachButton();
        this.mPhotoSharingKillSwitchEnabled = PreferenceManager.getInstance().getBooleanValue("kill_switch_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        this.mPhotoSharingSiteSettingsEnabled = PreferenceManager.getInstance().getBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", true);
        if (!(Configuration.getBoolean((int)R.bool.enable_photo_sharing) && this.mPhotoSharingKillSwitchEnabled && this.mPhotoSharingSiteSettingsEnabled)) {
            this.mAttachBtn.setVisibility(8);
        } else {
            this.mAttachBtn.setVisibility(0);
        }
    }

    private void setAnimationOnAttachButton() {
        this.mAttachBtn.setInAnimation(this.mAnimationIn);
        this.mAttachBtn.setOutAnimation(this.mAnimationOut);
    }

    private void cancelAnimationOnAttachButton() {
        this.mAttachBtn.setInAnimation(null);
        this.mAttachBtn.setOutAnimation(null);
    }

    protected void updateSendButtonState() {
        if (!this.shouldUpdateSendButton()) {
            return;
        }
        if (this.isContentWaiting() && (this.mIsConnected && this.mIsUpdated || this.mIsOfflineMessagingEnabled) && this.isEnabled()) {
            this.mTextSendButton.setEnabled(true);
            this.mImageSendButton.setEnabled(true);
        } else if (!this.isContentWaiting()) {
            this.mTextSendButton.setEnabled(false);
            this.mImageSendButton.setEnabled(false);
            this.clean();
        } else {
            this.mTextSendButton.setEnabled(false);
            this.mImageSendButton.setEnabled(false);
        }
    }

    public void setIsOfflineMessagingEnabled(boolean isOfflineMessagingEnabled) {
        this.mIsOfflineMessagingEnabled = isOfflineMessagingEnabled;
        if (isOfflineMessagingEnabled) {
            this.updateAttachButton();
        }
    }

    protected boolean isContentWaiting() {
        return !TextUtils.isEmpty((CharSequence)this.textInput.getText().toString().trim());
    }

    private void updateAttachButton() {
        if (this.mIsConnected || this.mIsOfflineMessagingEnabled) {
            this.cancelAnimationOnAttachButton();
            if (this.isEnabled()) {
                this.enableAttachButton();
            }
            this.setAnimationOnAttachButton();
        } else {
            if (this.mOverflowMenu.isMenuOpen()) {
                this.mOverflowMenu.hide();
            }
            this.cancelAnimationOnAttachButton();
            this.disableAttachButton();
        }
    }

    public void setOverflowMenu(IOverflowMenu menu) {
        this.mOverflowMenu = menu;
        this.mOverflowMenu.setOnCloseListener(() -> {});
    }

    private void enableAttachButton() {
        this.mAttachBtn.setEnabled(true);
        this.mAttachBtn.setAlpha(1.0f);
    }

    public void setEnterMessageListener(IEnterMessageListener enterMessageListener) {
        this.mEnterMessageListener = enterMessageListener;
    }

    public String getText() {
        return this.textInput != null ? this.textInput.getText().toString() : "";
    }

    protected void hideSoftKeyboard(@Nullable View focusedView) {
        InputMethodManager imm;
        if (focusedView != null && focusedView.getContext() != null && (imm = (InputMethodManager)focusedView.getContext().getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    public void restoreTypedText() {
        int encryptionVersionNumber;
        EncryptionVersion encryptionVersion;
        String typedText;
        String brandId = this.mBrandIdProvider.getBrandId();
        String message = PreferenceManager.getInstance().getStringValue("KEY_TYPED_TEXT", brandId, "");
        if (PreferenceManager.getInstance().contains(KEY_TYPED_TEXT_ENCRYPT_VERSION, brandId) && !TextUtils.isEmpty((CharSequence)(typedText = DBEncryptionHelper.decrypt((EncryptionVersion)(encryptionVersion = EncryptionVersion.fromInt((int)(encryptionVersionNumber = PreferenceManager.getInstance().getIntValue(KEY_TYPED_TEXT_ENCRYPT_VERSION, brandId, 1)))), (String)message))) && this.textInput != null) {
            this.textInput.setText((CharSequence)typedText);
        }
    }

    public void onBackground() {
        String typedText = this.getText();
        String brandId = this.mBrandIdProvider.getBrandId();
        EncryptionVersion encryptionVersion = DBEncryptionService.Companion.getAppEncryptionVersion();
        String encryptedMessage = DBEncryptionHelper.encrypt((EncryptionVersion)encryptionVersion, (String)typedText);
        PreferenceManager.getInstance().setStringValue("KEY_TYPED_TEXT", brandId, encryptedMessage);
        PreferenceManager.getInstance().setIntValue(KEY_TYPED_TEXT_ENCRYPT_VERSION, brandId, encryptionVersion.ordinal());
    }

    protected void requestFocusOnTextInput() {
        this.textInput.requestFocus();
        this.textInput.setSelection(this.textInput.length());
    }

    protected abstract void sendMessageWithURL(String var1, String var2, String var3, String var4, String var5, String var6);

    protected abstract void sendMessage(String var1);

    protected abstract void onHasText(boolean var1);

    protected abstract void onAfterChangedText(String var1);

    protected abstract void onBeforeChangedText();

    protected abstract boolean shouldUpdateSendButton();

    protected abstract boolean isSpeechRecognitionInProgress();

    protected abstract void stopSpeechRecognitionIfNeeded();

    private static enum InputState {
        HAS_TEXT,
        NONE;

    }
}

