/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.utils.ArithmeticUtilsKt;
import com.liveperson.infra.ui.view.utils.text.LPTextUtils;
import com.liveperson.infra.utils.DateUtils;
import java.util.concurrent.TimeUnit;

public abstract class BaseViewHolder
extends RecyclerView.ViewHolder
implements Runnable {
    private static final long UPDATE_PERIOD = TimeUnit.MINUTES.toMillis(21L);
    private static final long UPDATE_DELAY = TimeUnit.SECONDS.toMillis(15L);
    private static final String TAG = "BaseViewHolder";
    protected TextView mMessageTextView;
    protected TextView mTimestampTextView;
    protected long mTimeStamp;
    private LinkType linkType;
    private OnRequestTimestampUpdateListener listener;

    public BaseViewHolder(View itemView) {
        super(itemView);
        this.mMessageTextView = (TextView)itemView.findViewById(R.id.lpui_message_text);
        this.mTimestampTextView = (TextView)itemView.findViewById(R.id.lpui_message_timestamp);
        this.setupTimestamp();
    }

    protected Context getContext() {
        return this.itemView.getContext();
    }

    public abstract void updateContentDescription();

    public abstract void onUpdateTimestampText();

    public void setMessageTextView(String message) {
        Context context = this.getContext();
        this.mMessageTextView.setText((CharSequence)LPTextUtils.linkifyText(context, message, this.getMarkdownLinkColor()));
        ViewCompat.enableAccessibleClickableSpanSupport((View)this.mMessageTextView);
    }

    public String getTextToCopy() {
        return this.mMessageTextView.getText().toString();
    }

    public void setContentDescription(String message) {
        this.itemView.setContentDescription((CharSequence)message);
        this.itemView.setAccessibilityDelegate(new View.AccessibilityDelegate(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setAccessibilityFocused(false);
            }
        });
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.itemView.setLongClickable(true);
        this.itemView.setOnLongClickListener(onLongClickListener);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.itemView.setClickable(true);
        this.itemView.setOnClickListener(onClickListener);
    }

    protected void setMessageTextOnClickListener(View.OnClickListener onClickListener) {
        this.mMessageTextView.setOnClickListener(onClickListener);
    }

    protected void setMessageTextOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mMessageTextView.setOnLongClickListener(onLongClickListener);
    }

    public void setContextualBehaviorOnClick(View.OnClickListener onClickListener) {
        this.itemView.setClickable(true);
        onClickListener.onClick(this.itemView);
    }

    public boolean setContextualBehaviorOnLongClick(View.OnLongClickListener onClickListener) {
        this.itemView.setLongClickable(true);
        return onClickListener.onLongClick(this.itemView);
    }

    public final void setTimestamp(long timestamp) {
        this.mTimeStamp = timestamp;
        this.onUpdateTimestampText();
    }

    protected void setupTimestamp() {
        if (this.mTimestampTextView != null) {
            if (this.isTimestampEnabled()) {
                this.mTimestampTextView.setVisibility(0);
                this.mTimestampTextView.setTextSize(Configuration.getDimension((int)R.dimen.lp_timestamps_font_size, (int)2));
            } else {
                this.mTimestampTextView.setVisibility(8);
            }
        }
    }

    @SuppressLint(value={"StringFormatMatches"})
    protected String getTimeFormat(long timestamp) {
        boolean isNumericTimestampOnly = Configuration.getBoolean((int)R.bool.message_status_numeric_timestamp_only);
        if (!isNumericTimestampOnly) {
            long timeDiff = System.currentTimeMillis() - timestamp;
            if (timeDiff < 60000L) {
                return this.itemView.getContext().getString(R.string.lp_message_time_now);
            }
            if (timeDiff < 1200000L) {
                long minutes = timeDiff / 60000L;
                return String.format(this.itemView.getContext().getString(R.string.lp_message_time_min_ago), minutes);
            }
        }
        String customTimeFormat = this.itemView.getContext().getString(R.string.lp_time_format);
        return DateUtils.getFormattedTime((String)customTimeFormat, (int)3, (long)timestamp);
    }

    public void applyChanges(Bundle changes, Message message) {
        String newText = changes.getString("EXTRA_MESSAGE_TEXT", null);
        if (!TextUtils.isEmpty((CharSequence)newText)) {
            this.setMessageTextView(newText);
            this.updateContentDescription();
        }
    }

    protected boolean isTimestampEnabled() {
        return Configuration.getBoolean((int)R.bool.lp_enable_timestamps);
    }

    protected boolean isReadReceiptDisabled() {
        return !Configuration.getBoolean((int)R.bool.lp_enable_read_receipts);
    }

    protected boolean shouldUpdateTimestamps() {
        boolean isNumericTimestamp = Configuration.getBoolean((int)R.bool.message_status_numeric_timestamp_only);
        return this.isTimestampEnabled() && !isNumericTimestamp && Math.abs(System.currentTimeMillis() - this.mTimeStamp) < UPDATE_PERIOD;
    }

    public void setRequestTimestampListener(OnRequestTimestampUpdateListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        if (this.listener == null) {
            return;
        }
        this.listener.requestTimestampsUpdate(this.getAdapterPosition());
        if (this.shouldUpdateTimestamps()) {
            this.updateTimestamp(this.getUpdateDelay(), this);
        }
    }

    public void onBind() {
    }

    public void observeTimestampChanges() {
        this.cancelUpdates(this);
        if (this.shouldUpdateTimestamps()) {
            this.updateTimestamp(0L, this);
        }
    }

    public void stopObservingTimestampsChanges() {
        this.cancelUpdates(this);
        this.listener = null;
    }

    public void recycle() {
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public Long getUpdateDelay() {
        return UPDATE_DELAY;
    }

    protected void clearSelection() {
        CharSequence text = this.mMessageTextView.getText();
        if (text instanceof Spannable) {
            Selection.removeSelection((Spannable)((Spannable)text));
        }
    }

    protected int getTimestampAsInteger() {
        return ArithmeticUtilsKt.asIntegerValue(this.mTimeStamp);
    }

    private void updateTimestamp(long delay, Runnable runnable) {
        if (this.listener != null) {
            this.listener.onUpdateTimestampWithDelay(delay, runnable);
        }
    }

    private void cancelUpdates(Runnable runnable) {
        if (this.listener != null) {
            this.listener.cancelTimestampsUpdate(runnable);
        }
    }

    @SuppressLint(value={"AccessibilityFocus"})
    public void moveFocusToItself(long delay) {
        this.itemView.postDelayed(() -> {
            this.itemView.performAccessibilityAction(64, null);
            LPLog.INSTANCE.d(TAG, "moveFocusToLast. isFocused = " + this.itemView.isAccessibilityFocused());
        }, delay);
    }

    protected int getMarkdownLinkColor() {
        return -16776961;
    }

    public static interface OnRequestTimestampUpdateListener {
        public void requestTimestampsUpdate(int var1);

        public void onUpdateTimestampWithDelay(long var1, Runnable var3);

        public void cancelTimestampsUpdate(Runnable var1);
    }

    public static enum LinkType {
        URL,
        PHONE,
        EMAIL,
        NAVIGATION;

    }
}

